/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.Status;

public final class CreateViewOptions {
    long handle;

    CreateViewOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_create_view_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public CreateViewOptions(ScalingMode ScalingMode2) {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_create_view_options_create_scaling_mode_scaling_mode(ScalingMode2, result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_options_release(this.handle));
        this.handle = 0L;
    }

    public ScalingMode getScalingMode() {
        Out<ScalingMode> result = new Out<ScalingMode>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_options_get_scaling_mode(this.handle, result));
        return (ScalingMode)((Object)result.value);
    }

    public CreateViewOptions setScalingMode(ScalingMode value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_create_view_options_set_scaling_mode(this.handle, value));
        return this;
    }

    static CreateViewOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CreateViewOptions, CreateViewOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_create_view_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CreateViewOptions, CreateViewOptions.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

