/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallCaptions;
import com.azure.android.communication.calling.CallFeature;
import com.azure.android.communication.calling.Factories;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Supplier;

public final class CaptionsCallFeature
extends CallFeature {
    private static final ExecutorService executor = Executors.newCachedThreadPool();

    CaptionsCallFeature(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    public CompletableFuture<CallCaptions> getCaptions() {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<CallCaptions>(){

            public CallCaptions get() {
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_captions_call_feature_get_captions(handle, result_handle));
                CallCaptions result_object = Factories.CallCaptionsFactory((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    static CaptionsCallFeature getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CaptionsCallFeature, CaptionsCallFeature.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_feature_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CaptionsCallFeature, CaptionsCallFeature.class, false);
    }
}

