/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.IncomingAudioOptions;
import com.azure.android.communication.calling.IncomingVideoOptions;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.OutgoingAudioOptions;
import com.azure.android.communication.calling.OutgoingVideoOptions;
import com.azure.android.communication.calling.ProjectedObjectCache;

public abstract class CallOptions {
    long handle;

    CallOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_options_release(this.handle));
        this.handle = 0L;
    }

    public IncomingVideoOptions getIncomingVideoOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_options_get_incoming_video_options(this.handle, result_handle));
        IncomingVideoOptions result_object = (Long)result_handle.value != 0L ? IncomingVideoOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallOptions setIncomingVideoOptions(IncomingVideoOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_options_set_incoming_video_options(this.handle, value_converted));
        return this;
    }

    public OutgoingVideoOptions getOutgoingVideoOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_options_get_outgoing_video_options(this.handle, result_handle));
        OutgoingVideoOptions result_object = (Long)result_handle.value != 0L ? OutgoingVideoOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallOptions setOutgoingVideoOptions(OutgoingVideoOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_options_set_outgoing_video_options(this.handle, value_converted));
        return this;
    }

    public IncomingAudioOptions getIncomingAudioOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_options_get_incoming_audio_options(this.handle, result_handle));
        IncomingAudioOptions result_object = (Long)result_handle.value != 0L ? IncomingAudioOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallOptions setIncomingAudioOptions(IncomingAudioOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_options_set_incoming_audio_options(this.handle, value_converted));
        return this;
    }

    public OutgoingAudioOptions getOutgoingAudioOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_options_get_outgoing_audio_options(this.handle, result_handle));
        OutgoingAudioOptions result_object = (Long)result_handle.value != 0L ? OutgoingAudioOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallOptions setOutgoingAudioOptions(OutgoingAudioOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_options_set_outgoing_audio_options(this.handle, value_converted));
        return this;
    }
}

