/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AdmitAllParticipantsResult;
import com.azure.android.communication.calling.AdmitParticipantsResult;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ParticipantsUpdatedEvent;
import com.azure.android.communication.calling.ParticipantsUpdatedListener;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.RemoteParticipant;
import com.azure.android.communication.common.CommunicationIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Supplier;

public final class CallLobby {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;
    private List<ParticipantsUpdatedListener> OnLobbyParticipantsUpdatedListeners = new CopyOnWriteArrayList<ParticipantsUpdatedListener>();

    CallLobby(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_lobby_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    CallLobby(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_lobby_release(this.handle));
        this.handle = 0L;
    }

    public List<RemoteParticipant> getParticipants() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_lobby_get_participants(this.handle, result, result_length));
        ArrayList<RemoteParticipant> resultList = new ArrayList<RemoteParticipant>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(RemoteParticipant.getInstance(resultArray[i], true));
        }
        List<RemoteParticipant> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    private static void OnLobbyParticipantsUpdatedStaticHandler(long cookie, long args) {
        CallLobby instance = CallLobby.getInstance(cookie);
        if (instance != null) {
            ParticipantsUpdatedEvent args_converted = args != 0L ? ParticipantsUpdatedEvent.getInstance(args, false) : null;
            for (ParticipantsUpdatedListener listener : instance.OnLobbyParticipantsUpdatedListeners) {
                listener.onParticipantsUpdated(args_converted);
            }
        }
    }

    public void addOnLobbyParticipantsUpdatedListener(ParticipantsUpdatedListener listener) {
        this.OnLobbyParticipantsUpdatedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnLobbyParticipantsUpdated", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_lobby_set_on_lobby_participants_updated(this.handle, this.getHandle(), this));
    }

    public void removeOnLobbyParticipantsUpdatedListener(ParticipantsUpdatedListener listener) {
        this.OnLobbyParticipantsUpdatedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnLobbyParticipantsUpdated", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_lobby_set_on_lobby_participants_updated(this.handle, 0L, null));
        }
    }

    private CompletableFuture<AdmitParticipantsResult> admitInternal(final String[] participants) {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<AdmitParticipantsResult>(){

            public AdmitParticipantsResult get() {
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_lobby_admit_internal(handle, participants, participants.length, result_handle));
                AdmitParticipantsResult result_object = AdmitParticipantsResult.getInstance((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    private CompletableFuture<Void> rejectInternal(final String participant) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_lobby_reject_internal(handle, participant));
            }
        }, (Executor)executor);
    }

    public CompletableFuture<AdmitAllParticipantsResult> admitAll() {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<AdmitAllParticipantsResult>(){

            public AdmitAllParticipantsResult get() {
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_call_lobby_admit_all(handle, result_handle));
                AdmitAllParticipantsResult result_object = AdmitAllParticipantsResult.getInstance((Long)result_handle.value, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    static CallLobby getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallLobby, CallLobby.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_lobby_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallLobby, CallLobby.class, false);
    }

    private static CallLobby getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallLobby, CallLobby.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnLobbyParticipantsUpdated")) {
            this.addOnLobbyParticipantsUpdatedListener((ParticipantsUpdatedListener)eventListener);
        }
    }

    public CompletableFuture<AdmitParticipantsResult> admit(Iterable<CommunicationIdentifier> participants) {
        String[] participantsStrings = IdentifierHelpers.convertIdentifiersToMris(participants);
        return this.admitInternal(participantsStrings);
    }

    public CompletableFuture<Void> reject(CommunicationIdentifier participant) {
        String participantString = IdentifierHelpers.toMRI(participant);
        return this.rejectInternal(participantString);
    }
}

