/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.CallDiagnosticsOptions;
import com.azure.android.communication.calling.CallNetworkOptions;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class CallClientOptions {
    long handle;

    CallClientOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_client_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public CallClientOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_call_client_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_options_release(this.handle));
        this.handle = 0L;
    }

    public CallDiagnosticsOptions getDiagnostics() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_options_get_diagnostics(this.handle, result_handle));
        CallDiagnosticsOptions result_object = (Long)result_handle.value != 0L ? CallDiagnosticsOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallClientOptions setDiagnostics(CallDiagnosticsOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_options_set_diagnostics(this.handle, value_converted));
        return this;
    }

    public CallNetworkOptions getNetwork() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_options_get_network(this.handle, result_handle));
        CallNetworkOptions result_object = (Long)result_handle.value != 0L ? CallNetworkOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public CallClientOptions setNetwork(CallNetworkOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_client_options_set_network(this.handle, value_converted));
        return this;
    }

    static CallClientOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallClientOptions, CallClientOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_call_client_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.CallClientOptions, CallClientOptions.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

