/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioStreamState;
import com.azure.android.communication.calling.AudioStreamType;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.StreamDirection;

public abstract class CallAudioStream {
    long handle;

    CallAudioStream(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_call_audio_stream_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_audio_stream_release(this.handle));
        this.handle = 0L;
    }

    public AudioStreamType getType() {
        Out<AudioStreamType> result = new Out<AudioStreamType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_audio_stream_get_type(this.handle, result));
        return (AudioStreamType)((Object)result.value);
    }

    public AudioStreamState getState() {
        Out<AudioStreamState> result = new Out<AudioStreamState>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_audio_stream_get_state(this.handle, result));
        return (AudioStreamState)((Object)result.value);
    }

    public StreamDirection getDirection() {
        Out<StreamDirection> result = new Out<StreamDirection>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_call_audio_stream_get_direction(this.handle, result));
        return (StreamDirection)((Object)result.value);
    }
}

