/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.player;

import android.os.Handler;
import com.skype.android.video.player.ISubtitlesBinding;
import com.skype.android.video.player.SubtitlesBinding;

public class UiSubtitlesBinding
implements ISubtitlesBinding.Callback {
    private final Handler handler;
    private final Callback cb;
    private SubtitlesBinding nativeBinding;
    private boolean isStarted = false;
    private boolean isStopped = false;
    private boolean canUseBinding = false;
    private SelectTrackArgs pendingSelectTrack;

    public UiSubtitlesBinding(Handler handler, Callback cb) {
        this.handler = handler;
        this.cb = cb;
    }

    public BindingParams setup() {
        if (this.isStarted) {
            throw new IllegalStateException("can not setup twice");
        }
        this.isStarted = true;
        this.nativeBinding = new SubtitlesBinding(this);
        return this.getBindingParams(this.nativeBinding);
    }

    public BindingParams destroy() {
        if (!this.isStarted || this.isStopped) {
            throw new IllegalStateException("can not destroy twice or before setup");
        }
        this.isStopped = true;
        this.canUseBinding = false;
        return this.getBindingParams(this.nativeBinding);
    }

    public void selectTrack(String tag, String format) {
        if (this.canUseBinding) {
            this.nativeBinding.selectTrack(tag, format);
        } else if (!this.isStopped) {
            this.pendingSelectTrack = new SelectTrackArgs(tag, format);
        }
    }

    public void onBindingCreated(long binding) {
        this.handler.post(new Runnable(){

            public void run() {
                UiSubtitlesBinding.this.canUseBinding = UiSubtitlesBinding.this.isStarted && !UiSubtitlesBinding.this.isStopped;
                UiSubtitlesBinding.this.applyPendingCalls();
            }
        });
    }

    public void onBindingReleased() {
        this.nativeBinding.dispose();
    }

    public void onBindingFailed() {
        this.nativeBinding.dispose();
        this.handler.post(new Runnable(){

            public void run() {
                UiSubtitlesBinding.this.cb.onBindingFailed();
            }
        });
    }

    public void onTrackText(final String subtitleJson) {
        this.handler.post(new Runnable(){

            public void run() {
                if (UiSubtitlesBinding.this.canUseBinding) {
                    UiSubtitlesBinding.this.cb.onTrackText(subtitleJson);
                }
            }
        });
    }

    private BindingParams getBindingParams(SubtitlesBinding pb) {
        BindingParams params = new BindingParams();
        params.type = pb.getNativeBindingType();
        params.event = pb.getNativeBindingEvent();
        return params;
    }

    private void applyPendingCalls() {
        if (!this.canUseBinding) {
            return;
        }
        if (this.pendingSelectTrack != null) {
            this.selectTrack(this.pendingSelectTrack.tag, this.pendingSelectTrack.format);
            this.pendingSelectTrack = null;
        }
    }

    private class SelectTrackArgs {
        public final String tag;
        public final String format;

        public SelectTrackArgs(String tag, String format) {
            this.tag = tag;
            this.format = format;
        }
    }

    public static interface Callback {
        public void onTrackText(String var1);

        public void onBindingFailed();
    }

    public class BindingParams {
        public int type;
        public long event;
    }
}

