/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.extension.encoder;

import com.skype.android.video.hw.codec.encoder.sample.VideoSampleEncoder;
import com.skype.android.video.hw.extension.JniCodecUtils;
import com.skype.android.video.hw.extension.encoder.AbstractVideoEncoderExtension;
import com.skype.android.video.hw.extension.encoder.VideoEncoderExtensionFactory;
import com.skype.android.video.hw.frame.InputFrame;
import com.skype.android.video.hw.frame.OutputFrame;
import com.skype.android.video.hw.utils.DebugUtils;
import com.skype.android.video.hw.utils.EncoderAttributes;
import com.skype.android.video.hw.utils.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoSampleEncoderExtension
extends AbstractVideoEncoderExtension<VideoSampleEncoder> {
    public VideoSampleEncoderExtension(int encoderIndex) {
        super(encoderIndex);
    }

    @Override
    protected VideoSampleEncoder doCreateEncoder(String encoderName) {
        return new VideoSampleEncoder(encoderName);
    }

    @Override
    protected void doCloseEncoder() {
        ((VideoSampleEncoder)this.getEncoder()).close();
    }

    @Override
    protected OutputFrame doEncodeFrame(long timeoutUs, long nativeFrameContext, long ts, boolean drainOnly) {
        OutputFrame retVal = null;
        if (!drainOnly) {
            InputFrame inputFrame = ((VideoSampleEncoder)this.getEncoder()).getInputFrame(timeoutUs);
            inputFrame.setTimestamp((ts - this.getInitialTimestamp()) * 1000L);
            inputFrame.setSize(this.getRawFrameSize());
            try {
                JniCodecUtils.fillInputFrameBuffer(nativeFrameContext, inputFrame.getData(), this.getRawFrameSize(), true);
            }
            catch (RuntimeException e) {
                if (Log.isLoggable("SLIQ", 6)) {
                    Log.e("SLIQ", "fillInputFrameBuffer throw exception ", e);
                }
                return null;
            }
            retVal = ((VideoSampleEncoder)this.getEncoder()).encode(inputFrame, timeoutUs, false);
        } else {
            retVal = ((VideoSampleEncoder)this.getEncoder()).encode(null, timeoutUs, true);
        }
        return retVal;
    }

    public static VideoSampleEncoderExtension createStatic(int encoderIndex) {
        return new VideoSampleEncoderExtension(encoderIndex);
    }

    @Override
    public int init(String attr, boolean isReinitializing) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() called");
            Log.d("SLIQ", attr);
        }
        try {
            EncoderAttributes attributes = new EncoderAttributes(attr);
            int width = attributes.getInteger("width");
            if (width <= 0) {
                throw new EncoderAttributes.AttributeException("width is illegal: " + width);
            }
            int height = attributes.getInteger("height");
            if (height <= 0) {
                throw new EncoderAttributes.AttributeException("height is illegal: " + width);
            }
            width = width + 15 & 0xFFF0;
            height = height + 15 & 0xFFF0;
            attributes.put("width", width);
            attributes.put("height", height);
            int orgwidth = attributes.getInteger("org-width", 0);
            int orgheight = attributes.getInteger("org-height", 0);
            orgwidth = orgwidth + 15 & 0xFFF0;
            orgheight = orgheight + 15 & 0xFFF0;
            attributes.put("org-width", orgwidth);
            attributes.put("org-height", orgheight);
            return super.initInternal(attributes, isReinitializing, false, null);
        }
        catch (EncoderAttributes.AttributeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Illegal attribute value", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_INCORRECT_PARAM");
            }
            return -9;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.getClass().getCanonicalName() + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            return -1;
        }
    }

    public static class Factory
    implements VideoEncoderExtensionFactory {
        public VideoSampleEncoderExtension create(int encoderIndex) {
            return new VideoSampleEncoderExtension(encoderIndex);
        }
    }
}

