/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.gl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLObjectHandle;
import android.opengl.EGLSurface;
import com.skype.android.video.hw.codec.encoder.camera.gl.Context;
import com.skype.android.video.hw.codec.encoder.camera.gl.EGLUtils;
import com.skype.android.video.hw.codec.encoder.camera.gl.GLException;
import com.skype.android.video.hw.codec.encoder.camera.gl.SurfaceTextureRenderer;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.utils.Log;
import java.io.Closeable;

public abstract class AbstractRenderingTarget
implements Closeable {
    private Events eventsListener;
    protected Context context;
    private TargetSurface targetSurface;
    private boolean isEnabled;
    private boolean isHorizFlipped;
    private boolean isVertFlipped;
    private int rotationAngle;
    private float fitFactor;
    private float targetFrameRate;
    private long delayedTimestamp;
    private final String simpleClassName = this.getClass().getSimpleName();

    protected abstract void doInitialBinding() throws GLException;

    protected AbstractRenderingTarget(Context sharedContext, int[] eglConfigAttributes, Events eventsListener) throws GLException {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Creating");
        }
        this.eventsListener = eventsListener;
        this.context = new Context(sharedContext, eglConfigAttributes);
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + ": Created");
        }
    }

    void onFrameReady(long timestamp) {
        if (this.eventsListener != null) {
            this.eventsListener.onFrameRendered(timestamp);
        }
    }

    public void setSurface(Object surface, Resolution resolution) throws GLException {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Setting " + surface + " at " + resolution);
        }
        this.unsetSurface();
        this.targetSurface = new TargetSurface(surface, resolution);
        this.doInitialBinding();
    }

    public void unsetSurface() {
        if (this.targetSurface != null) {
            this.targetSurface.close();
            this.targetSurface = null;
        }
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setFitFactor(float fitFactor) {
        this.fitFactor = fitFactor;
    }

    public float getFitFactor() {
        return this.fitFactor;
    }

    public void setRotationAngle(int rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public int getRotationAngle() {
        return this.rotationAngle;
    }

    public void setFlipped(boolean isHorizFlipped, boolean isVertFlipped) {
        this.isHorizFlipped = isHorizFlipped;
        this.isVertFlipped = isVertFlipped;
    }

    public boolean isHorizFlipped() {
        return this.isHorizFlipped;
    }

    public boolean isVertFlipped() {
        return this.isVertFlipped;
    }

    public Resolution getResolution() {
        if (this.targetSurface == null) {
            throw new IllegalStateException("no targetSurface set");
        }
        return this.targetSurface.getResolution();
    }

    public Object getSurface() {
        if (this.targetSurface == null) {
            throw new IllegalStateException("no targetSurface set");
        }
        return this.targetSurface.getSurface();
    }

    public boolean hasSurface() {
        return this.targetSurface != null;
    }

    public boolean isBound() {
        if (this.targetSurface == null) {
            throw new IllegalStateException("no targetSurface set");
        }
        return this.targetSurface.isBound();
    }

    public void bind() throws GLException {
        if (this.targetSurface == null) {
            throw new IllegalStateException("no targetSurface set");
        }
        this.targetSurface.bind();
    }

    public void unbind() throws GLException {
        if (this.targetSurface == null) {
            throw new IllegalStateException("no targetSurface set");
        }
        this.targetSurface.unbind();
    }

    public boolean swapBuffers() throws GLException {
        if (this.targetSurface == null) {
            throw new IllegalStateException("no targetSurface set");
        }
        return this.targetSurface.swapBuffers();
    }

    public void setTimestamp(long timestamp) throws GLException {
        if (this.targetSurface == null) {
            throw new IllegalStateException("no targetSurface set");
        }
        this.targetSurface.setTimestamp(timestamp);
    }

    public void setDelayedTimestmap(long timestamp) {
        this.delayedTimestamp = timestamp;
    }

    public long getDelayedTimestamp() {
        return this.delayedTimestamp;
    }

    public void close() {
        if (this.context != null) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", this.simpleClassName + ": Closing");
            }
            this.unsetSurface();
            this.context.close();
            this.context = null;
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + ": Closed");
            }
        }
        this.eventsListener = null;
    }

    protected boolean isBoundAny() {
        return EGL14.eglGetCurrentContext() != EGL14.EGL_NO_CONTEXT && EGL14.eglGetCurrentSurface((int)12377) != EGL14.EGL_NO_SURFACE;
    }

    public String toString() {
        return this.simpleClassName + " [context=" + this.context + ", targetSurface=" + this.targetSurface + ", isEnabled=" + this.isEnabled + ", isHorizFlipped=" + this.isHorizFlipped + ", isVertFlipped=" + this.isVertFlipped + ", rotationAngle=" + this.rotationAngle + "]";
    }

    protected EGLSurface doCreateEGLSurface(Object surface, Resolution resolution) {
        int[] attributes = new int[]{12344};
        return EGL14.eglCreateWindowSurface((EGLDisplay)this.context.getEGLDisplay(), (EGLConfig)this.context.getEGLConfig(), (Object)surface, (int[])attributes, (int)0);
    }

    public void setTargetFrameRate(float targetFrameRate) {
        this.targetFrameRate = targetFrameRate;
    }

    public float getTargetFrameRate() {
        return this.targetFrameRate;
    }

    private class TargetSurface
    implements Closeable {
        private EGLSurface eglSurface = EGL14.EGL_NO_SURFACE;
        private Object surface;
        private Resolution resolution;

        public TargetSurface(Object surface, Resolution resolution) throws GLException {
            if (resolution == null) {
                throw new IllegalArgumentException("resolution is null");
            }
            this.surface = surface;
            this.resolution = resolution;
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", AbstractRenderingTarget.this.simpleClassName + ": Creating EGL surface for " + surface);
            }
            this.eglSurface = AbstractRenderingTarget.this.doCreateEGLSurface(surface, resolution);
            EGLUtils.validate("Failed to create EGL surface.");
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", AbstractRenderingTarget.this.simpleClassName + ": EGL surface " + Integer.toHexString(System.identityHashCode(this.eglSurface)) + " created with " + surface);
            }
        }

        public void close() {
            if (this.eglSurface != null) {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", AbstractRenderingTarget.this.simpleClassName + ": Destroying EGL surface " + EGLUtils.idStringOf((EGLObjectHandle)this.eglSurface));
                }
                if (!EGL14.eglDestroySurface((EGLDisplay)AbstractRenderingTarget.this.context.getEGLDisplay(), (EGLSurface)this.eglSurface) && Log.isLoggable("SLIQ", 5)) {
                    Log.w("SLIQ", AbstractRenderingTarget.this.simpleClassName + ": Failed to destroy EGL surface " + EGLUtils.idStringOf((EGLObjectHandle)this.eglSurface) + ". Error: " + Integer.toHexString(EGL14.eglGetError()));
                }
                this.eglSurface = EGL14.EGL_NO_SURFACE;
            }
            this.surface = null;
            this.resolution = null;
        }

        public Resolution getResolution() {
            return this.resolution;
        }

        public void setResolution(Resolution resolution) {
            this.resolution = resolution;
        }

        public Object getSurface() {
            return this.surface;
        }

        public boolean isBound() {
            return this.eglSurface.equals((Object)EGL14.eglGetCurrentSurface((int)12377));
        }

        public void bind() throws GLException {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", AbstractRenderingTarget.this.simpleClassName + ": Binding EGL surface " + Integer.toHexString(System.identityHashCode(this.eglSurface)));
            }
            EGL14.eglMakeCurrent((EGLDisplay)AbstractRenderingTarget.this.context.getEGLDisplay(), (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)AbstractRenderingTarget.this.context.getEGLContext());
            EGLUtils.validate("Failed to bind the surface.");
        }

        public void unbind() throws GLException {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", AbstractRenderingTarget.this.simpleClassName + ": Unbinding EGL surface " + Integer.toHexString(System.identityHashCode(this.eglSurface)));
            }
            EGL14.eglMakeCurrent((EGLDisplay)AbstractRenderingTarget.this.context.getEGLDisplay(), (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGLUtils.validate("Failed to unbind the surface.");
        }

        public boolean swapBuffers() throws GLException {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", AbstractRenderingTarget.this.simpleClassName + ": Swapping buffers of EGL surface " + Integer.toHexString(System.identityHashCode(this.eglSurface)));
            }
            boolean result = EGL14.eglSwapBuffers((EGLDisplay)AbstractRenderingTarget.this.context.getEGLDisplay(), (EGLSurface)this.eglSurface);
            EGLUtils.validate("Failed to swap buffers.");
            return result;
        }

        public void setTimestamp(long timestamp) throws GLException {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)AbstractRenderingTarget.this.context.getEGLDisplay(), (EGLSurface)this.eglSurface, (long)timestamp);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", SurfaceTextureRenderer.class.getSimpleName() + ": current frame surface timestamp " + timestamp + " ns");
            }
            EGLUtils.validate("Failed to set timestamp.");
        }

        public String toString() {
            return AbstractRenderingTarget.this.simpleClassName + " [eglSurface=" + this.eglSurface + ", surface=" + this.surface + ", resolution=" + this.resolution + "]";
        }
    }

    public static interface Events {
        public void onFrameRendered(long var1);
    }
}

