/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.skype.android.video.hw.codec.OmxWrapper;
import com.skype.android.video.hw.format.H264Level;
import com.skype.android.video.hw.format.H264Profile;
import com.skype.android.video.hw.utils.Log;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractOmxWrapper
implements OmxWrapper {
    public static final int MAGIC_FAILURE_CONSTANT = -1;
    protected static final Lock lock = new ReentrantLock(true);
    final String hwCodecName;
    final String dummyName;
    private long driverVersion = 0L;
    private int oldNodeId;
    private int newNodeId;

    public AbstractOmxWrapper(String codecName, String dummyComponentName) {
        this.hwCodecName = codecName;
        this.dummyName = dummyComponentName;
    }

    public int setDriverVersion(long drvVer) {
        this.driverVersion = drvVer;
        return 0;
    }

    public long getDriverVersion() {
        return this.driverVersion;
    }

    private int preAllocate() {
        lock.lock();
        int oldNodeId = -1;
        try {
            oldNodeId = this.incrementAndGetNodeId();
        }
        finally {
            Log.i("SLIQ", "old node ID: " + oldNodeId);
        }
        return oldNodeId;
    }

    private int postAllocate() {
        int newNodeId = -1;
        try {
            newNodeId = this.incrementAndGetNodeId();
        }
        finally {
            Log.i("SLIQ", "new node ID: " + newNodeId);
            lock.unlock();
        }
        return newNodeId;
    }

    protected abstract int incrementAndGetNodeId();

    public final MediaCodec createTracked() {
        MediaCodec codec;
        try {
            this.oldNodeId = this.preAllocate();
            codec = MediaCodec.createByCodecName((String)this.hwCodecName);
        }
        catch (IOException e) {
            codec = null;
            e.printStackTrace();
        }
        finally {
            this.newNodeId = this.postAllocate();
        }
        return codec;
    }

    public boolean isNodeIdKnown() {
        return this.oldNodeId != -1 && this.newNodeId != -1 && this.newNodeId - 1 == this.oldNodeId + 1;
    }

    public int getNodeId() {
        if (!this.isNodeIdKnown()) {
            throw new IllegalStateException("Node ID not determined");
        }
        return this.oldNodeId + 1;
    }

    public int configureEncoder(MediaFormat format, int rcMode, int refCount, int numChannels, int baseLayerPriorityId, int minNumSlices, boolean svcAlways) {
        int colorFormat = format.getInteger("color-format");
        int width = format.getInteger("width");
        int height = format.getInteger("height");
        int bitrate = format.getInteger("bitrate");
        int framerate = format.getInteger("frame-rate");
        int iFrameInt = format.containsKey("i-frame-interval") ? format.getInteger("i-frame-interval") : 0;
        int profile = format.containsKey("profile") ? format.getInteger("profile") : H264Profile.BASELINE.getOmxValue().intValue();
        int level = format.containsKey("level") ? format.getInteger("level") : H264Level.L3.getOmxValue().intValue();
        return this.configureEncoder(rcMode, refCount, numChannels, baseLayerPriorityId, minNumSlices, svcAlways, colorFormat, width, height, bitrate, framerate, iFrameInt, profile, level);
    }

    public int setQp(int qp) {
        return this.doSetQp(this.getNodeId(), qp);
    }

    protected abstract int doSetQp(int var1, int var2);

    public int setNumTempLayers(int numTempLayers) {
        return this.doSetNumTempLayers(this.getNodeId(), numTempLayers);
    }

    protected abstract int doSetNumTempLayers(int var1, int var2);

    public int setBaseLayerPID(int baseLayerPID) {
        return this.doSetBaseLayerPID(this.getNodeId(), baseLayerPID);
    }

    protected abstract int doSetBaseLayerPID(int var1, int var2);

    public int markLtrFrame(int longTermFrameIdx) {
        return this.doMarkLtrFrame(this.getNodeId(), longTermFrameIdx);
    }

    protected abstract int doMarkLtrFrame(int var1, int var2);

    public int useLTRFrame(int useLTRFrameIdxBitMap) {
        return this.doUseLTRFrame(this.getNodeId(), useLTRFrameIdxBitMap);
    }

    protected abstract int doUseLTRFrame(int var1, int var2);

    protected abstract int configureEncoder(int var1, int var2, int var3, int var4, int var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    public int queryDriverVersion() {
        return this.doQueryDriverVersion(this.getNodeId());
    }

    protected abstract int doQueryDriverVersion(int var1);

    public int queryDriverVersionAndCheckVerSystem() {
        return this.doQueryDriverVersionAndCheckVerSystem(this.getNodeId());
    }

    protected abstract int doQueryDriverVersionAndCheckVerSystem(int var1);
}

