/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc.omx.data;

import android.os.Build;
import android.os.Parcel;
import com.skype.android.jipc.Struct;
import com.skype.android.jipc.omx.OmxVersion;
import com.skype.android.jipc.omx.enums.OmxIndex;

public abstract class OmxStruct
extends Struct
implements OmxVersion {
    static final boolean PARAM_SIZE_INT64 = Build.VERSION.SDK_INT >= 21;
    private final OmxIndex index;
    public final Struct.IntField sizeHdr = new Struct.IntField(this, 0);
    public final Struct.IntField version = new Struct.IntField(this, 1);
    public static final int FIRST_USER_FIELD = 2;

    protected OmxStruct(OmxIndex index, int wordCount) {
        this(false, index, wordCount);
    }

    protected OmxStruct(boolean direct, OmxIndex index, int wordCount) {
        super(direct, wordCount);
        this.index = index;
        this.intBuffer.put(0, this.size());
        this.resetOmxVersion();
    }

    public void reset() {
        super.reset();
        this.intBuffer.put(0, this.size());
        this.resetOmxVersion();
    }

    public void prepare(Parcel in) {
        in.writeInt(this.index.value());
        if (PARAM_SIZE_INT64) {
            in.writeLong((long)this.size());
        } else {
            in.writeInt(this.size());
        }
        super.prepare(in);
    }

    public OmxIndex getIndex() {
        return this.index;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof OmxStruct && ((OmxStruct)obj).getIndex().value() == this.getIndex().value() && super.equals(obj);
    }

    public void resetOmxVersion() {
        this.setOmxVersion(this.index.getVersionMajor(), this.index.getVersionMinor());
    }

    public void setOmxVersion(int major, int minor) {
        this.intBuffer.put(1, 0);
        this.rawBuffer.put(4, (byte)major);
        this.rawBuffer.put(5, (byte)minor);
    }

    public int getVersionMajor() {
        return this.rawBuffer.get(4);
    }

    public int getVersionMinor() {
        return this.rawBuffer.get(5);
    }
}

