/*
 * Decompiled with CFR 0.152.
 */
package com.skype.rt;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.net.TrafficStats;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.PowerManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.skype.rt.ConnectivityChangeReceiver;
import com.skype.rt.JniNetworkParams;
import com.skype.rt.KeyStoreWrap;
import com.skype.rt.LeakChecker;
import com.skype.rt.NetInterface;
import com.skype.rt.NetIntf;
import com.skype.rt.PowerReceiver;
import com.skype.rt.ProxyInfo;
import com.skype.rt.RtContext;
import com.skype.rt.WiFiNetworkState;
import com.skype.rt.WiFiNetworkStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RootToolsHandler
extends RtContext {
    private static final String TAG = "rt::";
    private static final boolean DBG = false;
    private static RootToolsHandler m_this = null;
    private NetIntf m_netIntf;
    private HashSet m_paths;
    private HandlerThread m_handlerThread;
    private Handler m_handler;
    private LeakChecker m_leakChecker;
    private KeyStoreWrap m_ksw;
    private final ExecutorService m_executor;

    public static Object createHandler() {
        m_this = new RootToolsHandler();
        m_this.getContext();
        return m_this;
    }

    public static void dropHandler() {
        if (m_this != null) {
            RootToolsHandler ri = m_this;
            if (ri.m_netIntf != null) {
                ri.m_netIntf.finish();
                ri.m_netIntf = null;
            }
            if (ri.m_handlerThread != null) {
                ri.m_handlerThread.quit();
                ri.m_handlerThread = null;
                ri.m_handler = null;
            }
            if (ri.m_executor != null) {
                ri.m_executor.shutdown();
            }
        }
        m_this = null;
    }

    private RootToolsHandler() {
        Log.v((String)TAG, (String)("SDK_INT: " + String.valueOf(Build.VERSION.SDK_INT)));
        this.m_executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.m_netIntf = new NetInterface(this.m_executor);
        this.m_paths = new HashSet();
        this.m_handlerThread = new HandlerThread("RT receiver");
        this.m_handlerThread.start();
        this.m_handler = new Handler(this.m_handlerThread.getLooper());
        this.m_leakChecker = new LeakChecker();
        this.m_ksw = new KeyStoreWrap();
    }

    public byte[] getGateway(byte[] ip) {
        return this.m_netIntf.getGateway(ip);
    }

    public JniNetworkParams activeConnectionType() {
        return this.m_netIntf.getActiveConnectionInfo();
    }

    public int uiModeType() {
        Configuration config = RootToolsHandler.getContext().getResources().getConfiguration();
        return config.uiMode & 0xF;
    }

    public int screenLayoutSize() {
        Configuration config = RootToolsHandler.getContext().getResources().getConfiguration();
        return config.screenLayout & 0xF;
    }

    public Object registerPowerReceiver() {
        PowerReceiver pr = new PowerReceiver(this);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
        filter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        filter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
        if (Build.VERSION.SDK_INT >= 23) {
            filter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        }
        RootToolsHandler.getContext().registerReceiver((BroadcastReceiver)pr, filter, null, this.m_handler);
        return pr;
    }

    public void unregisterPowerReceiver(Object obj) {
        RootToolsHandler.getContext().unregisterReceiver((BroadcastReceiver)((PowerReceiver)((Object)obj)));
    }

    public int getPowerStatus() {
        if (Build.VERSION.SDK_INT >= 23) {
            PowerManager pm = (PowerManager)RootToolsHandler.getContext().getSystemService("power");
            return pm.isDeviceIdleMode() ? 1 : 0;
        }
        return -1;
    }

    public int[] getPowerSourceInfo() {
        int[] ret = new int[]{-1, -1, -1};
        boolean isPlugged = false;
        Intent intent = RootToolsHandler.getContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int plugged = intent.getIntExtra("plugged", -1);
        isPlugged |= plugged == 1;
        isPlugged |= plugged == 2;
        ret[0] = this.getPowerSourceStatus(isPlugged |= plugged == 4);
        int lvl = intent.getIntExtra("level", 0);
        int scl = intent.getIntExtra("scale", -1);
        ret[1] = scl <= 0 ? 0 : 100 * lvl / scl;
        BatteryManager bm = (BatteryManager)RootToolsHandler.getContext().getSystemService("batterymanager");
        int charge = bm.getIntProperty(1);
        int capacity = bm.getIntProperty(4);
        long energy = bm.getLongProperty(5);
        if (charge > 0 && capacity > 0 && energy > 0L) {
            ret[2] = (int)(energy / 1000000L * (long)charge * 100L / (long)capacity);
        }
        return ret;
    }

    public int getPowerSourceStatus(boolean isPlugged) {
        PowerManager pm = (PowerManager)RootToolsHandler.getContext().getSystemService("power");
        boolean isSaver = pm.isPowerSaveMode();
        return isPlugged ? (isSaver ? 1 : 0) : (isSaver ? 3 : 2);
    }

    public native void notifyPowerEvent(boolean var1, int var2);

    public Object registerConnectivityChangeReceiver(int writeFd) {
        if (Build.VERSION.SDK_INT >= 28) {
            Integer wfd = writeFd;
            this.m_netIntf.registerNetworkCallbacks(wfd);
            return wfd;
        }
        ConnectivityChangeReceiver ccr = new ConnectivityChangeReceiver(writeFd, this);
        RootToolsHandler.getContext().registerReceiver((BroadcastReceiver)ccr, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"), null, this.m_handler);
        return ccr;
    }

    public void unregisterConnectivityChangeReceiver(Object obj) {
        if (Build.VERSION.SDK_INT >= 28) {
            this.m_netIntf.unregisterNetworkCallbacks((Integer)obj);
        } else {
            RootToolsHandler.getContext().unregisterReceiver((BroadcastReceiver)((ConnectivityChangeReceiver)((Object)obj)));
        }
    }

    public void listInterfaces(int writeFd) {
        JniNetworkParams[] intfs = Build.VERSION.SDK_INT >= 28 ? this.m_netIntf.getConnections() : this.m_netIntf.getConnectionInfos();
        RootToolsHandler.callbackListInterfaces(writeFd, intfs.length, intfs);
    }

    public WiFiNetworkStatus getWiFiNetworkStatus() {
        WifiManager wm = RootToolsHandler.getWifiManager();
        if (wm.isWifiEnabled()) {
            WifiInfo inf = wm.getConnectionInfo();
            String hwAddress = inf.getMacAddress();
            String ssid = inf.getSSID();
            String bssid = inf.getBSSID();
            int linkSpeed = inf.getLinkSpeed();
            int freq = inf.getFrequency();
            return new WiFiNetworkStatus(true, hwAddress, ssid, bssid, linkSpeed, freq);
        }
        return new WiFiNetworkStatus(false, "", "", "", 0, 0);
    }

    public WiFiNetworkState getWiFiNetworkState() {
        WifiManager wm = RootToolsHandler.getWifiManager();
        if (wm.isWifiEnabled()) {
            WifiInfo inf = wm.getConnectionInfo();
            int freq = inf.getFrequency();
            int rssi = inf.getRssi();
            return new WiFiNetworkState(freq, rssi);
        }
        return new WiFiNetworkState(0, 0);
    }

    public static native void callbackListInterfaces(int var0, int var1, JniNetworkParams[] var2);

    public void dumpLocalReferenceTables() {
        Log.v((String)TAG, (String)"JNI dump start: 1st pass\n");
        this.m_leakChecker.dumpReferenceTables();
        Log.v((String)TAG, (String)"JNI dump end: 1st pass\n");
        try {
            Process process = Runtime.getRuntime().exec("logcat -d");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.m_leakChecker.extractLocalReferenceTableFromLog(bufferedReader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String dumpAndCompareLocalReferenceTables() {
        Log.v((String)TAG, (String)"JNI dump start: 2nd pass\n");
        this.m_leakChecker.dumpReferenceTables();
        Log.v((String)TAG, (String)"JNI dump end: 2nd pass\n");
        try {
            Process process = Runtime.getRuntime().exec("logcat -d");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.m_leakChecker.extractLocalReferenceTableFromLog(bufferedReader);
            return this.m_leakChecker.popAndCompareLatestDumps();
        }
        catch (IOException iOException) {
            return "BAD: leak check failed because of IOException\n";
        }
    }

    public String[] pickInterface(int type, String remoteAddr) {
        return this.m_netIntf.pickInterface(type, remoteAddr);
    }

    public void dropInterface(int type) {
        this.m_netIntf.dropInterface(type);
    }

    public String getDataDirectoryPath() {
        try {
            return RootToolsHandler.getContext().getApplicationInfo().dataDir;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTempDirectoryPath() {
        try {
            return RootToolsHandler.getContext().getCacheDir().getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSecureDirectoryPath() {
        try {
            return RootToolsHandler.getContext().getFilesDir().getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] fingerprintInfo() {
        String[] fpFields = new String[6];
        try {
            fpFields[0] = Settings.Secure.getString((ContentResolver)RootToolsHandler.getContext().getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 29) {
            fpFields[1] = this.m_ksw.id();
        } else {
            fpFields[1] = Build.SERIAL;
            fpFields[2] = Build.getRadioVersion();
            TelephonyManager mgr = (TelephonyManager)RootToolsHandler.getContext().getSystemService("phone");
            if (mgr != null) {
                fpFields[3] = mgr.getDeviceId();
                fpFields[4] = mgr.getSimSerialNumber();
                fpFields[5] = mgr.getSubscriberId();
            }
        }
        return fpFields;
    }

    public long[] getNetworkStats() {
        long[] result = new long[]{TrafficStats.getTotalTxBytes(), TrafficStats.getTotalTxPackets(), TrafficStats.getTotalRxBytes(), TrafficStats.getTotalRxPackets()};
        return result;
    }

    public AssetManager getAssetManager() {
        return RootToolsHandler.getContext().getAssets();
    }

    public ProxyInfo[] getProxyInfo(String url) {
        try {
            URI uri = new URI(url);
            ProxySelector defaultSelector = ProxySelector.getDefault();
            List<Proxy> proxies = defaultSelector.select(uri);
            ProxyInfo[] retVal = new ProxyInfo[proxies.size()];
            int i = 0;
            for (Proxy proxy : proxies) {
                if (proxy.type() == Proxy.Type.DIRECT) {
                    retVal[i++] = new ProxyInfo("null", 1, 0);
                    continue;
                }
                retVal[i++] = new ProxyInfo(((InetSocketAddress)proxy.address()).getHostName(), ((InetSocketAddress)proxy.address()).getPort(), proxy.type().ordinal());
            }
            return retVal;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

