/*
 * Decompiled with CFR 0.152.
 */
package com.skype.rt;

import android.annotation.TargetApi;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.RouteInfo;
import android.os.Build;
import android.util.Log;
import com.skype.rt.JniNetworkParams;
import com.skype.rt.NetIntf;
import com.skype.rt.RootToolsHandler;
import com.skype.rt.RtContext;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;

@TargetApi(value=21)
public class NetInterface
extends RtContext
implements NetIntf {
    private static final String TAG = "rt.ni::";
    private HashMap<Integer, NetworkCallback> callbackMap = new HashMap();
    private HashMap<Integer, Integer> typeToTransportMap = new HashMap();
    private GenericNetworkCallback genericNetworkCallback = null;
    private HashMap<Network, NetworkCapabilities> networks = new HashMap();
    private final ExecutorService executor;
    private ArrayList<Integer> writeFdList = new ArrayList();

    public static TransportType getTransportType(NetworkCapabilities netCapabilities) {
        if (netCapabilities == null) {
            return TransportType.UNKNOWN;
        }
        if (netCapabilities.hasTransport(0)) {
            return TransportType.CELLULAR;
        }
        if (netCapabilities.hasTransport(1)) {
            return TransportType.WIFI;
        }
        if (netCapabilities.hasTransport(2)) {
            return TransportType.BLUETOOTH;
        }
        if (netCapabilities.hasTransport(3)) {
            return TransportType.ETHERNET;
        }
        return TransportType.UNKNOWN;
    }

    public static String networkCapabilitiesToString(NetworkCapabilities netCapabilities) {
        String netCapabilitiesAsString = "";
        if (netCapabilities.hasCapability(12)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[INTERNET] ";
        }
        if (!netCapabilities.hasCapability(11)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[METERED] ";
        }
        if (!netCapabilities.hasCapability(13)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[RESTRICTED] ";
        }
        if (!netCapabilities.hasCapability(21)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[SUSPENDED] ";
        }
        if (netCapabilities.hasCapability(14)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[TRUSTED] ";
        }
        if (netCapabilities.hasCapability(16)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[VALIDATED] ";
        }
        if (netCapabilities.hasCapability(17)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[CAPTIVE] ";
        }
        if (!netCapabilities.hasCapability(20)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[CONGESTED] ";
        }
        if (!netCapabilities.hasCapability(18)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[ROAMING] ";
        }
        if (!netCapabilities.hasCapability(15)) {
            netCapabilitiesAsString = netCapabilitiesAsString + "[VPN] ";
        }
        return netCapabilitiesAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackCurrentNetworkState() {
        ConnectivityManager cm = NetInterface.getConnectivityManager();
        Network activeNetwork = cm.getActiveNetwork();
        ArrayList<JniNetworkParams> validNetworks = new ArrayList<JniNetworkParams>();
        HashMap<Network, NetworkCapabilities> hashMap = this.networks;
        synchronized (hashMap) {
            for (Map.Entry<Network, NetworkCapabilities> netPair : this.networks.entrySet()) {
                boolean isActive = activeNetwork != null ? netPair.getKey().equals((Object)activeNetwork) : false;
                JniNetworkParams netParams = JniNetworkParams.createFromNetworkCapabilities(netPair.getValue(), isActive);
                if (netParams.error) continue;
                validNetworks.add(netParams);
            }
        }
        String prefix = "[" + Thread.currentThread().getId() + "] ";
        Log.v((String)TAG, (String)(prefix + "callbackCurrentNetworkState(): number of valid networks = " + Integer.toString(validNetworks.size())));
        JniNetworkParams[] netParamsArray = new JniNetworkParams[validNetworks.size()];
        netParamsArray = validNetworks.toArray(netParamsArray);
        ArrayList list = null;
        ArrayList<Integer> arrayList = this.writeFdList;
        synchronized (arrayList) {
            list = (ArrayList)this.writeFdList.clone();
        }
        for (Integer wfd : list) {
            RootToolsHandler.callbackListInterfaces(wfd, netParamsArray.length, netParamsArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNetworkCallbacks(Integer writeFd) {
        String prefix = "[" + Thread.currentThread().getId() + "] ";
        Log.v((String)TAG, (String)(prefix + " Registering generic network callback"));
        boolean needRegistration = false;
        ArrayList<Integer> arrayList = this.writeFdList;
        synchronized (arrayList) {
            needRegistration = this.writeFdList.isEmpty();
            if (this.writeFdList.contains(writeFd)) {
                throw new IllegalArgumentException("Callback with such FD is already registered");
            }
            this.writeFdList.add(writeFd);
        }
        if (!needRegistration) {
            return;
        }
        this.genericNetworkCallback = new GenericNetworkCallback();
        NetworkRequest request = new NetworkRequest.Builder().addTransportType(0).addTransportType(1).addTransportType(2).addTransportType(3).addCapability(12).build();
        ConnectivityManager cm = NetInterface.getConnectivityManager();
        cm.registerNetworkCallback(request, (ConnectivityManager.NetworkCallback)this.genericNetworkCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterNetworkCallbacks(Integer writeFd) {
        boolean needUnregistration = false;
        ArrayList<Integer> arrayList = this.writeFdList;
        synchronized (arrayList) {
            if (!this.writeFdList.contains(writeFd)) {
                throw new NoSuchElementException("Callback with such FD was not registered");
            }
            this.writeFdList.remove(writeFd);
            needUnregistration = this.writeFdList.isEmpty();
        }
        if (needUnregistration) {
            this.unregisterGenericNetworkCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterGenericNetworkCallback() {
        if (this.genericNetworkCallback != null) {
            String prefix = "[" + Thread.currentThread().getId() + "] ";
            Log.v((String)TAG, (String)(prefix + "Unregistering generic network callback"));
            ConnectivityManager cm = NetInterface.getConnectivityManager();
            cm.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.genericNetworkCallback);
            this.genericNetworkCallback = null;
            HashMap<Network, NetworkCapabilities> hashMap = this.networks;
            synchronized (hashMap) {
                this.networks.clear();
            }
        }
    }

    public NetInterface(ExecutorService executor) {
        this.executor = executor;
        this.typeToTransportMap.put(3, 0);
        this.typeToTransportMap.put(2, 1);
        this.typeToTransportMap.put(1, 3);
    }

    private boolean equals(NetworkInfo i1, NetworkInfo i2) {
        return i1 != null && i2 != null && i1.getType() == i2.getType() && i1.getSubtype() == i2.getSubtype() && i1.isConnected() == i2.isConnected();
    }

    public JniNetworkParams getActiveConnectionInfo() {
        Network[] allNetworks;
        ConnectivityManager cm = NetInterface.getConnectivityManager();
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni == null) {
            return JniNetworkParams.createErroneous();
        }
        for (Network nw : allNetworks = cm.getAllNetworks()) {
            if (!this.equals(cm.getNetworkInfo(nw), ni)) continue;
            return JniNetworkParams.createFromNetworkInfo(cm.getNetworkInfo(nw), cm.getNetworkCapabilities(nw), true);
        }
        return JniNetworkParams.createErroneous();
    }

    public JniNetworkParams getActiveConnection() {
        ConnectivityManager cm = NetInterface.getConnectivityManager();
        Network activeNet = cm.getActiveNetwork();
        if (activeNet == null) {
            return JniNetworkParams.createErroneous();
        }
        NetworkCapabilities netCapabilities = cm.getNetworkCapabilities(activeNet);
        if (netCapabilities == null) {
            return JniNetworkParams.createErroneous();
        }
        return JniNetworkParams.createFromNetworkCapabilities(netCapabilities, true);
    }

    public byte[] getGateway(byte[] ip) {
        InetAddress addr;
        try {
            addr = InetAddress.getByAddress(ip);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ConnectivityManager cm = NetInterface.getConnectivityManager();
        for (Network net : cm.getAllNetworks()) {
            LinkProperties link = cm.getLinkProperties(net);
            for (LinkAddress linkAddr : link.getLinkAddresses()) {
                if (!linkAddr.getAddress().equals(addr)) continue;
                for (RouteInfo route : link.getRoutes()) {
                    InetAddress gwAddr;
                    if (!route.isDefaultRoute() || (gwAddr = route.getGateway()) == null) continue;
                    return gwAddr.getAddress();
                }
            }
        }
        return null;
    }

    public JniNetworkParams[] getConnectionInfos() {
        ConnectivityManager cm = NetInterface.getConnectivityManager();
        NetworkInfo activeNwInfo = cm.getActiveNetworkInfo();
        NetworkInfo[] allNwInfo = cm.getAllNetworkInfo();
        Network[] allNw = cm.getAllNetworks();
        ArrayList<JniNetworkParams> validNetworks = new ArrayList<JniNetworkParams>();
        for (NetworkInfo nwi : allNwInfo) {
            NetworkCapabilities nwc = null;
            for (Network nw : allNw) {
                try {
                    if (!this.equals(cm.getNetworkInfo(nw), nwi)) continue;
                    nwc = cm.getNetworkCapabilities(nw);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            JniNetworkParams net_params = JniNetworkParams.createFromNetworkInfo(nwi, nwc, this.equals(nwi, activeNwInfo));
            if (net_params.error) continue;
            validNetworks.add(net_params);
        }
        JniNetworkParams[] result = new JniNetworkParams[validNetworks.size()];
        int i = 0;
        for (JniNetworkParams r : validNetworks) {
            result[i++] = r;
        }
        return result;
    }

    public JniNetworkParams[] getConnections() {
        ConnectivityManager cm = NetInterface.getConnectivityManager();
        Network activeNetwork = cm.getActiveNetwork();
        Network[] allNetworks = cm.getAllNetworks();
        ArrayList<JniNetworkParams> validNetworks = new ArrayList<JniNetworkParams>();
        for (Network net : allNetworks) {
            NetworkCapabilities netCapabilities = cm.getNetworkCapabilities(net);
            JniNetworkParams netParams = JniNetworkParams.createFromNetworkCapabilities(netCapabilities, net.equals((Object)activeNetwork));
            if (netParams.error) continue;
            validNetworks.add(netParams);
        }
        JniNetworkParams[] netParamsArray = new JniNetworkParams[validNetworks.size()];
        netParamsArray = validNetworks.toArray(netParamsArray);
        return netParamsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] pickInterface(int type, String remoteAddr) {
        Log.v((String)TAG, (String)("pickInterface() start type " + String.valueOf(type)));
        if (!this.typeToTransportMap.containsKey(type)) {
            throw new NoSuchElementException("Unknown interface type");
        }
        ConnectivityManager connmanager = NetInterface.getConnectivityManager();
        List addrlist = null;
        NetworkCallback callback = null;
        Object object = this;
        synchronized (object) {
            callback = this.callbackMap.get(type);
            if (callback == null) {
                callback = new NetworkCallback();
                this.callbackMap.put(type, callback);
                NetworkRequest.Builder builder = new NetworkRequest.Builder();
                builder.addCapability(12);
                builder.addCapability(13);
                builder.addTransportType(this.typeToTransportMap.get(type).intValue());
                connmanager.requestNetwork(builder.build(), (ConnectivityManager.NetworkCallback)callback);
            }
            ++callback.usageCounter;
        }
        object = callback;
        synchronized (object) {
            if (callback.network == null && !callback.initialConnectionComplete) {
                try {
                    ((Object)((Object)callback)).wait(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (callback.network != null) {
                Object lprop;
                if (Build.VERSION.SDK_INT >= 23 && type == 3) {
                    connmanager.bindProcessToNetwork(callback.network);
                }
                if ((lprop = connmanager.getLinkProperties(callback.network)) != null) {
                    addrlist = lprop.getLinkAddresses();
                }
            }
        }
        Log.v((String)TAG, (String)("pickInterface() end type " + String.valueOf(type)));
        if (addrlist == null || addrlist.size() == 0) {
            this.dropInterface(type);
            return null;
        }
        ArrayList<String> addrStrings = new ArrayList<String>();
        for (LinkAddress addr : addrlist) {
            addrStrings.add(addr.getAddress().getHostAddress());
        }
        String[] resp = new String[addrStrings.size()];
        addrStrings.toArray(resp);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dropInterface(int type) {
        Log.v((String)TAG, (String)("dropInterface() type " + String.valueOf(type)));
        if (!this.typeToTransportMap.containsKey(type)) {
            throw new NoSuchElementException("Unknown interface type");
        }
        if (this.callbackMap.containsKey(type) && --this.callbackMap.get((Object)Integer.valueOf((int)type)).usageCounter == 0) {
            ConnectivityManager connmanager = NetInterface.getConnectivityManager();
            ConnectivityManager.NetworkCallback callback = this.callbackMap.get(type);
            connmanager.unregisterNetworkCallback(callback);
            this.callbackMap.remove(type);
            if (Build.VERSION.SDK_INT >= 23 && type == 3) {
                connmanager.bindProcessToNetwork(null);
            }
            ConnectivityManager.NetworkCallback networkCallback = callback;
            synchronized (networkCallback) {
                callback.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finish() {
        Log.v((String)TAG, (String)"Unregistering all networkcallbacks");
        ConnectivityManager connmanager = NetInterface.getConnectivityManager();
        for (NetworkCallback callback : this.callbackMap.values()) {
            connmanager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)callback);
        }
        this.callbackMap.clear();
        ArrayList<Integer> arrayList = this.writeFdList;
        synchronized (arrayList) {
            this.writeFdList.clear();
        }
        this.unregisterGenericNetworkCallback();
    }

    class NetworkCallback
    extends ConnectivityManager.NetworkCallback {
        Network network = null;
        int usageCounter = 0;
        boolean initialConnectionComplete = false;

        NetworkCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLost(Network lostnetwork) {
            Log.v((String)NetInterface.TAG, (String)"NetworkCallback.onLost()");
            super.onLost(lostnetwork);
            NetworkCallback networkCallback = this;
            synchronized (networkCallback) {
                this.network = null;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAvailable(Network newnetwork) {
            Log.v((String)NetInterface.TAG, (String)"NetworkCallback.onAvailable()");
            super.onAvailable(newnetwork);
            NetworkCallback networkCallback = this;
            synchronized (networkCallback) {
                this.network = newnetwork;
                this.initialConnectionComplete = true;
                ((Object)((Object)this)).notifyAll();
            }
        }

        public void onLosing(Network network, int maxMsToLive) {
            super.onLosing(network, maxMsToLive);
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            super.onCapabilitiesChanged(network, networkCapabilities);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            super.onLinkPropertiesChanged(network, linkProperties);
        }
    }

    class GenericNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        GenericNetworkCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLost(Network network) {
            Log.v((String)NetInterface.TAG, (String)(this.getLogPrefix(network) + " NetworkCallback.onLost()"));
            HashMap hashMap = NetInterface.this.networks;
            synchronized (hashMap) {
                NetInterface.this.networks.remove(network);
            }
            NetInterface.this.executor.execute(new Runnable(){

                public void run() {
                    NetInterface.this.callbackCurrentNetworkState();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAvailable(Network network) {
            Log.v((String)NetInterface.TAG, (String)(this.getLogPrefix(network) + " NetworkCallback.onAvailable()"));
            HashMap hashMap = NetInterface.this.networks;
            synchronized (hashMap) {
                NetInterface.this.networks.put(network, null);
            }
        }

        public void onLosing(Network network, int maxMsToLive) {
            Log.v((String)NetInterface.TAG, (String)(this.getLogPrefix(network) + " NetworkCallback.onLosing()"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapabilitiesChanged(Network network, NetworkCapabilities netCapabilities) {
            String netCapabilitiesStr = NetInterface.networkCapabilitiesToString(netCapabilities);
            TransportType transportType = NetInterface.getTransportType(netCapabilities);
            Log.v((String)NetInterface.TAG, (String)(this.getLogPrefix(network) + "[" + (Object)((Object)transportType) + "] NetworkCallback.onCapabilitiesChanged() " + netCapabilitiesStr));
            HashMap hashMap = NetInterface.this.networks;
            synchronized (hashMap) {
                if (NetInterface.this.networks.containsKey(network)) {
                    NetInterface.this.networks.put(network, netCapabilities);
                }
            }
            NetInterface.this.executor.execute(new Runnable(){

                public void run() {
                    NetInterface.this.callbackCurrentNetworkState();
                }
            });
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            Log.v((String)NetInterface.TAG, (String)(this.getLogPrefix(network) + " NetworkCallback.onLinkPropertiesChanged()"));
        }

        private String getLogPrefix(Network network) {
            String prefix = "[" + Thread.currentThread().getId() + "][" + network.toString() + "] ";
            return prefix;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TransportType {
        UNKNOWN,
        CELLULAR,
        WIFI,
        BLUETOOTH,
        ETHERNET;

    }
}

