/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.audio;

import com.microsoft.dl.utils.Log;
import java.nio.ByteBuffer;

public class RtcAudioRecorder {
    public static final long ERROR_INVALID_PARAM = -1L;
    public static final long ERROR_NO_DATA = -2L;
    private static long m_nativeInstance = 0L;
    private static long m_nativeAudioManagerExtension = 0L;
    private static long m_kingstoneNativeInstance = 0L;
    private static int m_micChannels = 1;
    private static int m_samplingRate = -1;
    private static int m_encodingType = 2;
    private static int m_isLoopback = 0;
    private static int m_hasProcessed = 0;

    private static native long Create(long var0);

    private static native int Release(long var0, long var2);

    private static native int SetStreamPosition(long var0, int var2);

    private static native int SetOutputFormat(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native int Start(long var0);

    private static native int Stop(long var0);

    private static native long ReadFrame(long var0);

    private static native long ReadFrameByteBuffer(long var0, ByteBuffer var2);

    private static native long ReadFrameByteBufferMultipleChannel(long var0, ByteBuffer var2);

    public static synchronized void registerNativeInstance(long nInstance) {
        Log.i((String)"DLAudioJava", (String)"audio recorder registerNativeInstance");
        m_kingstoneNativeInstance = nInstance;
    }

    public static synchronized void unregisterNativeInstance() {
        Log.i((String)"DLAudioJava", (String)"audio recorder unregisterNativeInstance");
        m_kingstoneNativeInstance = 0L;
    }

    public static synchronized int getMicChannels() {
        return m_micChannels;
    }

    public static synchronized int getSamplingRate() {
        return m_samplingRate;
    }

    public static synchronized int getEncodingType() {
        return m_encodingType;
    }

    public static synchronized int getLoopback() {
        return m_isLoopback;
    }

    public static synchronized int getProcessed() {
        return m_hasProcessed;
    }

    public synchronized long create(long nativeExtension) {
        m_nativeAudioManagerExtension = nativeExtension;
        if (m_nativeAudioManagerExtension != 0L) {
            m_nativeInstance = RtcAudioRecorder.Create(m_nativeAudioManagerExtension);
        }
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)("create RtcAudioRecorder: (nativeInstance=" + m_nativeInstance + ", nativeAudioManagerExtension=" + m_nativeAudioManagerExtension + ")"));
        }
        return m_nativeInstance;
    }

    public synchronized void release() {
        int ret = 0;
        if (m_nativeAudioManagerExtension != 0L && m_nativeInstance != 0L) {
            ret = RtcAudioRecorder.Release(m_nativeAudioManagerExtension, m_nativeInstance);
        }
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)("release RtcAudioRecorder: (nativeInstance=" + m_nativeInstance + ", nativeAudioManagerExtension=" + m_nativeAudioManagerExtension + ", return=" + ret + ")"));
        }
        m_nativeAudioManagerExtension = 0L;
        m_nativeInstance = 0L;
    }

    public synchronized int setStreamPosition(int streamPosition) {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)("setStreamPosition: (nativeInstance=" + m_nativeInstance + ", streamPosition=" + streamPosition + ")"));
        }
        if (m_nativeInstance != 0L) {
            return RtcAudioRecorder.SetStreamPosition(m_nativeInstance, streamPosition);
        }
        return -1;
    }

    public synchronized int setOutputFormat(int formatTag, int samplingRate, int channels, int bitsPerSample, int samplesPerFrame) {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)("setOutputFormat: (nativeInstance=" + m_nativeInstance + ", samplingRate=" + samplingRate + ", channels=" + channels + ", bitsPerSample=" + bitsPerSample + ", samplesPerFrame=" + samplesPerFrame + ")"));
        }
        if (m_nativeInstance != 0L) {
            return RtcAudioRecorder.SetOutputFormat(m_nativeInstance, formatTag, samplingRate, channels, bitsPerSample, samplesPerFrame);
        }
        return -1;
    }

    public synchronized int start() {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"audio recorder start");
        }
        if (m_nativeInstance != 0L) {
            return RtcAudioRecorder.Start(m_nativeInstance);
        }
        return -1;
    }

    public synchronized int stop() {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"audio recorder stop");
        }
        if (m_nativeInstance != 0L) {
            return RtcAudioRecorder.Stop(m_nativeInstance);
        }
        return -1;
    }

    public synchronized long readFrame() {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.d((String)"DLAudioJava", (String)"audio recorder readFrame");
        }
        if (m_nativeInstance != 0L) {
            return RtcAudioRecorder.ReadFrame(m_nativeInstance);
        }
        return 0L;
    }

    public synchronized long readFrame(ByteBuffer audioBuffer) {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.d((String)"DLAudioJava", (String)"audio recorder readFrame(ByteBuffer)");
        }
        if (m_nativeInstance == 0L || audioBuffer == null) {
            Log.e((String)"DLAudioJava", (String)"audio recorder readFrame(ByteBuffer), invalid parameters");
            return -1L;
        }
        long retVal = RtcAudioRecorder.ReadFrameByteBuffer(m_nativeInstance, audioBuffer);
        if (retVal < 0L) {
            Log.d((String)"DLAudioJava", (String)"audio recorder readFrame(ByteBuffer), error in frame reading");
            return -2L;
        }
        return retVal;
    }

    public synchronized long readFrameMultipleChannel(ByteBuffer audioBuffer) {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.d((String)"DLAudioJava", (String)"audio recorder readFrameMultipleChannel(ByteBuffer)");
        }
        if (m_kingstoneNativeInstance == 0L || audioBuffer == null) {
            Log.e((String)"DLAudioJava", (String)"audio recorder readFrameMultipleChannel(ByteBuffer), invalid parameters");
            return -1L;
        }
        long retVal = RtcAudioRecorder.ReadFrameByteBufferMultipleChannel(m_kingstoneNativeInstance, audioBuffer);
        if (retVal < 0L) {
            Log.d((String)"DLAudioJava", (String)"audio recorder readFrameMultipleChannel(ByteBuffer), error in frame reading");
            return -2L;
        }
        return retVal;
    }

    public synchronized long setAudioConfig(int micChannels, int samplingRate, int encodingType, int isLoopback, int hasProcessed) {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)("audio recorder setAudioConfig: (nativeInstance=" + m_nativeInstance + ", micChannels=" + micChannels + ", samplingRate=" + samplingRate + ", encodingType=" + encodingType + ", isLoopback=" + isLoopback + ", hasProcessed=" + hasProcessed + ")"));
        }
        m_micChannels = micChannels;
        m_samplingRate = samplingRate;
        m_encodingType = encodingType;
        m_isLoopback = isLoopback;
        m_hasProcessed = hasProcessed;
        return 0L;
    }
}

