/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.audio;

import com.microsoft.dl.audio.AudioPlatform;
import com.microsoft.dl.utils.Log;

public class RouteController {
    private final boolean RESTART_DEVICE = true;
    private final boolean NO_RESTART_DEVICE = false;
    private boolean isRouteSetFromClientSide;
    private String defaultRoute;
    private String savedRoute;
    private boolean waitForRestart = false;
    private boolean isDeviceRunning = false;
    private AudioPlatform.clientCallback thisClientCallback = null;
    private long thisNativeInstance = 0L;

    private static native void onRouteChange(long var0, boolean var2, String var3);

    public RouteController(boolean clientRouting, AudioPlatform.clientCallback callback) {
        this.isRouteSetFromClientSide = clientRouting;
        this.thisClientCallback = callback;
        this.setDefaultRoute("Earpiece");
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)("RouteController ctor: isRouteSetFromClientSide=" + (this.isRouteSetFromClientSide ? "TRUE" : "FALSE") + " thisClientCallback=" + (this.thisClientCallback == null ? "NULL" : "NOT NULL")));
        }
    }

    public synchronized void setClientCallback(AudioPlatform.clientCallback callback, boolean clientRouting) {
        if (callback != this.thisClientCallback && callback != null) {
            this.thisClientCallback = callback;
        }
        this.isRouteSetFromClientSide = clientRouting;
    }

    public synchronized void registerNativeInstance(long nativeInstance) {
        this.thisNativeInstance = nativeInstance;
    }

    public synchronized void unregisterNativeInstance() {
        this.thisNativeInstance = 0L;
    }

    public synchronized void startingDevice(boolean onStart) {
        this.isDeviceRunning = onStart;
        if (this.waitForRestart && this.isDeviceRunning) {
            this.waitForRestart = false;
            if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                Log.i((String)"DLAudioJava", (String)("device restarted: complete route change CB to UI (oldRoute=" + this.defaultRoute + ", newRoute=" + this.savedRoute + ")"));
            }
            this.setDefaultRoute(this.savedRoute);
            this.doUICallback(this.defaultRoute);
        }
    }

    public synchronized void onNativeCallback(String route, boolean onRestartDevice) {
        if (this.thisNativeInstance != 0L) {
            if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                Log.i((String)"DLAudioJava", (String)("onRouteChangeCB for DL/LMS: newRoute=" + route + " onRestartDevice=" + onRestartDevice));
            }
            RouteController.onRouteChange(this.thisNativeInstance, onRestartDevice, route);
        }
    }

    public synchronized boolean setRouteChange(String newRoute) {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)("setRouteChange: defaultRoute=" + this.defaultRoute + " newRoute=" + newRoute + " savedRoute=" + this.savedRoute + " waitForRestart=" + this.waitForRestart + " isDeviceRunning=" + this.isDeviceRunning));
        }
        if (!this.isValidRouteName(newRoute)) {
            this.doUICallbackWithError(newRoute);
            return false;
        }
        if (newRoute == this.defaultRoute && !this.waitForRestart) {
            this.doUICallback(newRoute);
            return true;
        }
        if (newRoute == this.savedRoute && this.waitForRestart) {
            return false;
        }
        if (!this.isDeviceRunning && !this.waitForRestart) {
            this.setDefaultRoute(newRoute);
            this.onNativeCallback(newRoute, false);
            this.doUICallback(newRoute);
            return true;
        }
        if (!newRoute.equals("Bluetooth") && this.defaultRoute != "Bluetooth") {
            this.clearWaitForRestart(newRoute);
            this.waitForRouteChange();
            this.setDefaultRoute(newRoute);
            this.onNativeCallback(newRoute, false);
            this.doUICallback(newRoute);
            return true;
        }
        this.setWaitForRestart(newRoute);
        this.onNativeCallback(newRoute, true);
        return false;
    }

    public synchronized String getDefaultRoute() {
        String route = this.waitForRestart ? this.savedRoute : this.defaultRoute;
        return route;
    }

    private synchronized void doUICallback(String route) {
        if (this.isRouteSetFromClientSide) {
            this.thisClientCallback.callbackWithoutError(route);
        }
    }

    private synchronized void doUICallbackWithError(String route) {
        if (this.isRouteSetFromClientSide) {
            this.thisClientCallback.callbackWithError(route);
        }
    }

    private void setWaitForRestart(String route) {
        this.waitForRestart = true;
        this.savedRoute = route;
    }

    private void clearWaitForRestart(String route) {
        this.waitForRestart = false;
        this.savedRoute = route;
    }

    private final void setDefaultRoute(String route) {
        this.defaultRoute = route;
    }

    private boolean isValidRouteName(String route) {
        return route.equals("Earpiece") || route.equals("Speaker") || route.equals("Bluetooth") || route.equals("Non_speaker") || route.equals("Headset_with_mic") || route.equals("Headset_without_mic");
    }

    private void waitForRouteChange() {
    }
}

