/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.audio;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothManager;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Environment;
import com.microsoft.dl.Platform;
import com.microsoft.dl.audio.AudioHwOffload;
import com.microsoft.dl.audio.RouteController;
import com.microsoft.dl.audio.VolumeController;
import com.microsoft.dl.utils.Log;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class AudioPlatform {
    private static AudioManager audioManager = null;
    private static Context appContext = null;
    private static RouteController routeController = null;
    private static VolumeController volumeController = null;
    private static AudioHwOffload audioHwOffload = null;
    private static boolean isRouteSetFromClientSide = false;
    private static clientCallback thisClientCallback = null;
    private static final String WHITELIST_FILE = "audio.cfg";
    private static String cachedRoute = "";
    private static boolean isMediaInitialized = false;
    private static BluetoothHeadset bluetoothHeadset = null;
    private static BroadcastReceiver broadcastReceiver = null;
    private static BluetoothAdapter mBluetoothAdapter = null;
    private static BluetoothProfile.ServiceListener mBluetoothProfileListener = null;
    private static String btHeadsetAddress = null;
    private static Timer jniRouteTimer = null;
    private static long thisNativeInstance = 0L;
    private static Timer vqeLogRequestTimer = null;

    private AudioPlatform() {
    }

    private static native boolean DumpAudioFileNativeCapture(boolean var0, String var1);

    private static native boolean DumpAudioFileNativeRender(boolean var0, String var1);

    private static native boolean OnAudioSharingSampleReady(ByteBuffer var0, int var1);

    private static native boolean SetAudioSharingDeviceFormat(int var0, int var1, int var2, int var3);

    public static synchronized void setMode(int mode) {
        if (audioManager != null) {
            audioManager.setMode(mode);
            Log.log((int)4, (String)"DLAudioJava", (String)("AudioPlatform: setMode=" + mode));
        } else {
            Log.log((int)6, (String)"DLAudioJava", (String)"AudioPlatform: audioManager is null");
        }
    }

    public static synchronized void setAudioContext(Context ctx) {
        if (ctx != null) {
            appContext = ctx;
            audioManager = (AudioManager)appContext.getSystemService("audio");
        }
    }

    public static synchronized void initialize() {
        AudioPlatform.initialize(isRouteSetFromClientSide, thisClientCallback);
    }

    public static synchronized void updateClientCallback(boolean clientRouting, clientCallback callback) {
        isRouteSetFromClientSide = clientRouting;
        thisClientCallback = callback;
        if (routeController != null) {
            routeController.setClientCallback(thisClientCallback, isRouteSetFromClientSide);
        }
    }

    public static boolean initialize(boolean clientRouting, clientCallback callback) {
        thisClientCallback = callback == null ? new clientCallback() : callback;
        if (routeController == null) {
            clientCallback routeClientCallback = null;
            routeClientCallback = !clientRouting || clientRouting && callback == null ? new clientCallback() : callback;
            routeController = new RouteController(clientRouting, routeClientCallback);
        }
        if (volumeController == null) {
            try {
                volumeController = new VolumeController();
            }
            catch (RuntimeException e) {
                Log.log((int)5, (String)"DLAudioJava", (String)"Exception occured in new VolumeController(): ", (Throwable)e);
            }
        }
        if (audioHwOffload == null) {
            audioHwOffload = new AudioHwOffload();
        }
        AudioPlatform.InitializeBluetooth();
        if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)"AudioPlatform initialized");
        }
        return true;
    }

    private static Context getContext() {
        if (appContext != null) {
            return appContext;
        }
        Platform.PlatformInfo pi = Platform.getInfo();
        return pi != null ? pi.getAppContext() : null;
    }

    private static boolean InitializeBluetooth() {
        BluetoothManager manager;
        Context ctx = AudioPlatform.getContext();
        if (ctx == null) {
            if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                Log.i((String)"DLAudioJava", (String)"AudioPlatform fail to initialize Bluetooth because context is null");
            }
            return false;
        }
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"AudioPlatform initialize Bluetooth");
        }
        AudioPlatform.RegisterBroadcastEventHandler(ctx);
        if (Build.VERSION.SDK_INT >= 18 && (manager = (BluetoothManager)ctx.getSystemService("bluetooth")) != null) {
            mBluetoothAdapter = manager.getAdapter();
        }
        if (mBluetoothAdapter == null && (mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter()) == null) {
            return false;
        }
        mBluetoothProfileListener = new BluetoothProfile.ServiceListener(){

            public void onServiceConnected(int profile, BluetoothProfile proxy) {
                Log.i((String)"DLAudioJava", (String)("BluetoothProfileListener Connected: profile=" + profile));
                bluetoothHeadset = (BluetoothHeadset)proxy;
            }

            public void onServiceDisconnected(int profile) {
                Log.i((String)"DLAudioJava", (String)("BluetoothProfileListener Disconnected: profile=" + profile));
                bluetoothHeadset = null;
            }
        };
        try {
            return mBluetoothAdapter.getProfileProxy(ctx, mBluetoothProfileListener, 1);
        }
        catch (SecurityException e) {
            Log.log((int)5, (String)"DLAudioJava", (String)e.toString());
            return false;
        }
    }

    public static String readWhitelistFromSdcard() {
        File whitelistFile = new File(Environment.getExternalStorageDirectory(), WHITELIST_FILE);
        if (!whitelistFile.exists()) {
            if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                Log.d((String)"DLAudioJava", (String)("AudioPlatform: " + whitelistFile.getAbsolutePath() + " doesn't exist"));
            }
            return "";
        }
        return whitelistFile.getAbsolutePath();
    }

    public static synchronized VolumeController getJavaVolumeInstance() {
        if (volumeController == null) {
            Log.log((int)5, (String)"DLAudioJava", (String)"AudioPlatform: No instance found of VolumeController class");
            return null;
        }
        return volumeController;
    }

    public static synchronized RouteController getJavaRouteInstance() {
        if (routeController == null) {
            Log.log((int)5, (String)"DLAudioJava", (String)"AudioPlatform: No instance found of RouteController class");
            return null;
        }
        return routeController;
    }

    public static synchronized AudioHwOffload getJavaHwOffloadInstance() {
        if (audioHwOffload == null) {
            Log.log((int)5, (String)"DLAudioJava", (String)"AudioPlatform: No instance found of AudioHwOffload class");
            return null;
        }
        return audioHwOffload;
    }

    public static synchronized void registerNativeInstance(long nativeInstance) {
        if (nativeInstance == 0L) {
            Log.log((int)5, (String)"DLAudioJava", (String)"AudioPlatform: The native instance is null, no callback possible");
            return;
        }
        thisNativeInstance = nativeInstance;
        if (volumeController != null) {
            volumeController.registerNativeInstance(nativeInstance);
            volumeController.registerVolumeIntentReceiver();
        }
        if (routeController != null) {
            routeController.registerNativeInstance(nativeInstance);
        }
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"native instance registered for CallBacks");
        }
    }

    public static synchronized void unregisterNativeInstance() {
        thisNativeInstance = 0L;
        if (volumeController != null) {
            volumeController.unregisterVolumeIntentReceiver();
            volumeController.unregisterNativeInstance();
        }
        if (routeController != null) {
            routeController.unregisterNativeInstance();
        }
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"native instance unregistered for CallBacks");
        }
    }

    public static synchronized void uninitialize() {
        btHeadsetAddress = null;
        if (mBluetoothAdapter != null) {
            mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)bluetoothHeadset);
            mBluetoothAdapter = null;
        }
        mBluetoothProfileListener = null;
        if (broadcastReceiver != null) {
            Context ctx = AudioPlatform.getContext();
            if (ctx != null) {
                ctx.unregisterReceiver(broadcastReceiver);
            }
            broadcastReceiver = null;
        }
        routeController = null;
        volumeController = null;
        audioHwOffload = null;
        if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
            Log.d((String)"DLAudioJava", (String)"AudioPlatform uninitialized");
        }
    }

    public static synchronized boolean setRoute(String route) {
        if (routeController == null) {
            Log.log((int)6, (String)"DLAudioJava", (String)"setRoute() from UI: No instance found of RouteController class");
            return false;
        }
        if (route == null) {
            return false;
        }
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)("setRoute() from UI: " + route));
        }
        if (route.equals("Bluetooth") && !AudioPlatform.isBluetoothConnectPermissionGranted()) {
            Log.e((String)"DLAudioJava", (String)("setRoute() from UI: " + route + " fail, isBluetoothConnectPermissionGranted return false"));
            return false;
        }
        AudioPlatform.setDelayedJNIRoute(null);
        return routeController.setRouteChange(route);
    }

    public static synchronized String getDefaultRoute() {
        if (routeController == null) {
            Log.log((int)6, (String)"DLAudioJava", (String)"getDefaultRoute(): No instance found of RouteController class");
            return "";
        }
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"getDefaultRoute()");
        }
        return routeController.getDefaultRoute();
    }

    public static synchronized void setVolumeChange() {
        if (volumeController == null) {
            Log.log((int)6, (String)"DLAudioJava", (String)"setVolumeChange(): No instance found of VolumeController class");
            return;
        }
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"setVolumeChange()");
        }
        volumeController.setVolumeChange();
    }

    public static synchronized void audioRecorderAvailable(boolean isAvailable) {
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"audioRecorderAvailabe()");
        }
        if (isAvailable) {
            thisClientCallback.callbackAfterReleasingAudioRecorder();
        } else {
            thisClientCallback.callbackBeforeCreatingAudioRecorder();
        }
    }

    public static int cacheRoute(String route) {
        cachedRoute = route;
        Log.log((int)4, (String)"DLAudioJava", (String)("cacheRoute(" + cachedRoute + ")"));
        return 1;
    }

    public static String getCachedRoute() {
        isMediaInitialized = true;
        return cachedRoute;
    }

    public static boolean isMediaInitialized() {
        return isMediaInitialized;
    }

    private static boolean isBluetoothConnectPermissionGranted() {
        if (Build.VERSION.SDK_INT >= 31) {
            Context ctx = AudioPlatform.getContext();
            if (ctx == null || ctx.checkCallingOrSelfPermission("android.permission.BLUETOOTH_CONNECT") != 0) {
                if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                    Log.i((String)"DLAudioJava", (String)("no permission.BLUETOOTH_CONNECT, context =" + ctx));
                }
                return false;
            }
        } else {
            Context ctx = AudioPlatform.getContext();
            if (ctx == null || ctx.checkCallingOrSelfPermission("android.permission.BLUETOOTH") != 0) {
                if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                    Log.i((String)"DLAudioJava", (String)("no permission BLUETOOTH, context =" + ctx));
                }
                return false;
            }
        }
        return true;
    }

    public static String getBluetoothHeadsetName() {
        if (bluetoothHeadset == null || !AudioPlatform.isBluetoothConnectPermissionGranted()) {
            if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                Log.i((String)"DLAudioJava", (String)("getBluetoothHeadsetName return null, bluetoothHeadset =" + bluetoothHeadset));
            }
            btHeadsetAddress = null;
            return "";
        }
        int[] states = new int[]{2};
        List deviceList = bluetoothHeadset.getDevicesMatchingConnectionStates(states);
        for (BluetoothDevice device : deviceList) {
            if (!bluetoothHeadset.isAudioConnected(device)) continue;
            String name = device.getName();
            if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                Log.d((String)"DLAudioJava", (String)("Connected Bluetooth headset " + name));
            }
            return name;
        }
        btHeadsetAddress = null;
        return "";
    }

    public static String getBluetoothHeadsetId() {
        if (bluetoothHeadset == null || !AudioPlatform.isBluetoothConnectPermissionGranted()) {
            if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                Log.i((String)"DLAudioJava", (String)("getBluetoothHeadsetId return null, bluetoothHeadset =" + bluetoothHeadset));
            }
            btHeadsetAddress = null;
            return "";
        }
        int[] states = new int[]{2};
        List deviceList = bluetoothHeadset.getDevicesMatchingConnectionStates(states);
        for (BluetoothDevice device : deviceList) {
            if (!bluetoothHeadset.isAudioConnected(device)) continue;
            String name = device.getName();
            String address = device.getAddress();
            if (name.length() == 0 || address.length() != 17) continue;
            String bluetoothDevId = name + " (" + address.substring(0, 8) + ")";
            if (Log.isLoggable((String)"DLAudioJava", (int)3)) {
                Log.d((String)"DLAudioJava", (String)("Connected Bluetooth headset Id " + bluetoothDevId));
            }
            btHeadsetAddress = address;
            return bluetoothDevId;
        }
        btHeadsetAddress = null;
        return "";
    }

    private static synchronized void setDelayedJNIRoute(final String route) {
        if (jniRouteTimer != null) {
            jniRouteTimer.cancel();
            jniRouteTimer = null;
        }
        if (route == null || route.isEmpty()) {
            return;
        }
        jniRouteTimer = new Timer();
        jniRouteTimer.schedule(new TimerTask(){

            public void run() {
                String defaultRoute = AudioPlatform.getDefaultRoute();
                if (defaultRoute == null || !route.equals(defaultRoute)) {
                    AudioPlatform.setRoute(route);
                } else if (route.equals("Bluetooth")) {
                    String address = btHeadsetAddress;
                    AudioPlatform.getBluetoothHeadsetId();
                    if (address != null && btHeadsetAddress != null && !address.equals(btHeadsetAddress) && routeController != null) {
                        routeController.onNativeCallback(route, true);
                    }
                }
            }
        }, 1000L);
    }

    private static void RegisterBroadcastEventHandler(Context context) {
        IntentFilter intentFilter;
        BroadcastReceiver receiver;
        if (context == null) {
            return;
        }
        if (broadcastReceiver != null) {
            context.unregisterReceiver(broadcastReceiver);
            broadcastReceiver = null;
        }
        if (context.registerReceiver(receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.media.ACTION_SCO_AUDIO_STATE_UPDATED".equals(action)) {
                    int iState = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                    if (iState == 1) {
                        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                            Log.i((String)"DLAudioJava", (String)"AudioPlatform receives SCO_AUDIO_STATE_CONNECTED");
                        }
                        AudioPlatform.setDelayedJNIRoute("Bluetooth");
                    } else if (iState == 0) {
                        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
                            Log.i((String)"DLAudioJava", (String)"AudioPlatform receives SCO_AUDIO_STATE_DISCONNECTED");
                        }
                        btHeadsetAddress = null;
                        AudioPlatform.setDelayedJNIRoute(null);
                    }
                }
            }
        }, intentFilter = new IntentFilter("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) != null) {
            broadcastReceiver = receiver;
        }
    }

    public static boolean dumpAudioFile(boolean enableDumpAudio) {
        return false;
    }

    public static boolean requestVQEToLogAudioFiles() {
        int MAX_COUNT = 10;
        String[] basenames = new String[]{"spkin", "spkout", "spkrefin", "micin", "micout", "spkin-end", "spkout-end", "spkrefin-end", "micin-end", "micout-end"};
        boolean retValue = false;
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"requestVQEToLogAudioFiles()");
        }
        if (thisNativeInstance == 0L) {
            return false;
        }
        if (appContext == null) {
            return false;
        }
        File cacheFile = appContext.getExternalCacheDir();
        if (cacheFile == null) {
            return false;
        }
        for (int i = MAX_COUNT - 2; i >= 0; --i) {
            for (String basename : basenames) {
                File oldFile = new File(cacheFile + "/" + basename + "-" + i + ".wav");
                File newFile = new File(cacheFile + "/" + basename + "-" + (i + 1) + ".wav");
                if (!oldFile.exists()) continue;
                if (newFile.exists()) {
                    newFile.delete();
                }
                oldFile.renameTo(newFile);
            }
        }
        String wavLoggingFilePath = cacheFile.getAbsolutePath() + "/";
        retValue = AudioPlatform.DumpAudioFileNativeCapture(true, wavLoggingFilePath);
        if (!retValue) {
            retValue = AudioPlatform.DumpAudioFileNativeRender(true, wavLoggingFilePath);
        }
        return retValue;
    }

    public static synchronized void requestVQEToLogAudioFilesAsync() {
        if (vqeLogRequestTimer != null) {
            vqeLogRequestTimer.cancel();
            vqeLogRequestTimer = null;
        }
        vqeLogRequestTimer = new Timer();
        vqeLogRequestTimer.schedule(new TimerTask(){

            public void run() {
                AudioPlatform.requestVQEToLogAudioFiles();
            }
        }, 2000L);
    }

    public static boolean deleteAllLoggedAudioFiles() {
        File[] allWavFiles;
        if (Log.isLoggable((String)"DLAudioJava", (int)4)) {
            Log.i((String)"DLAudioJava", (String)"deleteAllLoggedAudioFiles()");
        }
        if (thisNativeInstance == 0L) {
            return false;
        }
        if (appContext == null) {
            return false;
        }
        File cacheFile = appContext.getExternalCacheDir();
        if (cacheFile == null) {
            return false;
        }
        for (File wavFile : allWavFiles = cacheFile.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".wav");
            }
        })) {
            wavFile.delete();
        }
        return true;
    }

    public static boolean onAudioSharingSampleReady(ByteBuffer data, int dataInBytes) {
        if (thisNativeInstance != 0L) {
            if (!data.isDirect()) {
                Log.log((int)5, (String)"DLAudioJava", (String)"AudioPlatform: onAudioSharingSampleReady failed due to given bytebuffer is not direct");
                return false;
            }
            return AudioPlatform.OnAudioSharingSampleReady(data, dataInBytes);
        }
        return false;
    }

    public static boolean setAudioSharingDeviceFormat(int formatTag, int channels, int samplesPerSec, int bitsPerSample) {
        if (thisNativeInstance != 0L) {
            return AudioPlatform.SetAudioSharingDeviceFormat(formatTag, channels, samplesPerSec, bitsPerSample);
        }
        return false;
    }

    public static class clientCallback {
        public void callbackWithoutError(String audioRoute) {
            android.util.Log.i((String)"DLAudioJava", (String)("callbackWithoutError: " + audioRoute));
        }

        public void callbackWithError(String audioRoute) {
            android.util.Log.i((String)"DLAudioJava", (String)("callbackWithError: " + audioRoute));
        }

        public void callbackStopRingoutTone() {
            android.util.Log.i((String)"DLAudioJava", (String)"callbackStopRingoutTone");
        }

        public void callbackBeforeCreatingAudioRecorder() {
            android.util.Log.i((String)"DLAudioJava", (String)"callbackBeforeCreatingAudioRecorder");
        }

        public void callbackAfterReleasingAudioRecorder() {
            android.util.Log.i((String)"DLAudioJava", (String)"callbackAfterReleasingAudioRecorder");
        }
    }
}

