/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.view.TextureView;
import com.skype.android.util2.Log;
import com.skype.android.video.render.legacy.LegacyGLESBindingRenderer;
import com.skype.android.video.render.legacy.LegacyGLTextureView;

public class GLTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private final String TAG;
    private final String SIMPLE_CLASS_NAME = ((Object)((Object)this)).getClass().getSimpleName();
    protected LegacyGLTextureView mLegacyView;
    private SurfaceTextureAvailableListener mListener;

    public GLTextureView(Context context, Looper looper, boolean isHandlerThreadShared, SurfaceTextureAvailableListener listener) {
        super(context);
        this.TAG = "" + System.identityHashCode((Object)this);
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, "ctor using internal thread " + (looper == null) + " isHandlerThreadShared " + isHandlerThreadShared);
        }
        this.mListener = listener;
        if (LegacyGLESBindingRenderer.isRenderPipelineEnabled()) {
            this.mLegacyView = null;
        } else {
            this.setSurfaceTextureListener(this);
            this.mLegacyView = new LegacyGLTextureView(looper, isHandlerThreadShared);
        }
    }

    public GLTextureView(Context context) {
        this(context, null, false, null);
    }

    public void dispose() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, "dispose");
        }
        if (this.mLegacyView != null) {
            this.setSurfaceTextureListener(null);
            this.mLegacyView.dispose();
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.i(this.TAG, this.SIMPLE_CLASS_NAME + '#' + "onSurfaceTextureAvailable() called. surfaceTexture " + System.identityHashCode(surface) + " width " + width + " height " + height);
        }
        if (this.mListener != null) {
            this.mListener.onSurfaceTextureAvailable(this);
        }
        if (this.mLegacyView != null) {
            this.mLegacyView.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.i(this.TAG, this.SIMPLE_CLASS_NAME + '#' + "onSurfaceTextureSizeChanged() called. surfaceTexture " + System.identityHashCode(surface) + " width " + width + " height " + height);
        }
        if (this.mLegacyView != null) {
            this.mLegacyView.onSurfaceTextureSizeChanged(surface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.i(this.TAG, this.SIMPLE_CLASS_NAME + '#' + "onSurfaceTextureDestroyed() called: surfaceTexture " + System.identityHashCode(surface));
        }
        if (this.mLegacyView != null) {
            return this.mLegacyView.onSurfaceTextureDestroyed(surface);
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.mLegacyView != null) {
            this.mLegacyView.onSurfaceTextureUpdated(surface);
        }
    }

    public LegacyGLTextureView getLegacyView() {
        return this.mLegacyView;
    }

    public static interface SurfaceTextureAvailableListener {
        public void onSurfaceTextureAvailable(TextureView var1);
    }
}

