/*
 * Decompiled with CFR 0.152.
 */
package com.skype.rt;

import android.util.SparseArray;
import com.skype.rt.LogFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class Auf {
    static final AtomicInteger inited = new AtomicInteger(0);

    public static boolean init() {
        if (inited.addAndGet(1) > 1) {
            return true;
        }
        return Auf.nativeInit();
    }

    public static void stop() {
        if (inited.addAndGet(-1) != 0) {
            return;
        }
        if (LogFactory.instance != null) {
            LogFactory f = LogFactory.instance;
            LogFactory.instance = null;
            f.dispose();
        }
        Auf.nativeStop();
    }

    public static void signalAppStateChange(AppState newState) {
        Auf.nativeSignalAppStateChange(newState.value());
    }

    private static native boolean nativeInit();

    private static native void nativeStop();

    private static native void nativeSignalAppStateChange(int var0);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AppState {
        FOREGROUND(5),
        BACKGROUND_ACTIVE(10),
        BACKGROUND_CONSTRAINED(15),
        SUSPEND(20),
        SUSPEND_OFFLINE(25);

        private final int state;
        private static final SparseArray<AppState> stateMap;

        public int value() {
            return this.state;
        }

        public static AppState fromInt(int state) {
            return (AppState)((Object)stateMap.get(state));
        }

        private AppState(int state) {
            this.state = state;
        }

        static {
            stateMap = new SparseArray();
            for (AppState appState : AppState.values()) {
                stateMap.put(appState.value(), (Object)appState);
            }
        }
    }
}

