/*
 * Decompiled with CFR 0.152.
 */
package com.skype.rt;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RtContext {
    private static final String TAG = "rt::";
    private static Context m_context;

    protected static synchronized Context getContext() {
        if (m_context != null) {
            return m_context;
        }
        Context ctx = null;
        if (Build.VERSION.SDK_INT >= 19 && (ctx = RtContext.obtainContext()) != null) {
            m_context = ctx;
        }
        return ctx;
    }

    public static synchronized void setContext(Context ctx) {
        if (m_context == null && ctx != null) {
            m_context = ctx;
        }
    }

    protected static WifiManager getWifiManager() {
        return (WifiManager)RtContext.getContext().getSystemService("wifi");
    }

    protected static ConnectivityManager getConnectivityManager() {
        return (ConnectivityManager)RtContext.getContext().getSystemService("connectivity");
    }

    private static Context obtainContext() {
        Context ctx = null;
        try {
            Class<?> ActivityThreadClass = Class.forName("android.app.ActivityThread");
            Method CurrentApplication = ActivityThreadClass.getMethod("currentApplication", new Class[0]);
            ctx = (Context)CurrentApplication.invoke(null, new Object[0]);
            if (ctx != null) {
                Log.v((String)TAG, (String)"Successfully aquired system context");
            } else {
                Log.v((String)TAG, (String)"Got null system context");
            }
        }
        catch (ClassNotFoundException e) {
            Log.v((String)TAG, (String)"ClassNotFoundException looking up android.app.ActivityThread");
        }
        catch (NoSuchMethodException e) {
            Log.v((String)TAG, (String)"NoSuchMethodException looking up android.app.ActivityThread.getSystemContext");
        }
        catch (IllegalAccessException e) {
            Log.v((String)TAG, (String)"IllegalAccessException invoking android.app.ActivityThread.getSystemContext");
        }
        catch (InvocationTargetException e) {
            Log.v((String)TAG, (String)"InvocationTargetException invoking android.app.ActivityThread.getSystemContext");
        }
        return ctx;
    }
}

