/*
 * Decompiled with CFR 0.152.
 */
package com.skype.rt;

import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Process;
import android.telephony.TelephonyManager;
import com.skype.rt.RtContext;

public class JniNetworkParams
extends RtContext {
    public boolean error;
    public boolean active;
    public int state;
    public int type;
    public int subType;
    public int cost;
    public int category;
    public int roaming;
    public String mcc;
    public String mnc;

    JniNetworkParams(boolean error, boolean active, NetworkConnectionState state, NetworkConnectionType type, NetworkConnectionSubType subType, NetworkConnectionCost cost, NetworkCategory category, NetworkRoamingState roaming, String mcc, String mnc) {
        this.error = error;
        this.active = active;
        this.state = state.val;
        this.type = type.val;
        this.subType = subType.val;
        this.cost = cost.val;
        this.category = category.val;
        this.roaming = roaming.val;
        this.mcc = mcc;
        this.mnc = mnc;
    }

    JniNetworkParams(boolean error) {
        this(error, false, NetworkConnectionState.Unknown, NetworkConnectionType.Unknown, NetworkConnectionSubType.Unknown, NetworkConnectionCost.Unknown, NetworkCategory.Unknown, NetworkRoamingState.Unknown, "", "");
    }

    public static JniNetworkParams createErroneous() {
        return new JniNetworkParams(true);
    }

    public static JniNetworkParams createDummy() {
        return new JniNetworkParams(false);
    }

    public static NetworkConnectionState getNetworkConnectionState(NetworkCapabilities netCapabilities) {
        NetworkConnectionState state = NetworkConnectionState.Unknown;
        state = netCapabilities.hasCapability(12) && netCapabilities.hasCapability(16) ? NetworkConnectionState.Internet : NetworkConnectionState.Disconnected;
        return state;
    }

    public static NetworkConnectionType getNetworkConnectionType(NetworkCapabilities netCapabilities) {
        NetworkConnectionType type = NetworkConnectionType.Unknown;
        if (netCapabilities.hasTransport(0)) {
            type = NetworkConnectionType.Mobile;
        } else if (netCapabilities.hasTransport(1)) {
            type = NetworkConnectionType.WiFi;
        } else if (netCapabilities.hasTransport(2)) {
            type = NetworkConnectionType.Bluetooth;
        } else if (netCapabilities.hasTransport(3)) {
            type = NetworkConnectionType.Ethernet;
        }
        return type;
    }

    public static NetworkConnectionSubType getNetworkConnectionSubType(NetworkConnectionType connectionType) {
        if (connectionType != NetworkConnectionType.Mobile) {
            return NetworkConnectionSubType.Unknown;
        }
        int permissionCheck = JniNetworkParams.getContext().checkPermission("android.permission.READ_PHONE_STATE", Process.myPid(), Process.myUid());
        if (permissionCheck != 0) {
            return NetworkConnectionSubType.Unknown;
        }
        TelephonyManager tman = (TelephonyManager)JniNetworkParams.getContext().getSystemService("phone");
        if (tman == null) {
            return NetworkConnectionSubType.Unknown;
        }
        NetworkConnectionSubType subType = NetworkConnectionSubType.Unknown;
        switch (tman.getDataNetworkType()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                subType = NetworkConnectionSubType.Cellular_2G;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: 
            case 14: {
                subType = NetworkConnectionSubType.Cellular_3G;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                subType = NetworkConnectionSubType.Cellular_35G;
                break;
            }
            case 13: {
                subType = NetworkConnectionSubType.Cellular_4G;
                break;
            }
            default: {
                subType = NetworkConnectionSubType.Unknown;
            }
        }
        return subType;
    }

    public static MccMnc getMccMnc(NetworkConnectionType connectionType) {
        MccMnc mccmnc = new MccMnc();
        TelephonyManager tman = (TelephonyManager)JniNetworkParams.getContext().getSystemService("phone");
        if (tman == null) {
            return mccmnc;
        }
        if (connectionType != NetworkConnectionType.Mobile) {
            return mccmnc;
        }
        String operatorCodes = tman.getSimOperator();
        if (operatorCodes != null && operatorCodes.length() >= 5) {
            mccmnc.mcc = operatorCodes.substring(0, 3);
            mccmnc.mnc = operatorCodes.substring(3, operatorCodes.length());
        }
        return mccmnc;
    }

    public static NetworkConnectionCost getNetworkConnectionCost(NetworkCapabilities netCapabilities) {
        NetworkConnectionCost netCost = !netCapabilities.hasCapability(18) ? NetworkConnectionCost.OverCap : (netCapabilities == null || netCapabilities.hasCapability(11) ? NetworkConnectionCost.Free : NetworkConnectionCost.Metered);
        return netCost;
    }

    public static JniNetworkParams createFromNetworkCapabilities(NetworkCapabilities netCapabilities, boolean active) {
        if (netCapabilities == null) {
            return JniNetworkParams.createErroneous();
        }
        NetworkConnectionState state = JniNetworkParams.getNetworkConnectionState(netCapabilities);
        NetworkConnectionType type = JniNetworkParams.getNetworkConnectionType(netCapabilities);
        NetworkConnectionSubType subType = JniNetworkParams.getNetworkConnectionSubType(type);
        MccMnc mccmnc = JniNetworkParams.getMccMnc(type);
        NetworkConnectionCost netCost = JniNetworkParams.getNetworkConnectionCost(netCapabilities);
        NetworkRoamingState roaming = netCapabilities.hasCapability(18) ? NetworkRoamingState.HomeNetwork : NetworkRoamingState.Roaming;
        return new JniNetworkParams(false, active, state, type, subType, netCost, NetworkCategory.Unknown, roaming, mccmnc.mcc, mccmnc.mnc);
    }

    public static JniNetworkParams createFromNetworkInfo(NetworkInfo info, NetworkCapabilities netCapabilities, boolean active) {
        if (info == null) {
            return JniNetworkParams.createErroneous();
        }
        NetworkConnectionState state = NetworkConnectionState.Unknown;
        NetworkConnectionType type = NetworkConnectionType.Unknown;
        NetworkConnectionSubType subType = NetworkConnectionSubType.Unknown;
        NetworkCategory category = NetworkCategory.Unknown;
        NetworkRoamingState roaming = info.isRoaming() ? NetworkRoamingState.Roaming : NetworkRoamingState.HomeNetwork;
        String mcc = "";
        String mnc = "";
        if (info.isConnected()) {
            state = NetworkConnectionState.Internet;
        } else if (!info.isAvailable()) {
            state = NetworkConnectionState.Disconnected;
        }
        switch (info.getType()) {
            case 0: {
                type = NetworkConnectionType.Mobile;
                break;
            }
            case 1: {
                type = NetworkConnectionType.WiFi;
                break;
            }
            case 6: {
                type = NetworkConnectionType.WiMax;
                break;
            }
            case 7: {
                type = NetworkConnectionType.Bluetooth;
                break;
            }
            case 9: {
                type = NetworkConnectionType.Ethernet;
                break;
            }
            default: {
                return JniNetworkParams.createErroneous();
            }
        }
        TelephonyManager tman = (TelephonyManager)JniNetworkParams.getContext().getSystemService("phone");
        if (type == NetworkConnectionType.Mobile) {
            String mccMnc = tman.getSimOperator();
            if (mccMnc != null && mccMnc.length() >= 5) {
                mcc = mccMnc.substring(0, 3);
                mnc = mccMnc.substring(3, mccMnc.length());
            }
            switch (info.getSubtype()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    subType = NetworkConnectionSubType.Cellular_2G;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 12: 
                case 14: {
                    subType = NetworkConnectionSubType.Cellular_3G;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 15: {
                    subType = NetworkConnectionSubType.Cellular_35G;
                    break;
                }
                case 13: {
                    subType = NetworkConnectionSubType.Cellular_4G;
                }
            }
        }
        NetworkConnectionCost cost = info.isRoaming() ? NetworkConnectionCost.OverCap : (netCapabilities == null || netCapabilities.hasCapability(11) ? NetworkConnectionCost.Free : NetworkConnectionCost.Metered);
        return new JniNetworkParams(false, active, state, type, subType, cost, category, roaming, mcc, mnc);
    }

    static final class MccMnc {
        public String mcc = "";
        public String mnc = "";

        MccMnc() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NetworkRoamingState {
        Unknown(0),
        Roaming(1),
        HomeNetwork(2);

        public final int val;

        private NetworkRoamingState(int val) {
            this.val = val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NetworkCategory {
        Unknown(0),
        Public(1),
        Private(2),
        DomainAuthenticated(3);

        public final int val;

        private NetworkCategory(int val) {
            this.val = val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NetworkConnectionCost {
        Unknown(0),
        Free(1),
        Metered(2),
        OverCap(3);

        public final int val;

        private NetworkConnectionCost(int val) {
            this.val = val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NetworkConnectionSubType {
        Unknown(0),
        Cellular_2G(1),
        Cellular_3G(2),
        Cellular_35G(3),
        Cellular_4G(4);

        public final int val;

        private NetworkConnectionSubType(int val) {
            this.val = val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NetworkConnectionType {
        Unknown(0),
        Ethernet(1),
        WiFi(2),
        Mobile(3),
        Bluetooth(4),
        WiMax(5),
        PPP(6);

        public final int val;

        private NetworkConnectionType(int val) {
            this.val = val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NetworkConnectionState {
        Unknown(0),
        Disconnected(1),
        NoTraffic(2),
        SubNet(3),
        Internet(4);

        public final int val;

        private NetworkConnectionState(int val) {
            this.val = val;
        }
    }
}

