/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.render;

import android.graphics.SurfaceTexture;
import com.skype.android.video.render.EGLException;
import com.skype.android.video.render.EGLRenderSurface;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

class EGL10RenderSurface
implements EGLRenderSurface {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private EGL10 egl;
    private EGLDisplay eglDisplay;
    private EGLContext eglContext = EGL10.EGL_NO_CONTEXT;
    private EGLSurface eglSurface;

    EGL10RenderSurface() {
        this.eglDisplay = EGL10.EGL_NO_DISPLAY;
        this.eglSurface = EGL10.EGL_NO_SURFACE;
    }

    public void create(SurfaceTexture surfaceTexture) {
        this.egl = (EGL10)EGLContext.getEGL();
        this.eglDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new EGLException("eglGetDisplay EGL10.EGL_NO_DISPLAY");
        }
        int[] version = new int[2];
        if (!this.egl.eglInitialize(this.eglDisplay, version)) {
            throw new EGLException("eglInitialize");
        }
        int[] configAttrs = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12352, 4, 12344};
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!this.egl.eglChooseConfig(this.eglDisplay, configAttrs, configs, configs.length, numConfigs)) {
            EGLException.check("eglChooseConfig");
        }
        int[] contextAttrs = new int[]{12440, 2, 12344};
        this.eglContext = this.egl.eglCreateContext(this.eglDisplay, configs[0], EGL10.EGL_NO_CONTEXT, contextAttrs);
        EGL10RenderSurface.check(this.egl, "eglCreateContext");
        int[] surfaceAttrs = new int[]{12344};
        this.eglSurface = this.egl.eglCreateWindowSurface(this.eglDisplay, configs[0], (Object)surfaceTexture, surfaceAttrs);
        EGL10RenderSurface.check(this.egl, "eglCreateWindowSurface");
    }

    public void makeCurrent(boolean current) {
        if (!this.egl.eglMakeCurrent(this.eglDisplay, current ? this.eglSurface : EGL10.EGL_NO_SURFACE, current ? this.eglSurface : EGL10.EGL_NO_SURFACE, current ? this.eglContext : EGL10.EGL_NO_CONTEXT)) {
            throw new EGLException("eglMakeCurrent");
        }
    }

    public void swapBuffers() {
        if (!this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface)) {
            throw new EGLException("eglSwapBuffers");
        }
    }

    public void destroy(boolean releaseThread) {
        if (this.eglDisplay != EGL10.EGL_NO_DISPLAY) {
            try {
                this.makeCurrent(false);
            }
            finally {
                this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface);
                this.egl.eglDestroyContext(this.eglDisplay, this.eglContext);
                this.egl.eglTerminate(this.eglDisplay);
                this.eglDisplay = EGL10.EGL_NO_DISPLAY;
                this.eglSurface = EGL10.EGL_NO_SURFACE;
                this.eglContext = EGL10.EGL_NO_CONTEXT;
            }
        }
    }

    private static void check(EGL10 egl, String message) {
        int error = egl.eglGetError();
        if (error != 12288) {
            throw new EGLException(error, message);
        }
    }
}

