/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.control;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Bundle;
import com.skype.android.video.hw.codec.encoder.AbstractVideoEncoder;
import com.skype.android.video.hw.codec.encoder.control.AbstractVideoEncoderControl;
import com.skype.android.video.hw.format.VideoFormat;
import com.skype.android.video.hw.utils.CodecUtils;
import com.skype.android.video.hw.utils.Log;

public final class VideoEncoderControlQcExtension
extends AbstractVideoEncoderControl {
    private final Bundle frameParams = new Bundle();
    private final MediaCodec mediaCodec;
    private int curNumTemporalLayers = 1;
    private int prevNumTemporalLayers = 1;
    private final String simpleClassName = this.getClass().getSimpleName();

    public VideoEncoderControlQcExtension(MediaCodec mediaCodec) {
        super(mediaCodec, null);
        this.mediaCodec = mediaCodec;
    }

    public void setRcFrameRate(float fps) throws AbstractVideoEncoder.APINotImplementedException {
    }

    public void setQp(int qp) throws AbstractVideoEncoder.APINotImplementedException {
        this.frameParams.putInt("vt-config-frame-qp", qp);
    }

    public void setNumTempLayers(int numTempLayers) throws AbstractVideoEncoder.APINotImplementedException {
        this.frameParams.putInt("vt-config-temporal-layer-count", numTempLayers);
        this.curNumTemporalLayers = numTempLayers;
    }

    public void setBaseLayerPID(int baseLayerPID) throws AbstractVideoEncoder.APINotImplementedException {
        this.frameParams.putInt("vt-config-base-layer-pid", baseLayerPID);
    }

    public void markLtrFrame(int longTermFrameIdx) throws AbstractVideoEncoder.APINotImplementedException {
        this.frameParams.putInt("vt-config-mark-ltr", longTermFrameIdx);
    }

    public void useLTRFrame(int useLTRFrameIdxBitMap) throws AbstractVideoEncoder.APINotImplementedException {
        this.frameParams.putInt("vt-config-use-ltr", useLTRFrameIdxBitMap);
    }

    public void doConfigureMediaFormat(MediaFormat mediaFormat, VideoFormat format) {
        int maxNumTemporalLayers;
        super.doConfigureMediaFormat(mediaFormat, format);
        mediaFormat.setInteger("vt-low-latency", 1);
        mediaFormat.setInteger("vt-avc-level", format.getLevel().getOmxValue().intValue());
        mediaFormat.setInteger("vt-use-extended-profile", 1);
        mediaFormat.setInteger("vt-extension-profile", format.getProfile().getOmxValue().intValue());
        mediaFormat.setInteger("vt-sequence-hdr-with-idr", 1);
        mediaFormat.setInteger("vt-ratecontrol", 0);
        int numSlices = Math.min(Math.max(format.getMinNumSlices(), 1), 15);
        int widthMB = format.getResolution().getWidth() + 15 >> 4;
        int heightMB = format.getResolution().getHeight() + 15 >> 4;
        int sliceSize = (widthMB * heightMB + numSlices - 1) / numSlices;
        if (sliceSize > 1) {
            mediaFormat.setInteger("vt-slice-hdr-spacing", sliceSize);
            mediaFormat.setInteger("vt-slice-control-mode", 1);
        } else {
            mediaFormat.setInteger("vt-slice-control-mode", 0);
        }
        int operatingfps = CodecUtils.getEncoderOperatingFpsFromNative();
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + " operatingfps " + operatingfps);
        }
        if (operatingfps != 0) {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + " Setting KEY_OPERATING_RATE to " + operatingfps);
            }
            mediaFormat.setInteger("operating-rate", operatingfps);
        }
        this.curNumTemporalLayers = format.getNumLayers();
        this.prevNumTemporalLayers = maxNumTemporalLayers = format.getNumLayers() > 1 ? format.getNumLayers() : (format.getSvcAlways() ? 2 : 0);
        if (this.curNumTemporalLayers > 1 || format.getSvcAlways()) {
            mediaFormat.setInteger("vt-video-hierar-type", 1);
            mediaFormat.setInteger("vt-max-temporal-layer-count", maxNumTemporalLayers);
        }
        int numLtrFrames = Math.max(format.getRefCount(), 1) - 1;
        mediaFormat.setInteger("vt-num-ltr-frames", numLtrFrames);
    }

    public void cleanFrameParams() {
        this.frameParams.clear();
        if (this.prevNumTemporalLayers != this.curNumTemporalLayers) {
            this.frameParams.putInt("vt-config-temporal-layer-count", this.curNumTemporalLayers);
            this.prevNumTemporalLayers = this.curNumTemporalLayers;
        }
    }

    public void markParamsTimestamp(long timestampMs) {
        Log.d("SLIQ", this.simpleClassName + " set vt-config-timestamp " + timestampMs * 1000L + " us");
        this.frameParams.putLong("vt-config-timestamp", timestampMs * 1000L);
    }

    public void configureFrameParams() {
        this.prevNumTemporalLayers = this.curNumTemporalLayers;
        this.mediaCodec.setParameters(this.frameParams);
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + ": Setting " + this.frameParams + " on " + this.mediaCodec);
        }
    }
}

