/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.capture;

import android.graphics.SurfaceTexture;
import android.util.SparseArray;
import android.view.Surface;
import com.skype.android.video.hw.codec.encoder.camera.capture.Capturer;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerException;
import com.skype.android.video.hw.codec.encoder.camera.gl.AbstractRenderingTarget;
import com.skype.android.video.hw.codec.encoder.camera.gl.ChannelPushFrame;
import com.skype.android.video.hw.codec.encoder.camera.gl.GLException;
import com.skype.android.video.hw.codec.encoder.camera.gl.SurfaceTextureChannel;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.utils.Log;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;

public class CapturerSinks
implements Closeable {
    private int sinkCounter;
    private final SparseArray<AbstractSink> sinks = new SparseArray();
    private final SparseArray<AbstractSink> removedSinks = new SparseArray();
    private final AtomicBoolean isDirty = new AtomicBoolean();
    private final String simpleClassName = this.getClass().getSimpleName();

    public Capturer.Sink addEncoderSink(Object mutex, Capturer.SinkEvents cb, ChannelPushFrame channel) {
        this.isDirty.set(true);
        EncoderSink sink = new EncoderSink(mutex, cb, this.sinkCounter++, channel);
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Adding " + sink + " to the capturer");
        }
        this.sinks.append(sink.getId(), (Object)sink);
        return sink;
    }

    public Capturer.Sink addPreviewSink(Object mutex, Capturer.SinkEvents cb) {
        this.isDirty.set(true);
        PreviewSink sink = new PreviewSink(mutex, cb, this.sinkCounter++);
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Adding " + sink + " to the capturer");
        }
        this.sinks.append(sink.getId(), (Object)sink);
        return sink;
    }

    public void removeSink(Capturer.Sink sink) {
        this.isDirty.set(true);
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Removing " + sink + " from the capturer");
        }
        AbstractSink abstractSink = (AbstractSink)sink;
        this.removedSinks.append(abstractSink.getId(), (Object)abstractSink);
        this.sinks.delete(abstractSink.getId());
    }

    public void syncWith(SurfaceTextureChannel channel) throws GLException {
        AbstractSink sink;
        int i;
        int num;
        if (!this.isDirty.getAndSet(false)) {
            return;
        }
        if (this.removedSinks.size() > 0) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", this.simpleClassName + ": Got " + this.removedSinks.size() + " removed sinks");
            }
            num = this.removedSinks.size();
            for (i = 0; i < num; ++i) {
                sink = (AbstractSink)this.removedSinks.valueAt(i);
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", this.simpleClassName + ": Deallocating " + sink + " at the " + channel.getClass().getSimpleName());
                }
                channel.deallocateOutput(sink.getId());
                sink.close();
            }
            this.removedSinks.clear();
        }
        num = this.sinks.size();
        for (i = 0; i < num; ++i) {
            TargetSurfaceHolder target;
            sink = (AbstractSink)this.sinks.valueAt(i);
            if (!channel.hasTarget(sink.getId())) {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", this.simpleClassName + ": Allocating " + sink + " at the " + channel.getClass().getSimpleName());
                }
                channel.allocateOutput(sink.getType(), sink.getId(), new AbstractRenderingTarget.Events(){

                    public void onFrameRendered(long timestamp) {
                        sink.onFrameCaptured(timestamp);
                    }
                });
            }
            if ((target = sink.getTargetSurface()) != null) {
                if (!channel.isOutputAttached(sink.getId(), target.getSurface(), target.getResolution())) {
                    if (Log.isLoggable("SLIQ", 4)) {
                        Log.i("SLIQ", this.simpleClassName + ": Attaching " + sink + " to the " + channel.getClass().getSimpleName());
                    }
                    channel.attachOutput(sink.getId(), target.getSurface(), target.getResolution());
                }
            } else if (channel.isOutputAttached(sink.getId())) {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", this.simpleClassName + ": Detaching " + sink + " from the " + channel.getClass().getSimpleName());
                }
                channel.detachOutput(sink.getId());
            }
            channel.setParameters(sink.getId(), sink.isEnabled(), sink.getRotationAngle(), sink.getFitFactor(), sink.isHorizFlipped(), sink.isVertFlipped(), sink.getTargetFrameRate());
        }
    }

    public void setChannel(ChannelPushFrame channel) {
        int num = this.sinks.size();
        for (int i = 0; i < num; ++i) {
            AbstractSink sink = (AbstractSink)this.sinks.valueAt(i);
            if (!(sink instanceof EncoderSink)) continue;
            ((EncoderSink)sink).setChannel(channel);
        }
    }

    public void close() {
        int i;
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Closing");
        }
        int num = this.removedSinks.size();
        for (i = 0; i < num; ++i) {
            ((AbstractSink)this.removedSinks.valueAt(i)).close();
        }
        this.removedSinks.clear();
        num = this.sinks.size();
        for (i = 0; i < num; ++i) {
            ((AbstractSink)this.sinks.valueAt(i)).close();
        }
        this.sinks.clear();
    }

    public String toString() {
        return this.simpleClassName + " [sinkCounter=" + this.sinkCounter + ", sinks=" + this.sinks + ", removedSinks=" + this.removedSinks + "]";
    }

    private class PreviewSink
    extends AbstractSink {
        public PreviewSink(Object mutex, Capturer.SinkEvents cb, int id) {
            super(mutex, cb, id);
        }

        public SurfaceTextureChannel.OutputType getType() {
            return SurfaceTextureChannel.OutputType.SCREEN;
        }

        public void onFrameCaptured(long timestamp) {
        }

        public boolean canReleaseSurface() {
            return false;
        }

        public void setTargetFrameRate(float fps) {
        }

        public float getTargetFrameRate() {
            return 0.0f;
        }

        public boolean pushFrame() throws CapturerException {
            return false;
        }
    }

    private class EncoderSink
    extends AbstractSink {
        private float targetFps;
        private volatile ChannelPushFrame channel;

        public EncoderSink(Object mutex, Capturer.SinkEvents cb, int id, ChannelPushFrame channel) {
            super(mutex, cb, id);
            this.targetFps = 30.0f;
            this.channel = channel;
        }

        public SurfaceTextureChannel.OutputType getType() {
            return SurfaceTextureChannel.OutputType.ENCODER;
        }

        public void onFrameCaptured(long timestamp) {
            this.cb.onFrameCaptured(timestamp);
        }

        public boolean canReleaseSurface() {
            return true;
        }

        public void setTargetFrameRate(float fps) {
            CapturerSinks.this.isDirty.set(true);
            this.targetFps = fps;
        }

        public float getTargetFrameRate() {
            return this.targetFps;
        }

        public boolean pushFrame() throws CapturerException {
            if (this.channel != null) {
                try {
                    return this.channel.executePushFrame(this.id);
                }
                catch (GLException e) {
                    throw new CapturerException("Push encoder frame failed", e);
                }
            }
            if (Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", "Attempt to push frame when channel does not exist");
            }
            return false;
        }

        public void setChannel(ChannelPushFrame channel) {
            this.channel = channel;
        }
    }

    private abstract class AbstractSink
    implements Capturer.Sink,
    Closeable {
        private final Object targetSurfaceMutex = new Object();
        protected final Object sharedMutex;
        protected final int id;
        private TargetSurfaceHolder newTarget;
        private TargetSurfaceHolder currentTarget;
        private volatile boolean isEnabled;
        private volatile int rotationAngle;
        private volatile boolean isHorizFlipped;
        private volatile boolean isVertFlipped;
        private volatile float fitFactor;
        protected final Capturer.SinkEvents cb;

        public abstract void onFrameCaptured(long var1);

        public abstract SurfaceTextureChannel.OutputType getType();

        public abstract boolean canReleaseSurface();

        protected AbstractSink(Object mutex, Capturer.SinkEvents cb, int id) {
            this.sharedMutex = mutex;
            this.cb = cb;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachSurface(Object surface, Resolution resolution) {
            if (!(surface instanceof Surface) && !(surface instanceof SurfaceTexture)) {
                throw new IllegalArgumentException(surface.getClass().getCanonicalName() + " is not supported");
            }
            Object object = this.sharedMutex;
            synchronized (object) {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", CapturerSinks.this.simpleClassName + " #" + this.id + " Surface provided: " + surface + " at " + resolution);
                }
                this.setTarget(surface, resolution);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResolution(Resolution resolution) {
            Object object = this.sharedMutex;
            synchronized (object) {
                Object object2 = this.targetSurfaceMutex;
                synchronized (object2) {
                    if (this.newTarget == null) {
                        throw new IllegalStateException("no surface attached");
                    }
                    if (Log.isLoggable("SLIQ", 4)) {
                        Log.i("SLIQ", CapturerSinks.this.simpleClassName + " #" + this.id + " Surface resolution provided: " + resolution);
                    }
                    this.newTarget.setResolution(resolution);
                    CapturerSinks.this.isDirty.set(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detachSurface() {
            Object object = this.sharedMutex;
            synchronized (object) {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", CapturerSinks.this.simpleClassName + " #" + this.id + " Surface abandoned");
                }
                this.setTarget(null, null);
            }
        }

        public void setEnabled(boolean isEnabled) {
            CapturerSinks.this.isDirty.set(true);
            this.isEnabled = isEnabled;
        }

        public void setRotationAngle(int rotationAngle) {
            CapturerSinks.this.isDirty.set(true);
            this.rotationAngle = rotationAngle;
        }

        public void setFlipped(boolean isHorizFlipped, boolean isVertFlipped) {
            CapturerSinks.this.isDirty.set(true);
            this.isHorizFlipped = isHorizFlipped;
            this.isVertFlipped = isVertFlipped;
        }

        public void setFitFactor(float fitFactor) {
            CapturerSinks.this.isDirty.set(true);
            this.fitFactor = fitFactor;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public int getRotationAngle() {
            return this.rotationAngle;
        }

        public float getFitFactor() {
            return this.fitFactor;
        }

        public boolean isHorizFlipped() {
            return this.isHorizFlipped;
        }

        public boolean isVertFlipped() {
            return this.isVertFlipped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TargetSurfaceHolder getTargetSurface() {
            Object object = this.targetSurfaceMutex;
            synchronized (object) {
                if (this.newTarget != null) {
                    if (this.currentTarget != null && this.currentTarget != this.newTarget) {
                        if (Log.isLoggable("SLIQ", 3)) {
                            Log.d("SLIQ", CapturerSinks.this.simpleClassName + " #" + this.id + " Closing old " + this.currentTarget);
                        }
                        this.currentTarget.close();
                    }
                } else if (this.currentTarget != null) {
                    if (Log.isLoggable("SLIQ", 3)) {
                        Log.d("SLIQ", CapturerSinks.this.simpleClassName + " #" + this.id + " Closing old " + this.currentTarget);
                    }
                    this.currentTarget.close();
                }
                this.currentTarget = this.newTarget;
                return this.currentTarget;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTarget(Object surface, Resolution resolution) {
            Object object = this.targetSurfaceMutex;
            synchronized (object) {
                if (this.newTarget == null && surface == null || this.newTarget != null && this.newTarget.getSurface() == surface) {
                    if (this.newTarget != null && resolution != null & !resolution.equals(this.newTarget.getResolution())) {
                        this.newTarget.setResolution(resolution);
                        CapturerSinks.this.isDirty.set(true);
                    }
                } else {
                    if (this.newTarget != null && this.currentTarget != this.newTarget) {
                        if (Log.isLoggable("SLIQ", 3)) {
                            Log.d("SLIQ", CapturerSinks.this.simpleClassName + " #" + this.id + " Closing unused " + this.newTarget);
                        }
                        this.newTarget.close();
                    }
                    this.newTarget = surface != null ? new TargetSurfaceHolder(surface, resolution, this.canReleaseSurface()) : null;
                    CapturerSinks.this.isDirty.set(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.sharedMutex;
            synchronized (object) {
                if (this.newTarget == null && this.currentTarget != null) {
                    if (Log.isLoggable("SLIQ", 3)) {
                        Log.d("SLIQ", CapturerSinks.this.simpleClassName + " #" + this.id + " Closing old " + this.currentTarget);
                    }
                    this.currentTarget.close();
                    this.currentTarget = null;
                }
            }
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractSink other = (AbstractSink)obj;
            return this.id == other.id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return CapturerSinks.this.simpleClassName + " #" + this.id + " [ ( " + this.currentTarget + " -> " + this.newTarget + " ), @" + this.rotationAngle + " deg" + (!this.isEnabled ? ", disabled" : "") + (this.isHorizFlipped ? ", H-flipped" : "") + (this.isVertFlipped ? ", V-flipped" : "") + "]";
        }
    }

    public static class TargetSurfaceHolder
    implements Closeable {
        private final boolean canReleaseSurface;
        private Object surface;
        private Resolution resolution;

        public TargetSurfaceHolder(Object surface, Resolution resolution, boolean canReleaseSurface) {
            this.canReleaseSurface = canReleaseSurface;
            this.surface = surface;
            this.resolution = resolution;
        }

        public Object getSurface() {
            return this.surface;
        }

        public Resolution getResolution() {
            return this.resolution;
        }

        public void setResolution(Resolution resolution) {
            this.resolution = resolution;
        }

        public void close() {
            if (this.surface != null) {
                if (this.canReleaseSurface) {
                    if (Log.isLoggable("SLIQ", 4)) {
                        Log.i("SLIQ", Capturer.class.getSimpleName() + ": Releasing surface: " + this);
                    }
                    if (this.surface instanceof Surface) {
                        ((Surface)this.surface).release();
                    } else if (this.surface instanceof SurfaceTexture) {
                        ((SurfaceTexture)this.surface).release();
                    } else {
                        throw new IllegalArgumentException(this.surface.getClass().getCanonicalName() + " is not supported");
                    }
                }
                this.surface = null;
            }
            this.resolution = null;
        }

        public String toString() {
            return this.surface + " at " + this.resolution;
        }
    }
}

