/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc.omx;

import android.os.IBinder;
import com.skype.android.jipc.Locator;
import com.skype.android.jipc.Transactor;
import com.skype.android.jipc.inout.InHeader;
import com.skype.android.jipc.inout.OutBinder;
import com.skype.android.jipc.inout.OutBoolean;
import com.skype.android.jipc.inout.OutInt32;
import com.skype.android.jipc.inout.OutMayBe;
import com.skype.android.jipc.inout.OutStatus;
import com.skype.android.jipc.omx.CallRouter;
import com.skype.android.jipc.omx.OmxObserver;
import com.skype.android.jipc.omx.ServicePath;
import com.skype.android.jipc.omx.data.ExtendedIndex;
import com.skype.android.jipc.omx.data.OmxStruct;
import com.skype.android.jipc.omx.enums.OmxCore;
import com.skype.android.jipc.omx.enums.OmxIndex;
import com.skype.android.jipc.omx.inout.InNewNode;
import com.skype.android.jipc.omx.inout.InNode;
import com.skype.android.jipc.omx.inout.InNodeCfg;
import com.skype.android.jipc.omx.inout.InNodeCmd;
import com.skype.android.jipc.omx.inout.InNodeExt;
import com.skype.android.jipc.omx.inout.InNodePid;
import com.skype.android.jipc.omx.inout.OutCodecs;
import com.skype.android.jipc.omx.inout.OutParam;
import com.skype.android.jipc.omx.inout.OutState;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OmxFacade {
    public static final String IF_OMX = "android.hardware.IOMX";
    public static final String IF_OMX_OBSERVER = "android.hardware.IOMXObserver";
    public static final int OMX_COMPONENT_UNUSED = OmxIndex.Component.OMX_IndexComponentStartUnused.value();
    private final ServicePath servicePath;
    private final CallRouter callRouter;
    private final InHeader serviceCallHeader;
    private final InHeader mainOmxCallHeader;
    private final InNewNode inNewNode = new InNewNode();
    private final InNode inNode = new InNode();
    private final InNodeCfg inNodeCfg;
    private final InNodeCmd inNodeCmd;
    private final InNodeExt inNodeExt;
    private final InNodePid inNodePid;
    private final OutBinder outBinder = new OutBinder();
    private final OutCodecs outCodecs = new OutCodecs();
    private final OutStatus outStatus = new OutStatus();
    private final OutInt32 outInt32 = new OutInt32();
    private final OutBoolean outBoolean = new OutBoolean();
    private final OutMayBe<Void, OutInt32> outMayBeInt32;
    private final OutState outState = new OutState(this.outStatus);
    private final OutParam outParam = new OutParam();
    private final OutMayBe<Void, OutParam> outMayBeParam;

    OmxFacade(ServicePath servicePath, CallRouter callRouter) {
        this.servicePath = servicePath;
        this.callRouter = callRouter;
        this.serviceCallHeader = new InHeader(servicePath.serviceInterfaceToken);
        this.mainOmxCallHeader = new InHeader(IF_OMX);
        this.inNodeCfg = new InNodeCfg(this.inNode);
        this.inNodeCmd = new InNodeCmd(this.inNode);
        this.inNodePid = new InNodePid(this.inNode);
        this.inNodeExt = new InNodeExt(this.inNode);
        this.outMayBeInt32 = new OutMayBe(this.outStatus, this.outInt32);
        this.outMayBeParam = new OutMayBe(this.outStatus, this.outParam);
    }

    public IBinder getMediaServer() {
        return Locator.getInstance().locate(this.servicePath.serviceName);
    }

    public IBinder getOMX(IBinder mediaServer) {
        return Transactor.transact(mediaServer, this.callRouter.getOmx(), this.serviceCallHeader, this.outBinder);
    }

    public IBinder getOMX() {
        return this.getOMX(this.getMediaServer());
    }

    public OutStatus refStatus() {
        return this.outStatus;
    }

    public Map<String, Collection<String>> getCapabilities(IBinder omx) {
        return Transactor.transact(omx, this.callRouter.listNodes(), this.mainOmxCallHeader, this.outCodecs);
    }

    public OutMayBe<Void, OutInt32> allocateNode(IBinder omx, OmxObserver observer, String codecName) {
        observer.lock();
        this.inNewNode.set(codecName, (IBinder)observer);
        Transactor.transact(omx, this.callRouter.allocateNode(), this.inNewNode, this.outMayBeInt32);
        this.inNewNode.clear();
        if (this.outMayBeInt32.status.isOk()) {
            observer.markNodeId(((OutInt32)this.outMayBeInt32.value).value());
        } else {
            observer.unlock();
        }
        return this.outMayBeInt32;
    }

    public OutStatus freeNode(IBinder omx, int nodeId, OmxObserver observer) {
        observer.ensureNodeId(nodeId);
        this.inNode.setNodeId(nodeId);
        Transactor.transact(omx, this.callRouter.freeNode(), this.inNode, this.outStatus);
        observer.unlock();
        return this.outStatus;
    }

    public OutBoolean livesLocally(IBinder omx, int nodeId) {
        this.inNode.setNodeId(nodeId);
        Transactor.transact(omx, this.callRouter.livesLocally(), this.inNodePid, this.outBoolean);
        return this.outBoolean;
    }

    public OutStatus sendCommand(IBinder omx, int nodeId, OmxCore.Command command) {
        return this.sendCommand(omx, nodeId, command, 0);
    }

    public OutStatus sendCommand(IBinder omx, int nodeId, OmxCore.Command command, int param) {
        this.inNodeCmd.set(nodeId, command, param);
        Transactor.transact(omx, this.callRouter.sendCommand(), this.inNodeCmd, this.outStatus);
        return this.outStatus;
    }

    public OutState getState(IBinder omx, int nodeId) {
        this.inNode.setNodeId(nodeId);
        Transactor.transact(omx, this.callRouter.getState(), this.inNode, this.outState);
        return this.outState;
    }

    private static boolean eq(Object one, Object two) {
        return one == two;
    }

    private <T, O extends Transactor.Out<T>> OutStatus assign(IBinder omx, Transactor.What code, int nodeId, OmxStruct param, O out) {
        OmxIndex index = param.getIndex();
        if (index instanceof ExtendedIndex) {
            ((ExtendedIndex)index).queryValueOnce(this, omx, nodeId);
            if (index.value() == OMX_COMPONENT_UNUSED) {
                this.outStatus.setDefaultValue(OmxCore.Error.OMX_ErrorComponentNotFound.value);
            }
            if (!this.outStatus.isOk()) {
                return this.outStatus;
            }
        }
        this.inNodeCfg.set(nodeId, param);
        if (OmxFacade.eq(out, this.outMayBeParam)) {
            this.outParam.setStruct(param);
        }
        Transactor.transact(omx, code, this.inNodeCfg, out);
        return this.outStatus;
    }

    public OutStatus getParameter(IBinder omx, int nodeId, OmxStruct param) {
        return this.assign(omx, this.callRouter.getParameter(), nodeId, param, this.outMayBeParam);
    }

    public OutStatus setParameter(IBinder omx, int nodeId, OmxStruct param) {
        return this.assign(omx, this.callRouter.setParameter(), nodeId, param, this.outStatus);
    }

    public OutStatus getConfig(IBinder omx, int nodeId, OmxStruct param) {
        return this.assign(omx, this.callRouter.getConfig(), nodeId, param, this.outMayBeParam);
    }

    public OutStatus setConfig(IBinder omx, int nodeId, OmxStruct param) {
        return this.assign(omx, this.callRouter.setConfig(), nodeId, param, this.outStatus);
    }

    public OutMayBe<Void, OutInt32> getExtensionIndex(IBinder omx, int nodeId, String extName) {
        this.inNodeExt.set(nodeId, extName);
        this.outInt32.setDefaultValue(OMX_COMPONENT_UNUSED);
        Transactor.transact(omx, this.callRouter.getExtensionIndex(), this.inNodeExt, this.outMayBeInt32);
        return this.outMayBeInt32;
    }
}

