/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.jipc;

import android.os.Parcel;
import com.skype.android.jipc.Enumerable;
import com.skype.android.jipc.SizeOf;
import com.skype.android.jipc.Transactor;
import com.skype.android.jipc.inout.OutInt32;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Struct
implements SizeOf,
Transactor.In,
Transactor.Out<Void> {
    private static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    protected static final int WORD_SIZE = 4;
    protected static final int HALF_WORD = 2;
    private final int wordCount;
    private final int byteCount;
    protected final ByteBuffer rawBuffer;
    protected final ShortBuffer shortBuffer;
    protected final IntBuffer intBuffer;

    public Struct(boolean direct, int wordCount) {
        this.wordCount = wordCount;
        this.byteCount = wordCount * 4;
        this.rawBuffer = (direct ? ByteBuffer.allocateDirect(this.byteCount) : ByteBuffer.allocate(this.byteCount)).order(BYTE_ORDER);
        this.shortBuffer = this.rawBuffer.asShortBuffer();
        this.intBuffer = this.rawBuffer.asIntBuffer();
        this.clear();
    }

    public Struct(int wordCount) {
        this(false, wordCount);
    }

    @Override
    public int size() {
        return this.byteCount;
    }

    @Override
    public void prepare(Parcel in) {
        for (int i = 0; i < this.wordCount; ++i) {
            in.writeInt(this.intBuffer.get(i));
        }
    }

    @Override
    public Void parse(Parcel reply) {
        for (int i = 0; i < this.wordCount; ++i) {
            this.intBuffer.put(i, reply.readInt());
        }
        return null;
    }

    public void reset() {
        this.clear();
    }

    private void clear() {
        for (int i = 0; i < this.rawBuffer.capacity(); ++i) {
            this.rawBuffer.put(i, (byte)0);
        }
        this.rawBuffer.clear();
        this.intBuffer.clear();
    }

    private void assertDirect(boolean ensureDirect) {
        if (ensureDirect && !this.rawBuffer.isDirect()) {
            throw new UnsupportedOperationException("Underlying storage is not direct");
        }
    }

    public Buffer asBuffer(boolean ensureDirect) {
        this.assertDirect(ensureDirect);
        return this.rawBuffer;
    }

    public Buffer asSlice(int startPos, int endPos, boolean ensureDirect) {
        this.assertDirect(ensureDirect);
        IntBuffer clonePositions = this.intBuffer.duplicate();
        clonePositions.position(startPos).limit(endPos);
        return clonePositions.slice();
    }

    public Buffer asSlice(int startPos, int endPos) {
        return this.asSlice(startPos, endPos, true);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Struct)) {
            return false;
        }
        ByteBuffer warBuffer = ((Struct)obj).rawBuffer;
        int aCityPac = warBuffer.capacity();
        if (aCityPac != this.rawBuffer.capacity()) {
            return false;
        }
        if (warBuffer.order() != this.rawBuffer.order()) {
            return false;
        }
        for (int i = 0; i < aCityPac; ++i) {
            if (warBuffer.get(i) == this.rawBuffer.get(i)) continue;
            return false;
        }
        return true;
    }

    public static class LongField {
        private final Struct struct;
        private final int int32Pos;

        public LongField(Struct struct, int int32Pos) {
            this.int32Pos = int32Pos;
            this.struct = struct;
        }

        public long get() {
            int lowWord = this.struct.intBuffer.get(this.int32Pos);
            long highWord = this.struct.intBuffer.get(this.int32Pos + 1);
            return highWord << 32 | (long)lowWord;
        }

        public void set(long value) {
            this.struct.intBuffer.put(this.int32Pos, (int)value);
            this.struct.intBuffer.put(this.int32Pos + 1, (int)(value >> 32));
        }

        public String toString() {
            long value = this.get();
            return String.format("%d 0x%016x", value, value);
        }
    }

    public static class ShortField {
        private final Struct struct;
        private final int position;

        public ShortField(Struct struct, int position, int halfword) {
            if (halfword < 0 || halfword >= 2) {
                throw new IllegalArgumentException("Must be 0 or 1: " + halfword);
            }
            this.position = position * 2 + halfword;
            this.struct = struct;
        }

        public short get() {
            return this.struct.shortBuffer.get(this.position);
        }

        public void set(short value) {
            this.struct.shortBuffer.put(this.position, value);
        }

        public String toString() {
            short value = this.get();
            return String.format("%d 0x%04x", value, value);
        }
    }

    public static class IntField {
        private final Struct struct;
        private final int position;

        public IntField(Struct struct, int position) {
            this.position = position;
            this.struct = struct;
        }

        public int get() {
            return this.struct.intBuffer.get(this.position);
        }

        public void set(int value) {
            this.struct.intBuffer.put(this.position, value);
        }

        public boolean isTrue() {
            return this.get() != 0;
        }

        public void set(boolean value) {
            this.set(value ? 1 : 0);
        }

        public void set(Enumerable enumerable) {
            this.set(enumerable.value());
        }

        public String toString() {
            return OutInt32.toString(this.get());
        }
    }
}

