/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.AudioOptions;
import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.IdentifierHelpers;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoOptions;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.communication.common.PhoneNumberIdentifier;

public final class StartCallOptions {
    long handle;

    StartCallOptions(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_start_call_options_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public StartCallOptions() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_start_call_options_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_release(this.handle));
        this.handle = 0L;
    }

    private String getAlternateId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_get_alternate_id(this.handle, result));
        return (String)result.value;
    }

    private StartCallOptions setAlternateId(String value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_set_alternate_id(this.handle, value));
        return this;
    }

    public VideoOptions getVideoOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_get_video_options(this.handle, result_handle));
        VideoOptions result_object = (Long)result_handle.value != 0L ? VideoOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public StartCallOptions setVideoOptions(VideoOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_set_video_options(this.handle, value_converted));
        return this;
    }

    public AudioOptions getAudioOptions() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_get_audio_options(this.handle, result_handle));
        AudioOptions result_object = (Long)result_handle.value != 0L ? AudioOptions.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public StartCallOptions setAudioOptions(AudioOptions value) {
        long value_converted = value != null ? value.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_start_call_options_set_audio_options(this.handle, value_converted));
        return this;
    }

    static StartCallOptions getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.StartCallOptions, StartCallOptions.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_start_call_options_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.StartCallOptions, StartCallOptions.class, false);
    }

    public StartCallOptions setAlternateCallerId(PhoneNumberIdentifier alternatePhoneNumber) {
        this.setAlternateId(IdentifierHelpers.toMRI((CommunicationIdentifier)alternatePhoneNumber));
        return this;
    }

    public PhoneNumberIdentifier getAlternateCallerId() {
        return (PhoneNumberIdentifier)IdentifierHelpers.from(this.getAlternateId());
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

