/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.MediaStreamType;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import java.util.ArrayList;
import java.util.List;

public final class RemoteVideoStream {
    long handle;
    private List<PropertyChangedListener> OnVideoStatusChangedListeners = new ArrayList<PropertyChangedListener>();

    RemoteVideoStream(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_remote_video_stream_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    RemoteVideoStream(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_release(this.handle));
        this.handle = 0L;
    }

    public boolean isAvailable() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_get_is_available(this.handle, result));
        return (Boolean)result.value;
    }

    public MediaStreamType getMediaStreamType() {
        Out<MediaStreamType> result = new Out<MediaStreamType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_get_media_stream_type(this.handle, result));
        return (MediaStreamType)((Object)result.value);
    }

    public int getId() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_get_id(this.handle, result));
        return (Integer)result.value;
    }

    private static void OnVideoStatusChangedStaticHandler(long cookie, long args) {
        RemoteVideoStream instance = RemoteVideoStream.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? PropertyChangedEvent.getInstance(args, false) : null;
            for (PropertyChangedListener listener : instance.OnVideoStatusChangedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    private void addOnVideoStatusChangedListener(PropertyChangedListener listener) {
        this.OnVideoStatusChangedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnVideoStatusChanged", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_set_on_video_status_changed(this.handle, this.getHandle(), this));
    }

    private void removeOnVideoStatusChangedListener(PropertyChangedListener listener) {
        this.OnVideoStatusChangedListeners.remove(listener);
        if (ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnVideoStatusChanged", listener)) {
            NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_set_on_video_status_changed(this.handle, 0L, null));
        }
    }

    private void startInternal() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_start_internal(this.handle));
    }

    private void stopInternal() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_stop_internal(this.handle));
    }

    private void createBindingInternal(int bindingType, long bindingEvent) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_create_binding_internal(this.handle, bindingType, bindingEvent));
    }

    private void releaseBindingInternal(long binding) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_release_binding_internal(this.handle, binding));
    }

    private void releaseBindingExInternal(int bindingType, long bindingEvent) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_remote_video_stream_release_binding_ex_internal(this.handle, bindingType, bindingEvent));
    }

    static RemoteVideoStream getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RemoteVideoStream, RemoteVideoStream.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_remote_video_stream_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RemoteVideoStream, RemoteVideoStream.class, false);
    }

    private static RemoteVideoStream getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.RemoteVideoStream, RemoteVideoStream.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnVideoStatusChanged")) {
            this.addOnVideoStatusChangedListener((PropertyChangedListener)eventListener);
        }
    }

    void start() {
        this.startInternal();
    }

    void stop() {
        this.stopInternal();
    }

    void createBinding(int bindingType, long bindingEvent) {
        this.createBindingInternal(bindingType, bindingEvent);
    }

    void releaseBinding(long binding) {
        this.releaseBindingInternal(binding);
    }

    void addOnVideoStatusChangedListenerInternal(PropertyChangedListener listener) {
        this.addOnVideoStatusChangedListener(listener);
    }

    void removeOnVideoStatusChangedListenerInternal(PropertyChangedListener listener) {
        this.removeOnVideoStatusChangedListener(listener);
    }
}

