/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class ProjectedObjectEventHandlerCache {
    private static HashMap<Long, HashMap<String, Set<Object>>> tracked = new HashMap();

    ProjectedObjectEventHandlerCache() {
    }

    static boolean isEmpty() {
        return tracked.size() == 0;
    }

    static void addEventHandler(Object instance, long cookie, String eventName, Object handler) {
        ProjectedObjectEventHandlerCache.addOrRemoveEventHandler(HandlerType.Add, instance, cookie, eventName, handler);
    }

    static boolean removeEventHandler(Object instance, long cookie, String eventName, Object handler) {
        return ProjectedObjectEventHandlerCache.addOrRemoveEventHandler(HandlerType.Remove, instance, cookie, eventName, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addOrRemoveEventHandler(HandlerType handlerType, Object instance, long cookie, String eventName, Object handler) {
        if (instance == null) {
            throw new IllegalArgumentException("Invalid instance");
        }
        if (cookie == 0L) {
            throw new IllegalArgumentException(String.format("The value of %s is not valid.", instance.toString()));
        }
        if (eventName == null || eventName.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("The argument is either null, empty, or whitespace.", instance.toString()));
        }
        if (handler == null) {
            throw new IllegalArgumentException("The event handler cannot be null");
        }
        HashMap<Long, HashMap<String, Set<Object>>> hashMap = tracked;
        synchronized (hashMap) {
            Set<Object> eventDelegates = ProjectedObjectEventHandlerCache.getOrInitializeEventHandlers(instance, cookie, eventName);
            if (handlerType == HandlerType.Add) {
                eventDelegates.add(handler);
            } else {
                eventDelegates.remove(handler);
            }
            return eventDelegates.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Set<T> getEventHandlers(Object instance, long cookie, String eventName) {
        if (instance == null) {
            throw new IllegalArgumentException("Invalid instance");
        }
        if (cookie == 0L) {
            throw new IllegalArgumentException(String.format("The value of %s is not valid.", instance.toString()));
        }
        if (eventName == null || eventName.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("The argument is either null, empty, or whitespace.", new Object[0]));
        }
        HashMap<Long, HashMap<String, Set<Object>>> hashMap = tracked;
        synchronized (hashMap) {
            HashMap<String, Set<Object>> events = tracked.get(cookie);
            if (events == null) {
                return Collections.emptySet();
            }
            Set<Object> handlers = events.get(eventName);
            if (handlers == null) {
                return Collections.emptySet();
            }
            return handlers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(long cookie) {
        if (cookie == 0L) {
            throw new IllegalArgumentException(String.format("The cookie is not valid: %d.", cookie));
        }
        HashMap<Long, HashMap<String, Set<Object>>> hashMap = tracked;
        synchronized (hashMap) {
            tracked.remove(cookie);
        }
    }

    private static Set<Object> getOrInitializeEventHandlers(Object instance, long cookie, String eventName) {
        HashMap<String, Set<Object>> events = ProjectedObjectEventHandlerCache.getOrInitializeEvents(instance, cookie);
        Set<Object> handlers = events.get(eventName);
        if (handlers == null) {
            handlers = new HashSet<Object>();
            events.put(eventName, handlers);
        }
        return handlers;
    }

    private static HashMap<String, Set<Object>> getOrInitializeEvents(Object instance, long cookie) {
        HashMap<String, Set<Object>> events = tracked.get(cookie);
        if (events == null) {
            events = new HashMap();
            tracked.put(cookie, events);
        }
        return events;
    }

    private static enum HandlerType {
        Add,
        Remove;

    }
}

