/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.ProjectedObjectFactory;
import java.lang.ref.WeakReference;
import java.util.HashMap;

class ProjectedObjectCache {
    private static HashMap<Long, WeakReference<Object>> tracked = new HashMap();

    ProjectedObjectCache() {
    }

    static boolean isEmpty() {
        return tracked.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(Object instance, long cookie) {
        if (instance == null) {
            throw new IllegalArgumentException("Invalid instance");
        }
        if (cookie == 0L) {
            throw new IllegalArgumentException(String.format("The value of %s is not valid.", instance.toString()));
        }
        HashMap<Long, WeakReference<Object>> hashMap = tracked;
        synchronized (hashMap) {
            WeakReference<Object> cachedReference = tracked.get(cookie);
            if (cachedReference == null || cachedReference.get() == null) {
                tracked.put(cookie, new WeakReference<Object>(instance));
            }
        }
    }

    static <T> T getOrCreate(long cookie, ModelClass type, Class<T> classType, boolean transfer) {
        return ProjectedObjectCache.getOrCreate(cookie, type, classType, transfer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T getOrCreate(long cookie, ModelClass type, Class<T> classType, boolean transfer, ProjectedObjectCacheListener listener) {
        Object referenceTarget;
        if (cookie == 0L) {
            throw new IllegalArgumentException(String.format("The cookie is not valid: {%d}.", cookie));
        }
        HashMap<Long, WeakReference<Object>> hashMap = tracked;
        synchronized (hashMap) {
            WeakReference<Object> reference = tracked.get(cookie);
            if (reference == null || (referenceTarget = reference.get()) == null) {
                referenceTarget = ProjectedObjectFactory.create(cookie, type, transfer);
                tracked.put(cookie, new WeakReference(referenceTarget));
            } else if (listener != null) {
                listener.onCacheHit();
            }
        }
        return classType.cast(referenceTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(long cookie) {
        if (cookie == 0L) {
            throw new IllegalArgumentException(String.format("The cookie is not valid: {%d}.", cookie));
        }
        HashMap<Long, WeakReference<Object>> hashMap = tracked;
        synchronized (hashMap) {
            tracked.remove(cookie);
        }
    }

    private static void ProjectedObjectCleanupStaticHandler(long cookie) {
        ProjectedObjectCache.remove(cookie);
        ProjectedObjectEventHandlerCache.remove(cookie);
    }
}

