/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.MediaStreamType;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.PermissionUtility;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoDeviceInfo;
import com.azure.android.communication.calling.VideoStreamRenderer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;

public final class LocalVideoStream {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;

    LocalVideoStream(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_local_video_stream_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public LocalVideoStream(VideoDeviceInfo camera, Context context) {
        long camera_converted = camera != null ? camera.getHandle() : 0L;
        Out<Long> result_handle = new Out<Long>();
        PermissionUtility.throwIfNotAppropriatePermissions(context, false, true);
        Status resultStatus = NativeLibrary.sam_local_video_stream_create_video_device_info_camera_context_context(camera_converted, context, result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_release(this.handle));
        this.handle = 0L;
    }

    public VideoDeviceInfo getSource() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_get_source(this.handle, result_handle));
        VideoDeviceInfo result_object = (Long)result_handle.value != 0L ? VideoDeviceInfo.getInstance((Long)result_handle.value, true) : null;
        return result_object;
    }

    public boolean isSending() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_get_is_sending(this.handle, result));
        return (Boolean)result.value;
    }

    public MediaStreamType getMediaStreamType() {
        Out<MediaStreamType> result = new Out<MediaStreamType>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_get_media_stream_type(this.handle, result));
        return (MediaStreamType)((Object)result.value);
    }

    private void setVideoDevice(VideoDeviceInfo videoDevice) {
        long videoDevice_converted = videoDevice != null ? videoDevice.getHandle() : 0L;
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_set_video_device(this.handle, videoDevice_converted));
    }

    private CompletableFuture<Void> switchSourceInternal(final VideoDeviceInfo videoDevice) {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                long videoDevice_converted = videoDevice != null ? videoDevice.getHandle() : 0L;
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_local_video_stream_switch_source_internal(handle, videoDevice_converted));
            }
        }, (Executor)executor);
    }

    private int getVideoObjectId() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_get_video_object_id(this.handle, result));
        return (Integer)result.value;
    }

    private void createBindingInternal(int bindingType, long bindingEvent) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_create_binding_internal(this.handle, bindingType, bindingEvent));
    }

    private void releaseBindingInternal(int bindingType, long bindingEvent) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_local_video_stream_release_binding_internal(this.handle, bindingType, bindingEvent));
    }

    static LocalVideoStream getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoStream, LocalVideoStream.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_local_video_stream_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.LocalVideoStream, LocalVideoStream.class, false);
    }

    int getId() {
        return this.getVideoObjectId();
    }

    void createBinding(int bindingType, long bindingEvent) {
        this.createBindingInternal(bindingType, bindingEvent);
    }

    void releaseBinding(int bindingType, long bindingEvent) {
        this.releaseBindingInternal(bindingType, bindingEvent);
    }

    public CompletableFuture<Void> switchSource(final VideoDeviceInfo camera) {
        final LocalVideoStream localVideoStream = this;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean bindingActive;
                int causeId = (int)(Math.random() * 1.6777215E7);
                VideoStreamRenderer videoStreamRenderer = VideoStreamRenderer.getRenderer(localVideoStream);
                boolean bl = bindingActive = videoStreamRenderer != null;
                if (bindingActive) {
                    videoStreamRenderer.releaseLocalBindingForSwitching(causeId);
                }
                try {
                    localVideoStream.switchSourceInternal(camera).get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    throw new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE);
                }
                if (bindingActive) {
                    videoStreamRenderer.recreateLocalBindingForSwitching(causeId);
                }
            }
        }, (Executor)Executors.newCachedThreadPool());
    }
}

