/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.graphics.gles;

import android.opengl.GLES20;
import com.microsoft.dl.DiagUtils;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.graphics.gles.GLException;
import java.io.Closeable;

public class GLTexture
implements Closeable {
    private final String diagName = DiagUtils.getObjName((Object)this);
    private final Target target;
    private final int name;

    public GLTexture(Target target) throws GLException {
        this.target = target;
        this.name = GLTexture.create();
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)(this.diagName + " created, name=" + this.name));
        }
    }

    public Target getTarget() {
        return this.target;
    }

    public int getName() {
        return this.name;
    }

    public void bind() throws GLException {
        GLES20.glBindTexture((int)this.target.getCode(), (int)this.name);
        GLException.checkAfter("GLES20.glBindTexture()");
    }

    @Override
    public void close() {
        block3: {
            try {
                GLTexture.delete(this.name);
            }
            catch (GLException e) {
                if (!Log.isLoggable((String)"Video", (int)6)) break block3;
                Log.w((String)"Video", (String)(this.diagName + "failed to delete texture, name=" + this.name), (Throwable)e);
            }
        }
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)(this.diagName + " closed"));
        }
    }

    private static int create() throws GLException {
        int[] textures = new int[]{-1};
        GLES20.glGenTextures((int)textures.length, (int[])textures, (int)0);
        GLException.checkAfter("GLES20.glGenTextures()");
        return textures[0];
    }

    private static void delete(int name) throws GLException {
        int[] textures = new int[]{name};
        GLES20.glDeleteTextures((int)textures.length, (int[])textures, (int)0);
        GLException.checkAfter("GLES20.glDeleteTextures()");
    }

    public static enum Target {
        TEXTURE_2D(3553),
        TEXTURE_EXTERNAL_OES(36197);

        private final int code;

        private Target(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

