/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.graphics.egl;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.graphics.egl.AbstractTargetSurfaceContext;
import com.microsoft.dl.video.graphics.egl.EGLException;
import com.microsoft.dl.video.graphics.egl.EGLUtils;
import com.microsoft.dl.video.utils.Resolution;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class WindowSurfaceContext
extends AbstractTargetSurfaceContext {
    private static final int[] CONFIG_ATTRIBUTES = new EGLUtils.ConfigAttributesBuilder().renderableType(EGLUtils.RenderableTypeAttribute.OPENGL_ES2).redSize(8).greenSize(8).blueSize(8).alphaSize(8).depthSize(0).stencilSize(0).surfaceType(EGLUtils.SurfaceTypeAttribute.WINDOW).build();
    private final int[] surfaceWidth = new int[]{0};
    private final int[] surfaceHeight = new int[]{0};

    public WindowSurfaceContext() throws EGLException {
        super(CONFIG_ATTRIBUTES);
    }

    public void attachSurface(Object window) throws EGLException {
        if (window == null) {
            throw new EGLException("No window", ErrorCode.ANDROID_EGL_NO_WINDOW);
        }
        this.releaseSurface();
        int[] surfaceAttributes = new EGLUtils.WindowSurfaceAttributeBuilder().build();
        this.eglSurface = WindowSurfaceContext.createWindowSurface(this.eglDisplay, this.eglConfig, window, surfaceAttributes, this.diagName);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)(this.diagName + " window surface created: [0x" + Integer.toHexString(System.identityHashCode(this.eglSurface)) + "] " + this.getSurfaceInfo()));
        }
    }

    public void detachSurface() throws EGLException {
        super.releaseSurface();
    }

    @Override
    public Resolution getSurfaceSize() throws EGLException {
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            return null;
        }
        if (!EGL.eglQuerySurface(this.eglDisplay, this.eglSurface, EGLUtils.SurfaceAttribute.WIDTH.getCode(), this.surfaceWidth) || !EGL.eglQuerySurface(this.eglDisplay, this.eglSurface, EGLUtils.SurfaceAttribute.HEIGHT.getCode(), this.surfaceHeight)) {
            throw new EGLException("EGL.eglQuerySurface() has failed in " + this.diagName, EGL.eglGetError(), ErrorCode.ANDROID_EGL_QUERY_SURFACE_FAILED);
        }
        EGLException.checkAfter("EGL.eglQuerySurface()", ErrorCode.ANDROID_EGL_QUERY_SURFACE_FAILED);
        if (this.surfaceSize == null || this.surfaceSize.getWidth() != this.surfaceWidth[0] || this.surfaceSize.getHeight() != this.surfaceHeight[0]) {
            this.surfaceSize = new Resolution(this.surfaceWidth[0], this.surfaceHeight[0]);
        }
        return super.getSurfaceSize();
    }

    private static EGLSurface createWindowSurface(EGLDisplay eglDisplay, EGLConfig eglConfig, Object window, int[] attributes, String diagName) throws EGLException {
        EGLSurface eglSurface = EGL.eglCreateWindowSurface(eglDisplay, eglConfig, window, attributes);
        if (eglSurface == null || eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new EGLException("EGL.eglCreateWindowSurface() has failed in " + diagName, EGL.eglGetError(), ErrorCode.ANDROID_EGL_CREATE_WINDOW_SURFACE_FAILED);
        }
        EGLException.checkAfter("EGL.eglCreateWindowSurface()", ErrorCode.ANDROID_EGL_CREATE_WINDOW_SURFACE_FAILED);
        return eglSurface;
    }
}

