/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.graphics.egl;

import android.opengl.GLES20;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.graphics.GraphicsException;
import com.microsoft.dl.video.graphics.egl.AbstractTargetSurfaceContext;
import com.microsoft.dl.video.graphics.egl.EGLException;
import com.microsoft.dl.video.graphics.egl.EGLUtils;
import com.microsoft.dl.video.graphics.gles.GLException;
import com.microsoft.dl.video.utils.Resolution;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class PixelBufferSurfaceContext
extends AbstractTargetSurfaceContext {
    private static final int[] CONFIG_ATTRIBUTES = new EGLUtils.ConfigAttributesBuilder().renderableType(EGLUtils.RenderableTypeAttribute.OPENGL_ES2).redSize(8).greenSize(8).blueSize(8).alphaSize(8).depthSize(0).stencilSize(0).surfaceType(EGLUtils.SurfaceTypeAttribute.PBUFFER).build();
    private int format;
    private ByteBuffer pixelBuffer;

    public PixelBufferSurfaceContext() throws EGLException {
        super(CONFIG_ATTRIBUTES);
    }

    public ByteBuffer allocSurface(Resolution size, BufferFormat bufferFormat) throws EGLException {
        if (size == null) {
            throw new EGLException("size is null", ErrorCode.ANDROID_EGL_NO_SURFACE_SIZE);
        }
        this.releaseSurface();
        int[] surfaceAttributes = new EGLUtils.PBufferSurfaceAttributeBuilder().width(size.getWidth()).height(size.getHeight()).build();
        this.eglSurface = PixelBufferSurfaceContext.createPixelBufferSurface(this.eglDisplay, this.eglConfig, surfaceAttributes, this.diagName);
        this.surfaceSize = size;
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)(this.diagName + " pixel buffer surface created: [0x" + Integer.toHexString(System.identityHashCode(this.eglSurface)) + "] " + this.getSurfaceInfo()));
        }
        switch (bufferFormat) {
            case NoBuffer: {
                this.format = 0;
                this.pixelBuffer = null;
                return null;
            }
            case RGB: {
                this.format = 6407;
                this.pixelBuffer = ByteBuffer.allocateDirect(size.getNumPixels() * 3);
                return this.pixelBuffer;
            }
            case RGBA: {
                this.format = 6408;
                this.pixelBuffer = ByteBuffer.allocateDirect(size.getNumPixels() * 4);
                return this.pixelBuffer;
            }
        }
        throw new AssertionError((Object)("BufferFormat '" + (Object)((Object)bufferFormat) + "' is not supported"));
    }

    @Override
    public void releaseSurface() throws EGLException {
        this.pixelBuffer = null;
        this.format = 0;
        super.releaseSurface();
    }

    @Override
    public void swapBuffers() throws GraphicsException {
        if (this.pixelBuffer != null) {
            GLES20.glReadPixels((int)0, (int)0, (int)this.getSurfaceSize().getWidth(), (int)this.getSurfaceSize().getHeight(), (int)this.format, (int)5121, (Buffer)this.pixelBuffer);
        }
        GLException.checkAfter("GLES20.glReadPixels()");
        super.swapBuffers();
    }

    private static EGLSurface createPixelBufferSurface(EGLDisplay eglDisplay, EGLConfig eglConfig, int[] attributes, String diagName) throws EGLException {
        EGLSurface eglSurface = EGL.eglCreatePbufferSurface(eglDisplay, eglConfig, attributes);
        if (eglSurface == null || eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new EGLException("EGL.eglCreatePbufferSurface() has failed " + diagName, EGL.eglGetError(), ErrorCode.ANDROID_EGL_CREATE_PBUFFER_SURFACE_FAILED);
        }
        EGLException.checkAfter("EGL.eglCreatePbufferSurface()", ErrorCode.ANDROID_EGL_CREATE_PBUFFER_SURFACE_FAILED);
        return eglSurface;
    }

    public static enum BufferFormat {
        NoBuffer,
        RGB,
        RGBA;

    }
}

