/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.utils.Resolution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class ResolutionMatcher {
    private static final int PERCENT = 100;
    private final Set<Resolution> cameraResolutions;
    private final float nativeCameraAR;

    public ResolutionMatcher(Set<Resolution> cameraResolutions, float nativeCameraAR) {
        this.cameraResolutions = cameraResolutions;
        this.nativeCameraAR = nativeCameraAR;
    }

    public ResolutionTransformation findBest(Resolution resoluton, float maxZoom, float maxCrop, EnumSet<TransformationAllowed> transformationsAllowed) throws CaptureException {
        List<EstimatedResolutionTransformation> candidates = this.estimateCandidates(resoluton, transformationsAllowed);
        if (candidates.isEmpty()) {
            return null;
        }
        Collections.sort(candidates);
        if (Log.isLoggable((String)"Video", (int)3)) {
            Log.d((String)"Video", (String)("Resolution preferences for " + resoluton + ": " + candidates));
        }
        for (EstimatedResolutionTransformation candidate : candidates) {
            if (!(candidate.getEstimates().getZoom() <= maxZoom) || !(candidate.getEstimates().getCrop() <= maxCrop)) continue;
            return candidate;
        }
        if (Log.isLoggable((String)"Video", (int)5)) {
            Log.w((String)"Video", (String)("No matching found for " + resoluton + " with max zoom=" + (int)(maxZoom * 100.0f) + "%, crop=" + (int)(maxCrop * 100.0f) + "%"));
        }
        return null;
    }

    private List<EstimatedResolutionTransformation> estimateCandidates(Resolution resoluton, EnumSet<TransformationAllowed> transformationsAllowed) throws CaptureException {
        ArrayList<EstimatedResolutionTransformation> candidates = new ArrayList<EstimatedResolutionTransformation>(this.cameraResolutions.size());
        for (Resolution cameraResolution : this.cameraResolutions) {
            Estimates croppingEstimates;
            if (resoluton.equals(cameraResolution)) {
                croppingEstimates = this.estimateCropping(cameraResolution, resoluton);
                candidates.add(new EstimatedResolutionTransformation(cameraResolution, resoluton, Transformation.Match, croppingEstimates));
                continue;
            }
            if (cameraResolution.getWidth() < resoluton.getWidth() || cameraResolution.getHeight() < resoluton.getHeight()) continue;
            if (transformationsAllowed.contains((Object)TransformationAllowed.Cropping)) {
                croppingEstimates = this.estimateCropping(cameraResolution, resoluton);
                candidates.add(new EstimatedResolutionTransformation(cameraResolution, resoluton, Transformation.Crop, croppingEstimates));
            }
            if (!transformationsAllowed.contains((Object)TransformationAllowed.AllScaling) && !transformationsAllowed.contains((Object)TransformationAllowed.MultipleScaling)) continue;
            Estimates scalingEstimates = this.estimateScaling(cameraResolution, resoluton, transformationsAllowed);
            candidates.add(new EstimatedResolutionTransformation(cameraResolution, resoluton, Transformation.Scale, scalingEstimates));
        }
        return candidates;
    }

    private Estimates estimateScaling(Resolution inputResolution, Resolution outputResoluton, EnumSet<TransformationAllowed> transformationsAllowed) throws CaptureException {
        return new Estimates(Float.MAX_VALUE, Float.MAX_VALUE);
    }

    private Estimates estimateCropping(Resolution inputResolution, Resolution outputResoluton) throws CaptureException {
        float origAspectRatio = (float)inputResolution.getWidth() / (float)inputResolution.getHeight();
        int nativeWidth = origAspectRatio < this.nativeCameraAR ? (int)((float)inputResolution.getHeight() * this.nativeCameraAR) : inputResolution.getWidth();
        int nativeHeight = origAspectRatio > this.nativeCameraAR ? (int)((float)inputResolution.getWidth() / this.nativeCameraAR) : inputResolution.getHeight();
        int cropWidth = nativeWidth - outputResoluton.getWidth() * nativeHeight / outputResoluton.getHeight();
        int cropHeight = nativeHeight - outputResoluton.getHeight() * nativeWidth / outputResoluton.getWidth();
        int outputPixels = outputResoluton.getWidth() * outputResoluton.getHeight();
        int inputPixels = 0;
        float crop = 0.0f;
        if (cropWidth > 0) {
            inputPixels = (nativeWidth - cropWidth) * nativeHeight;
            crop = (float)cropWidth / (float)nativeWidth;
        } else if (cropHeight > 0) {
            inputPixels = (nativeHeight - cropHeight) * nativeWidth;
            crop = (float)cropHeight / (float)nativeHeight;
        } else if (cropWidth == 0 && cropHeight == 0) {
            inputPixels = nativeWidth * nativeHeight;
        } else {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("Invariant failed: inputResolution=" + inputResolution + ", outputResoluton=" + outputResoluton + ", nativeCameraAR=" + this.nativeCameraAR + ", cropWidth=" + cropWidth + ", cropHeight" + cropHeight));
            }
            return new Estimates();
        }
        float zoom = inputPixels > 0 ? (float)(inputPixels - outputPixels) / (float)inputPixels : 0.0f;
        return new Estimates(zoom, crop);
    }

    private static class EstimatedResolutionTransformation
    extends ResolutionTransformation
    implements Comparable<EstimatedResolutionTransformation> {
        private static final double COMPARISON_TOLERANCE = 0.01;
        private final Estimates estimates;

        public EstimatedResolutionTransformation(Resolution from, Resolution to, Transformation transformation, Estimates estimates) {
            super(from, to, transformation);
            this.estimates = estimates;
        }

        public Estimates getEstimates() {
            return this.estimates;
        }

        private int signum(float f) {
            return (double)Math.abs(f) < 0.01 ? 0 : (int)Math.signum(f);
        }

        @Override
        public int compareTo(EstimatedResolutionTransformation another) {
            int zoomSignum = this.signum(this.getEstimates().getZoom() - another.getEstimates().getZoom());
            if (zoomSignum != 0) {
                return zoomSignum;
            }
            int cropSignum = this.signum(this.getEstimates().getCrop() - another.getEstimates().getCrop());
            if (cropSignum != 0) {
                return cropSignum;
            }
            return Integer.signum(this.getFrom().getWidth() * this.getFrom().getHeight() - another.getFrom().getWidth() * another.getFrom().getHeight());
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.estimates + ")";
        }
    }

    private static class Estimates {
        private final float zoom;
        private final float crop;

        public Estimates() {
            this.zoom = -1.0f;
            this.crop = -1.0f;
        }

        public Estimates(float zoom, float crop) throws CaptureException {
            if (zoom < 0.0f || crop < 0.0f) {
                throw new CaptureException("zoom=" + zoom + ", crop=" + crop + " must not have negative values", ErrorCode.ANDROID_CAPTURER_INVALID_ZOOM_CROP);
            }
            this.zoom = zoom;
            this.crop = crop;
        }

        public boolean isValid() {
            return this.zoom >= 0.0f && this.zoom < Float.MAX_VALUE && this.crop >= 0.0f && this.crop < Float.MAX_VALUE;
        }

        public float getZoom() {
            return this.zoom;
        }

        public float getCrop() {
            return this.crop;
        }

        public String toString() {
            return this.isValid() ? "zoom=" + (int)(this.zoom * 100.0f) + "%, crop=" + (int)(this.crop * 100.0f) + "%" : "invalid";
        }
    }

    public static class ResolutionTransformation {
        private final Resolution from;
        private final Resolution to;
        private final Transformation transformation;

        public ResolutionTransformation(Resolution from, Resolution to, Transformation transformation) {
            this.from = from;
            this.to = to;
            this.transformation = transformation;
        }

        public Resolution getFrom() {
            return this.from;
        }

        public Resolution getTo() {
            return this.to;
        }

        public Transformation getTransformation() {
            return this.transformation;
        }

        public String toString() {
            return this.from + "->" + this.to + " " + (Object)((Object)this.transformation);
        }
    }

    public static enum TransformationAllowed {
        Cropping,
        MultipleScaling,
        AllScaling;

    }

    public static enum Transformation {
        Match,
        Crop,
        Scale;

    }
}

