/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.capture.api.CameraCallback;
import com.microsoft.dl.video.capture.impl.AbstractPreviewSurface;
import com.microsoft.dl.video.graphics.GraphicsException;
import com.microsoft.dl.video.graphics.egl.EGLException;
import com.microsoft.dl.video.graphics.egl.PixelBufferSurfaceContext;
import com.microsoft.dl.video.utils.Resolution;

public class OffscreenPreviewSurface
extends AbstractPreviewSurface {
    private Resolution surfaceSize;
    private final String simpleClassName = this.getClass().getSimpleName();

    private static PixelBufferSurfaceContext createSurface() throws EGLException {
        PixelBufferSurfaceContext surface = null;
        try {
            surface = new PixelBufferSurfaceContext();
        }
        catch (EGLException e) {
            surface.close();
            throw e;
        }
        return surface;
    }

    public OffscreenPreviewSurface(CameraCallback callback) throws EGLException {
        super(callback, OffscreenPreviewSurface.createSurface());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocSurfaceTexture(Resolution surfaceSize) throws GraphicsException {
        PixelBufferSurfaceContext pixelBufferSurfaceContext = this.getSurface();
        synchronized (pixelBufferSurfaceContext) {
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)(this.simpleClassName + " requested for " + surfaceSize));
            }
            if (surfaceSize.equals(this.surfaceSize)) {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)(this.simpleClassName + " reusing existing " + this.getSurfaceTexture()));
                }
                return;
            }
            this.releaseSurfaceTexture();
            try {
                this.getSurface().allocSurface(surfaceSize, PixelBufferSurfaceContext.BufferFormat.NoBuffer);
                super.alloc();
            }
            catch (GraphicsException e) {
                this.getSurface().releaseSurface();
                throw e;
            }
            this.surfaceSize = surfaceSize;
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)(this.simpleClassName + " allocated " + surfaceSize + " size " + this.getSurfaceTexture()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSurfaceTexture() throws GraphicsException {
        PixelBufferSurfaceContext pixelBufferSurfaceContext = this.getSurface();
        synchronized (pixelBufferSurfaceContext) {
            if (this.getSurfaceTexture() == null) {
                return;
            }
            if (Log.isLoggable((String)"Video", (int)3)) {
                Log.d((String)"Video", (String)(this.simpleClassName + " releasing " + this.getSurfaceTexture()));
            }
            super.release();
            this.getSurface().releaseSurface();
            this.surfaceSize = null;
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)(this.simpleClassName + " surface texture released"));
            }
        }
    }

    @Override
    protected PixelBufferSurfaceContext getSurface() {
        return (PixelBufferSurfaceContext)super.getSurface();
    }
}

