/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.api;

import java.io.Serializable;
import java.util.regex.Pattern;

public class FpsRange
implements Comparable<FpsRange>,
Serializable {
    private static final long serialVersionUID = 3635112787662414695L;
    private static final Pattern SPLIT_REGEX = Pattern.compile("-");
    private static final int MULTIPLIER = 1000;
    private final int min;
    private final int max;

    public FpsRange(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("invalid parameters min=" + min + ", max=" + max);
        }
        this.min = min;
        this.max = max;
    }

    public FpsRange(String range) {
        String[] dimensions = SPLIT_REGEX.split(range);
        this.min = Integer.parseInt(dimensions[0]);
        this.max = Integer.parseInt(dimensions[1]);
        if (this.min > this.max) {
            throw new IllegalArgumentException("invalid parameters min=" + this.min + ", max=" + this.max);
        }
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.max;
        result = 31 * result + this.min;
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FpsRange other = (FpsRange)obj;
        return this.max == other.max && this.min == other.min;
    }

    @Override
    public final int compareTo(FpsRange another) {
        int minDiff = this.min - another.min;
        int maxDiff = this.max - another.max;
        return minDiff < 0 ? -1 : (minDiff > 0 ? 1 : (maxDiff < 0 ? -1 : (maxDiff > 0 ? 1 : 0)));
    }

    public final String toString() {
        return (float)this.min / 1000.0f + "-" + (float)this.max / 1000.0f;
    }
}

