/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.graphics.egl;

import android.util.SparseIntArray;

final class EGLUtils {
    private static final ValueParser RENDER_BUFFER_VALUE_PARSER = new EnumValueParser((Attribute[])RenderBufferAttribute.values());
    private static final ValueParser BOOLEAN_VALUE_PARSER = new EnumValueParser((Attribute[])BooleanAttribute.values());
    private static final ValueParser INT_VALUE_PARSER = new ValueParser(){

        @Override
        public String parse(int value) {
            return value == -1 ? "DONT_CARE" : Integer.toString(value);
        }
    };

    private EGLUtils() {
    }

    static /* synthetic */ ValueParser access$000() {
        return INT_VALUE_PARSER;
    }

    static /* synthetic */ ValueParser access$100() {
        return BOOLEAN_VALUE_PARSER;
    }

    static /* synthetic */ ValueParser access$200() {
        return RENDER_BUFFER_VALUE_PARSER;
    }

    private static class BitmapValueParser<T extends Attribute>
    implements ValueParser {
        private final T[] attributes;

        public BitmapValueParser(T[] attributes) {
            this.attributes = attributes;
        }

        @Override
        public String parse(int value) {
            StringBuilder str = new StringBuilder();
            for (T attr : this.attributes) {
                if ((value & attr.getCode()) <= 0) continue;
                if (str.length() > 0) {
                    str.append('|');
                }
                str.append(attr.toString());
                value &= ~attr.getCode();
            }
            if (value > 0) {
                if (str.length() > 0) {
                    str.append('|');
                }
                str.append("0x").append(Integer.toHexString(value));
            }
            return str.toString();
        }
    }

    private static class EnumValueParser<T extends Attribute>
    implements ValueParser {
        private final T[] attributes;

        public EnumValueParser(T[] attributes) {
            this.attributes = attributes;
        }

        @Override
        public String parse(int value) {
            for (T attr : this.attributes) {
                if (value != attr.getCode()) continue;
                return attr.toString();
            }
            return "0x" + Integer.toHexString(value);
        }
    }

    private static interface ValueParser {
        public String parse(int var1);
    }

    private static abstract class AbstractAttributesBuilder {
        private final SparseIntArray map = new SparseIntArray();

        private AbstractAttributesBuilder() {
        }

        protected void put(Attribute attr, int value) {
            this.map.put(attr.getCode(), value);
        }

        protected void put(Attribute attr, Attribute value) {
            this.put(attr, value.getCode());
        }

        protected void put(Attribute attr, Attribute[] values) {
            int bitmask = 0;
            for (Attribute value : values) {
                bitmask |= value.getCode();
            }
            this.put(attr, bitmask);
        }

        public int[] build() {
            int[] arr = new int[this.map.size() * 2 + 1];
            for (int i = 0; i < this.map.size(); ++i) {
                arr[i * 2] = this.map.keyAt(i);
                arr[i * 2 + 1] = this.map.valueAt(i);
            }
            arr[arr.length - 1] = 12344;
            return arr;
        }
    }

    public static class ContextAttributesBuilder
    extends AbstractAttributesBuilder {
        public ContextAttributesBuilder contextClientVersion(int value) {
            this.put((Attribute)ContextAttribute.CONTEXT_CLIENT_VERSION, value);
            return this;
        }
    }

    public static class WindowSurfaceAttributeBuilder
    extends AbstractAttributesBuilder {
        public WindowSurfaceAttributeBuilder renderBuffer(RenderBufferAttribute value) {
            this.put((Attribute)SurfaceAttribute.RENDER_BUFFER, value);
            return this;
        }

        public WindowSurfaceAttributeBuilder vgAlphaFormat(VgAlphaFormatAttribute value) {
            this.put((Attribute)SurfaceAttribute.VG_ALPHA_FORMAT, value);
            return this;
        }

        public WindowSurfaceAttributeBuilder vgColorspace(VgColorspaceAttribute value) {
            this.put((Attribute)SurfaceAttribute.VG_COLORSPACE, value);
            return this;
        }
    }

    public static class PBufferSurfaceAttributeBuilder
    extends AbstractAttributesBuilder {
        public PBufferSurfaceAttributeBuilder height(int value) {
            this.put((Attribute)SurfaceAttribute.HEIGHT, value);
            return this;
        }

        public PBufferSurfaceAttributeBuilder largestPbuffer(BooleanAttribute value) {
            this.put((Attribute)SurfaceAttribute.LARGEST_PBUFFER, value);
            return this;
        }

        public PBufferSurfaceAttributeBuilder mipmapTexture(BooleanAttribute value) {
            this.put((Attribute)SurfaceAttribute.MIPMAP_TEXTURE, value);
            return this;
        }

        public PBufferSurfaceAttributeBuilder testureFormat(TextureFormatAttribute value) {
            this.put((Attribute)SurfaceAttribute.TEXTURE_FORMAT, value);
            return this;
        }

        public PBufferSurfaceAttributeBuilder textureTarget(TextureTargetAttribute value) {
            this.put((Attribute)SurfaceAttribute.TEXTURE_TARGET, value);
            return this;
        }

        public PBufferSurfaceAttributeBuilder vgAlphaFormat(VgAlphaFormatAttribute value) {
            this.put((Attribute)SurfaceAttribute.VG_ALPHA_FORMAT, value);
            return this;
        }

        public PBufferSurfaceAttributeBuilder width(int value) {
            this.put((Attribute)SurfaceAttribute.WIDTH, value);
            return this;
        }
    }

    public static class ConfigAttributesBuilder
    extends AbstractAttributesBuilder {
        public ConfigAttributesBuilder alphaMaskSize(int value) {
            this.put((Attribute)ConfigAttribute.ALPHA_MASK_SIZE, value);
            return this;
        }

        public ConfigAttributesBuilder alphaSize(int value) {
            this.put((Attribute)ConfigAttribute.ALPHA_SIZE, value);
            return this;
        }

        public ConfigAttributesBuilder bindToTextureRgb(BooleanAttribute value) {
            this.put((Attribute)ConfigAttribute.BIND_TO_TEXTURE_RGB, value);
            return this;
        }

        public ConfigAttributesBuilder bindToTextureRgba(BooleanAttribute value) {
            this.put((Attribute)ConfigAttribute.BIND_TO_TEXTURE_RGBA, value);
            return this;
        }

        public ConfigAttributesBuilder blueSize(int value) {
            this.put((Attribute)ConfigAttribute.BLUE_SIZE, value);
            return this;
        }

        public ConfigAttributesBuilder bufferSize(int value) {
            this.put((Attribute)ConfigAttribute.BUFFER_SIZE, value);
            return this;
        }

        public ConfigAttributesBuilder colorBufferType(ColorBufferTypeAttribute value) {
            this.put((Attribute)ConfigAttribute.COLOR_BUFFER_TYPE, value);
            return this;
        }

        public ConfigAttributesBuilder configCaveat(ConfigCaveatAttribute value) {
            this.put((Attribute)ConfigAttribute.CONFIG_CAVEAT, value);
            return this;
        }

        public ConfigAttributesBuilder configId(int value) {
            this.put((Attribute)ConfigAttribute.CONFIG_ID, value);
            return this;
        }

        public ConfigAttributesBuilder conformant(ConformantAttribute value) {
            this.put((Attribute)ConfigAttribute.CONFORMANT, value);
            return this;
        }

        public ConfigAttributesBuilder depthSize(int value) {
            this.put((Attribute)ConfigAttribute.DEPTH_SIZE, value);
            return this;
        }

        public ConfigAttributesBuilder greenSize(int value) {
            this.put((Attribute)ConfigAttribute.GREEN_SIZE, value);
            return this;
        }

        public ConfigAttributesBuilder level(int value) {
            this.put((Attribute)ConfigAttribute.LEVEL, value);
            return this;
        }

        public ConfigAttributesBuilder luminanceSize(int value) {
            this.put((Attribute)ConfigAttribute.LUMINANCE_SIZE, value);
            return this;
        }

        public ConfigAttributesBuilder maxPBufferHeight(BooleanAttribute value) {
            this.put((Attribute)ConfigAttribute.MATCH_NATIVE_PIXMAP, value);
            return this;
        }

        public ConfigAttributesBuilder maxPBufferHeight(int value) {
            this.put((Attribute)ConfigAttribute.MAX_PBUFFER_HEIGHT, value);
            return this;
        }

        public ConfigAttributesBuilder maxPBufferPixels(int value) {
            this.put((Attribute)ConfigAttribute.MAX_PBUFFER_PIXELS, value);
            return this;
        }

        public ConfigAttributesBuilder maxPBufferWidth(int value) {
            this.put((Attribute)ConfigAttribute.MAX_PBUFFER_WIDTH, value);
            return this;
        }

        public ConfigAttributesBuilder maxSwapInterval(int value) {
            this.put((Attribute)ConfigAttribute.MAX_SWAP_INTERVAL, value);
            return this;
        }

        public ConfigAttributesBuilder minSwapInterval(int value) {
            this.put((Attribute)ConfigAttribute.MIN_SWAP_INTERVAL, value);
            return this;
        }

        public ConfigAttributesBuilder nativeRenderable(BooleanAttribute value) {
            this.put((Attribute)ConfigAttribute.NATIVE_RENDERABLE, value);
            return this;
        }

        public ConfigAttributesBuilder redSize(int value) {
            this.put((Attribute)ConfigAttribute.RED_SIZE, value);
            return this;
        }

        public ConfigAttributesBuilder renderableType(RenderableTypeAttribute ... values) {
            this.put((Attribute)ConfigAttribute.RENDERABLE_TYPE, values);
            return this;
        }

        public ConfigAttributesBuilder sampleBuffers(int value) {
            this.put((Attribute)ConfigAttribute.SAMPLE_BUFFERS, value);
            return this;
        }

        public ConfigAttributesBuilder samples(int value) {
            this.put((Attribute)ConfigAttribute.SAMPLES, value);
            return this;
        }

        public ConfigAttributesBuilder stencilSize(int value) {
            this.put((Attribute)ConfigAttribute.STENCIL_SIZE, value);
            return this;
        }

        public ConfigAttributesBuilder surfaceType(SurfaceTypeAttribute ... values) {
            this.put((Attribute)ConfigAttribute.SURFACE_TYPE, values);
            return this;
        }

        public ConfigAttributesBuilder transparentBlueValue(int value) {
            this.put((Attribute)ConfigAttribute.TRANSPARENT_BLUE_VALUE, value);
            return this;
        }

        public ConfigAttributesBuilder transparentGreenValue(int value) {
            this.put((Attribute)ConfigAttribute.TRANSPARENT_GREEN_VALUE, value);
            return this;
        }

        public ConfigAttributesBuilder transparentredValue(int value) {
            this.put((Attribute)ConfigAttribute.TRANSPARENT_RED_VALUE, value);
            return this;
        }

        public ConfigAttributesBuilder transparentType(TransparentTypeAttribute value) {
            this.put((Attribute)ConfigAttribute.TRANSPARENT_TYPE, value);
            return this;
        }
    }

    public static enum SurfaceAttribute implements Attribute
    {
        CONFIG_ID(12328, EGLUtils.access$000()),
        HEIGHT(12374, EGLUtils.access$000()),
        HORIZONTAL_RESOLUTION(12432, EGLUtils.access$000()),
        LARGEST_PBUFFER(12376, EGLUtils.access$100()),
        MIPMAP_LEVEL(12419, EGLUtils.access$000()),
        MIPMAP_TEXTURE(12418, EGLUtils.access$100()),
        MULTISAMPLE_RESOLVE(12441, new EnumValueParser((Attribute[])MultisampleResolveAttribute.values())),
        PIXEL_ASPECT_RATIO(12434, EGLUtils.access$000()),
        RENDER_BUFFER(12422, EGLUtils.access$200()),
        SWAP_BEHAVIOR(12435, new EnumValueParser((Attribute[])SwapBehaviorAttribute.values())),
        TEXTURE_FORMAT(12416, new EnumValueParser((Attribute[])TextureFormatAttribute.values())),
        TEXTURE_TARGET(12417, new EnumValueParser((Attribute[])TextureTargetAttribute.values())),
        VERTICAL_RESOLUTION(12433, EGLUtils.access$000()),
        VG_ALPHA_FORMAT(12424, new EnumValueParser((Attribute[])VgAlphaFormatAttribute.values())),
        VG_COLORSPACE(12423, new EnumValueParser((Attribute[])VgColorspaceAttribute.values())),
        WIDTH(12375, EGLUtils.access$000());

        private final int code;
        private final ValueParser valueParser;

        private SurfaceAttribute(int code, ValueParser valueParser) {
            this.code = code;
            this.valueParser = valueParser;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public String parseValue(int value) {
            return this.valueParser.parse(value);
        }
    }

    public static enum ContextAttribute implements Attribute
    {
        CONFIG_ID(12328, EGLUtils.access$000()),
        CONTEXT_CLIENT_TYPE(12439, new EnumValueParser((Attribute[])ClientContextTypeAttribute.values())),
        CONTEXT_CLIENT_VERSION(12440, EGLUtils.access$000()),
        RENDER_BUFFER(12422, EGLUtils.access$200());

        private final int code;
        private final ValueParser valueParser;

        private ContextAttribute(int code, ValueParser valueParser) {
            this.code = code;
            this.valueParser = valueParser;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public String parseValue(int value) {
            return this.valueParser.parse(value);
        }
    }

    public static enum ConfigAttribute implements Attribute
    {
        ALPHA_SIZE(12321, EGLUtils.access$000()),
        ALPHA_MASK_SIZE(12350, EGLUtils.access$000()),
        BIND_TO_TEXTURE_RGB(12345, EGLUtils.access$100()),
        BIND_TO_TEXTURE_RGBA(12346, EGLUtils.access$100()),
        BLUE_SIZE(12322, EGLUtils.access$000()),
        BUFFER_SIZE(12320, EGLUtils.access$000()),
        COLOR_BUFFER_TYPE(12351, new EnumValueParser((Attribute[])ColorBufferTypeAttribute.values())),
        CONFIG_CAVEAT(12327, new EnumValueParser((Attribute[])ConfigCaveatAttribute.values())),
        CONFIG_ID(12328, EGLUtils.access$000()),
        CONFORMANT(12354, new BitmapValueParser((Attribute[])ConformantAttribute.values())),
        DEPTH_SIZE(12325, EGLUtils.access$000()),
        GREEN_SIZE(12323, EGLUtils.access$000()),
        LEVEL(12329, EGLUtils.access$000()),
        LUMINANCE_SIZE(12349, EGLUtils.access$000()),
        MATCH_NATIVE_PIXMAP(12353, EGLUtils.access$100()),
        MAX_PBUFFER_WIDTH(12332, EGLUtils.access$000()),
        MAX_PBUFFER_HEIGHT(12330, EGLUtils.access$000()),
        MAX_PBUFFER_PIXELS(12331, EGLUtils.access$000()),
        MAX_SWAP_INTERVAL(12348, EGLUtils.access$000()),
        MIN_SWAP_INTERVAL(12347, EGLUtils.access$000()),
        NATIVE_RENDERABLE(12333, EGLUtils.access$100()),
        NATIVE_VISUAL_ID(12334, EGLUtils.access$000()),
        NATIVE_VISUAL_TYPE(12335, EGLUtils.access$000()),
        RED_SIZE(12324, EGLUtils.access$000()),
        RENDERABLE_TYPE(12352, new BitmapValueParser((Attribute[])RenderableTypeAttribute.values())),
        SAMPLE_BUFFERS(12338, EGLUtils.access$000()),
        SAMPLES(12337, EGLUtils.access$000()),
        STENCIL_SIZE(12326, EGLUtils.access$000()),
        SURFACE_TYPE(12339, new BitmapValueParser((Attribute[])SurfaceTypeAttribute.values())),
        TRANSPARENT_RED_VALUE(12343, EGLUtils.access$000()),
        TRANSPARENT_GREEN_VALUE(12342, EGLUtils.access$000()),
        TRANSPARENT_BLUE_VALUE(12341, EGLUtils.access$000()),
        TRANSPARENT_TYPE(12340, new EnumValueParser((Attribute[])TransparentTypeAttribute.values()));

        private final int code;
        private final ValueParser valueParser;

        private ConfigAttribute(int code, ValueParser valueParser) {
            this.code = code;
            this.valueParser = valueParser;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public String parseValue(int value) {
            return this.valueParser.parse(value);
        }
    }

    public static enum VgColorspaceAttribute implements Attribute
    {
        VG_COLORSPACE_sRGB(12425),
        VG_COLORSPACE_LINEAR(12426);

        private final int code;

        private VgColorspaceAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum VgAlphaFormatAttribute implements Attribute
    {
        VG_ALPHA_FORMAT_NONPRE(12427),
        VG_ALPHA_FORMAT_PRE(12428);

        private final int code;

        private VgAlphaFormatAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum MultisampleResolveAttribute implements Attribute
    {
        MULTISAMPLE_RESOLVE_DEFAULT(12442),
        MULTISAMPLE_RESOLVE_BOX(12443);

        private final int code;

        private MultisampleResolveAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum SwapBehaviorAttribute implements Attribute
    {
        BUFFER_PRESERVED(12436),
        BUFFER_DESTROYED(12437);

        private final int code;

        private SwapBehaviorAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum TextureFormatAttribute implements Attribute
    {
        NO_TEXTURE(12380),
        TEXTURE_2D(12383);

        private final int code;

        private TextureFormatAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum TextureTargetAttribute implements Attribute
    {
        NO_TEXTURE(12380),
        TEXTURE_RGB(12381),
        TEXTURE_RGBA(12382);

        private final int code;

        private TextureTargetAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum ConformantAttribute implements Attribute
    {
        OPENGL(8),
        OPENGL_ES(1),
        OPENGL_ES2(4),
        OPENVG(2);

        private final int code;

        private ConformantAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum ClientContextTypeAttribute implements Attribute
    {
        OPENGL(12450),
        OPENGL_ES(12448),
        OPENVG(12449);

        private final int code;

        private ClientContextTypeAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum DisplayAttribute implements Attribute
    {
        VENDOR(12371),
        VERSION(12372),
        EXTENSIONS(12373);

        private final int code;

        private DisplayAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum RenderBufferAttribute implements Attribute
    {
        NONE(12344),
        SINGLE_BUFFER(12421),
        BACK_BUFFER(12420);

        private final int code;

        private RenderBufferAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum SurfaceTypeAttribute implements Attribute
    {
        PBUFFER(1),
        PIXMAP(2),
        WINDOW(4),
        VG_COLORSPACE_LINEAR(32),
        VG_ALPHA_FORMAT_PRE(64),
        MULTISAMPLE_RESOLVE_BOX(512),
        SWAP_BEHAVIOR_PRESERVED(1024);

        private final int code;

        private SurfaceTypeAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum RenderableTypeAttribute implements Attribute
    {
        OPENGL_ES(1),
        OPENVG(2),
        OPENGL_ES2(4),
        OPENGL(8);

        private final int code;

        private RenderableTypeAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum ColorBufferTypeAttribute implements Attribute
    {
        RGB(12430),
        LUMINANCE(12431);

        private final int code;

        private ColorBufferTypeAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum ConfigCaveatAttribute implements Attribute
    {
        NONE(12344),
        DONT_CARE(-1),
        SLOW_CONFIG(12368),
        NON_CONFORMANT_CONFIG(12369);

        private final int code;

        private ConfigCaveatAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum TransparentTypeAttribute implements Attribute
    {
        NONE(12344),
        RGB(12370);

        private final int code;

        private TransparentTypeAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static enum BooleanAttribute implements Attribute
    {
        FALSE(0),
        TRUE(1),
        DONT_CARE(-1);

        private final int code;

        private BooleanAttribute(int code) {
            this.code = code;
        }

        @Override
        public int getCode() {
            return this.code;
        }
    }

    public static interface Attribute {
        public int getCode();
    }
}

