/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl2;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.Face;
import android.os.Handler;
import android.os.Looper;
import android.util.Range;
import android.view.Surface;
import com.microsoft.dl.Platform;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.Camera;
import com.microsoft.dl.video.capture.api.CameraCallback;
import com.microsoft.dl.video.capture.api.CameraCapabilities;
import com.microsoft.dl.video.capture.api.CameraManagerSingleton;
import com.microsoft.dl.video.capture.api.CameraParameters;
import com.microsoft.dl.video.capture.api.CaptureException;
import com.microsoft.dl.video.capture.api.StaticCameraCapabilities;
import com.microsoft.dl.video.capture.impl.CaptureWorker;
import java.util.Collections;
import java.util.NavigableSet;

public class RealCamera2Impl
implements Camera {
    private String m_cameraId;
    private CameraDevice m_cameraDevice = null;
    private boolean m_captureSessionClosed = true;
    private SurfaceTexture m_display = null;
    private int m_displayOrientation;
    private CameraParameters m_cameraParameters = null;
    private CaptureRequest.Builder m_captureBuilder = null;
    private Handler m_backgroundHandler = null;
    private CameraCaptureSession m_captureSession = null;
    private final Object m_cameraStateMonitor = new Object();
    private static long CAMERA_TIMEOUT_MILLIS = 5000L;
    private static long PREVIEW_TIMEOUT_MILLIS = 15000L;
    private Looper m_looper = null;
    private CaptureException m_exception = null;
    private CameraCapabilities m_capabilities = null;
    private CameraCallback m_cameraCallback = null;
    private volatile boolean m_isFaceDetectionEnabled = false;
    private volatile Matrix matrix = null;
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpened(CameraDevice cameraDevice) {
            Object object = RealCamera2Impl.this.m_cameraStateMonitor;
            synchronized (object) {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Camera: " + RealCamera2Impl.this.m_cameraId + " Opened [" + cameraDevice + "] Successfully"));
                }
                RealCamera2Impl.this.m_cameraDevice = cameraDevice;
                RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnected(CameraDevice cameraDevice) {
            Object object = RealCamera2Impl.this.m_cameraStateMonitor;
            synchronized (object) {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Camera: " + RealCamera2Impl.this.m_cameraId + " Disconnected [" + cameraDevice + "] Successfully"));
                }
                cameraDevice.close();
                RealCamera2Impl.this.m_cameraDevice = null;
                RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(CameraDevice cameraDevice, int error) {
            Object object = RealCamera2Impl.this.m_cameraStateMonitor;
            synchronized (object) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("Camera: " + RealCamera2Impl.this.m_cameraId + " failed [" + cameraDevice + "] error:" + error));
                }
                cameraDevice.close();
                RealCamera2Impl.this.m_cameraDevice = null;
                RealCamera2Impl.this.m_exception = new CaptureException("Camera failed, onError[" + error + "]", ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
                RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClosed(CameraDevice cameraDevice) {
            Object object = RealCamera2Impl.this.m_cameraStateMonitor;
            synchronized (object) {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("Camera: " + RealCamera2Impl.this.m_cameraId + " closed [" + cameraDevice.getId() + "] Successfully"));
                }
                RealCamera2Impl.this.m_cameraDevice = null;
                RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
            }
        }
    };
    private final CameraCaptureSession.CaptureCallback m_captureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            super.onCaptureCompleted(session, request, result);
            if (RealCamera2Impl.this.m_cameraCallback == null) {
                return;
            }
            Face[] faces = (Face[])result.get(CaptureResult.STATISTICS_FACES);
            Rect[] faceRects = null;
            if (faces != null && faces.length > 0) {
                faceRects = new Rect[faces.length];
                for (int i = 0; i < faces.length; ++i) {
                    faceRects[i] = faces[i].getBounds();
                }
            }
            RealCamera2Impl.this.m_cameraCallback.onFaceDetected(faceRects);
        }
    };

    public RealCamera2Impl(String cameraId) throws CaptureException {
        try {
            Context ctx;
            CameraManager cameraManager;
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Camera: " + cameraId + " RealCamera2Impl ctor."));
            }
            if ((cameraManager = (CameraManager)(ctx = Platform.getInfo().getAppContext()).getSystemService("camera")) == null) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"Failed to get CameraManager");
                }
                throw new CaptureException("android.hardware.camera2.CameraManager NULL", ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
            }
            this.m_cameraId = cameraId;
            Camera2Thread worker = new Camera2Thread(cameraManager, cameraId);
            worker.start();
            this.waitForCameraOpen(CAMERA_TIMEOUT_MILLIS);
            this.m_backgroundHandler = new Handler();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("RuntimeException: Could not open camera: " + cameraId));
            }
            throw new CaptureException("Could not open camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
        }
        catch (InterruptedException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("InterruptedException: Could not open camera: " + cameraId));
            }
            throw new CaptureException("Could not open camera " + cameraId, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCameraOpen(long timeoutMs) throws InterruptedException, CaptureException {
        Object object = this.m_cameraStateMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (this.m_cameraDevice == null) {
                if (this.m_exception != null) {
                    CaptureException m_exception = this.m_exception;
                    this.m_exception = null;
                    throw m_exception;
                }
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"camera open timed out.");
                    }
                    return false;
                }
                this.m_cameraStateMonitor.wait(waitMs);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCaptureSessionClose(long timeoutMs) throws InterruptedException, CaptureException {
        Object object = this.m_cameraStateMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (!this.m_captureSessionClosed) {
                if (this.m_exception != null) {
                    CaptureException m_exception = this.m_exception;
                    this.m_exception = null;
                    throw m_exception;
                }
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"CaptureSessionClose timed out.");
                    }
                    return false;
                }
                this.m_cameraStateMonitor.wait(waitMs);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCameraClose(long timeoutMs) throws InterruptedException, CaptureException {
        Object object = this.m_cameraStateMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (this.m_cameraDevice != null) {
                if (this.m_exception != null) {
                    CaptureException m_exception = this.m_exception;
                    this.m_exception = null;
                    throw m_exception;
                }
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable((String)"Video", (int)6)) {
                        Log.e((String)"Video", (String)"camera close timed out.");
                    }
                    return false;
                }
                this.m_cameraStateMonitor.wait(waitMs);
            }
            return true;
        }
    }

    @Override
    public final void close() throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Camera: " + this.m_cameraId + " [" + this.m_cameraDevice + "] closing"));
        }
        if (this.m_cameraDevice != null) {
            try {
                this.m_cameraDevice.close();
                this.m_captureSessionClosed = true;
                this.m_captureSession = null;
                this.waitForCameraClose(CAMERA_TIMEOUT_MILLIS);
                this.m_cameraDevice = null;
                if (this.m_looper != null) {
                    this.m_looper.quit();
                }
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("RuntimeException: Could not close camera: " + this.m_cameraId));
                }
                throw new CaptureException("Could not close camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_CLOSE_FAILED);
            }
            catch (InterruptedException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("InterruptedException: Could not close camera: " + this.m_cameraId));
                }
                throw new CaptureException("Could not close camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_CLOSE_FAILED);
            }
        }
    }

    @Override
    public final CameraParameters getParameters() throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Camera: " + this.m_cameraId + " having parameters as [" + this.m_cameraParameters + "]"));
        }
        return this.m_cameraParameters;
    }

    @Override
    public final void setParameters(CameraParameters parameters) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting parameters [" + parameters + "] to the camera: " + this.m_cameraId));
        }
        this.m_cameraParameters = parameters;
    }

    @Override
    public final void setFlashTorchMode(boolean torchTurnOn) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting flash mode [" + torchTurnOn + "] to the camera: " + this.m_cameraId));
        }
        try {
            if (this.m_captureSession == null || this.m_captureBuilder == null) {
                throw new CaptureException("Could not set flash torch mode [" + torchTurnOn + "] on null capture", ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
            }
            this.m_captureBuilder.set(CaptureRequest.FLASH_MODE, (Object)(torchTurnOn ? 2 : 0));
            this.m_captureSession.setRepeatingRequest(this.m_captureBuilder.build(), null, null);
            this.m_cameraParameters.setFlashTorchMode(torchTurnOn);
        }
        catch (CameraAccessException e) {
            throw new CaptureException("Could not set flash torch mode [" + torchTurnOn + "] on the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_RUNTIME_FAILURE);
        }
    }

    @Override
    public final void setPreviewDisplay(Object display) throws CaptureException {
        block7: {
            try {
                if (display == null) {
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)("Setting NULL PreviewDisplay to the camera: " + this.m_cameraId));
                    }
                    this.m_display = null;
                    break block7;
                }
                if (display instanceof SurfaceTexture) {
                    if (Log.isLoggable((String)"Video", (int)4)) {
                        Log.i((String)"Video", (String)("Setting SurfaceTexture [" + display + "] as PreviewDisplay to the camera: " + this.m_cameraId));
                    }
                    this.m_display = (SurfaceTexture)display;
                    break block7;
                }
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("Setting unsupported [" + display.getClass().getCanonicalName() + "] as PreviewDisplay to the camera: " + this.m_cameraId));
                }
                this.m_display = null;
                throw new CaptureException(display.getClass().getCanonicalName() + " is not supported", ErrorCode.ANDROID_CAMERA_UNSUPPORTED_PREVIEW_DISPLAY);
            }
            catch (RuntimeException e) {
                throw new CaptureException("Could not set preview display [" + display + "] for the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_SET_PREVIEW_DISPLAY_FAILED);
            }
        }
    }

    @Override
    public final void setDisplayOrientation(int degrees) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Setting Display Orientation [" + degrees + "] to the camera: " + this.m_cameraId));
        }
        this.m_displayOrientation = degrees;
        if (this.m_isFaceDetectionEnabled) {
            this.initFaceMatrix();
        }
    }

    @Override
    public final void addCallbackBuffer(byte[] callbackBuffer) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)"Setting callback buffer");
        }
    }

    @Override
    public final void setCallback(CameraCallback cb, boolean usingBufferMode) throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)"Setting callback");
        }
        this.m_cameraCallback = cb;
    }

    @Override
    public final void startPreview() throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("starting preview [" + this.m_display + "] to the camera: " + this.m_cameraId + " [" + this.m_cameraDevice + "]"));
        }
        if (this.m_cameraDevice != null) {
            try {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("setting Default buffer size: width[" + this.m_cameraParameters.getResolution().getWidth() + "], height[:" + this.m_cameraParameters.getResolution().getHeight()));
                }
                this.m_display.setDefaultBufferSize(this.m_cameraParameters.getResolution().getWidth(), this.m_cameraParameters.getResolution().getHeight());
                final Surface previewSurface = new Surface(this.m_display);
                this.m_cameraDevice.createCaptureSession(Collections.singletonList(previewSurface), new CameraCaptureSession.StateCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onConfigured(CameraCaptureSession session) {
                        Object object = RealCamera2Impl.this.m_cameraStateMonitor;
                        synchronized (object) {
                            if (Log.isLoggable((String)"Video", (int)4)) {
                                Log.i((String)"Video", (String)("capture session[" + session + "] configure succeed"));
                            }
                            RealCamera2Impl.this.m_captureSessionClosed = false;
                            RealCamera2Impl.this.m_captureSession = session;
                            RealCamera2Impl.this.updatePreview(previewSurface);
                            RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
                        }
                    }

                    public void onConfigureFailed(CameraCaptureSession session) {
                        if (Log.isLoggable((String)"Video", (int)4)) {
                            Log.i((String)"Video", (String)("capture session[" + session + "] configure failed"));
                        }
                        session.close();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClosed(CameraCaptureSession session) {
                        Object object = RealCamera2Impl.this.m_cameraStateMonitor;
                        synchronized (object) {
                            if (Log.isLoggable((String)"Video", (int)4)) {
                                Log.i((String)"Video", (String)("capture session[" + session + "] closed"));
                            }
                            RealCamera2Impl.this.m_captureSessionClosed = true;
                            RealCamera2Impl.this.m_cameraStateMonitor.notifyAll();
                        }
                    }

                    public void onReady(CameraCaptureSession session) {
                        if (Log.isLoggable((String)"Video", (int)4)) {
                            Log.i((String)"Video", (String)("capture session[" + session + "] Ready"));
                        }
                    }
                }, this.m_backgroundHandler);
            }
            catch (CameraAccessException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"start preview failed with CameraAccessException");
                }
                throw new CaptureException("CameraAccessException, Could not start preview from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_START_PREVIEW_FAILED);
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)"start preview failed with RuntimeException");
                }
                throw new CaptureException("Could not start preview from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_START_PREVIEW_FAILED);
            }
        } else {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Start preview without camera opened");
            }
            throw new CaptureException("Could not start preview without camera " + this.m_cameraId, ErrorCode.ANDROID_CAMERA_START_PREVIEW_FAILED);
        }
    }

    private void updatePreview(Surface previewSurface) {
        block9: {
            try {
                this.m_captureBuilder = this.m_cameraDevice.createCaptureRequest(1);
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)("setting CONTROL_AE_TARGET_FPS_RANGE, min:" + this.m_cameraParameters.getFpsRange().getMin() / 1000 + " max:" + this.m_cameraParameters.getFpsRange().getMax() / 1000));
                }
                this.m_captureBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(this.m_cameraParameters.getFpsRange().getMin() / 1000), (Comparable)Integer.valueOf(this.m_cameraParameters.getFpsRange().getMax() / 1000)));
                this.m_captureBuilder.addTarget(previewSurface);
                this.updateRepeatingRequest(this.m_isFaceDetectionEnabled);
            }
            catch (CameraAccessException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("CameraAccessException: for setRepeatingRequest [" + this.m_captureSession + "], reason[" + e.getReason() + "]"));
                }
            }
            catch (IllegalStateException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("IllegalStateException : for setRepeatingRequest [" + this.m_captureSession + "]"));
                }
            }
            catch (IllegalArgumentException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("IllegalArgumentException : for setRepeatingRequest [" + this.m_captureSession + "]"));
                }
            }
            catch (CaptureException e) {
                if (!Log.isLoggable((String)"Video", (int)6)) break block9;
                Log.e((String)"Video", (String)("CaptureException : for startFaceDetectionRepeatingRequest [" + this.m_captureSession + "]"));
            }
        }
    }

    @Override
    public final void stopPreview() throws CaptureException {
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("stopping preview session [" + this.m_captureSession + "]"));
        }
        try {
            if (this.m_captureSession != null) {
                this.m_captureSession.stopRepeating();
                this.m_captureSession.abortCaptures();
                this.m_captureSession.close();
                this.waitForCaptureSessionClose(PREVIEW_TIMEOUT_MILLIS);
                this.m_captureSessionClosed = true;
                this.m_captureSession = null;
            }
        }
        catch (RuntimeException e) {
            throw new CaptureException("Could not stop preview from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_STOP_PREVIEW_FAILED);
        }
        catch (CameraAccessException e) {
            throw new CaptureException("CameraAccessException for abortCaptures from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_STOP_PREVIEW_FAILED);
        }
        catch (InterruptedException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("InterruptedException: Could not close capture session: " + this.m_captureSession));
            }
            throw new CaptureException("InterruptedException for capture session from the camera " + this.m_cameraId, e, ErrorCode.ANDROID_CAMERA_STOP_PREVIEW_FAILED);
        }
    }

    @Override
    public void enableFaceDetection(boolean enableFaceDetection) throws CaptureException {
        if (enableFaceDetection == this.m_isFaceDetectionEnabled) {
            if (Log.isLoggable((String)"Video", (int)5)) {
                Log.w((String)"Video", (String)("Camera already under m_isFaceDetectionEnabled = " + enableFaceDetection + " status!"));
            }
            return;
        }
        if (enableFaceDetection) {
            this.initFaceMatrix();
        }
        if (this.m_captureSession != null && this.m_captureBuilder != null) {
            this.updateRepeatingRequest(enableFaceDetection);
        } else if (Log.isLoggable((String)"Video", (int)5)) {
            Log.w((String)"Video", (String)("EnableFaceDetection with status " + enableFaceDetection + " but camera not started preview!"));
        }
        this.m_isFaceDetectionEnabled = enableFaceDetection;
    }

    @Override
    public final Matrix getFaceTransferMatrix() {
        return this.matrix;
    }

    private void updateRepeatingRequest(boolean enableFaceDetection) throws CaptureException {
        try {
            if (enableFaceDetection) {
                this.m_captureBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)this.getFaceDetectMode());
                this.m_captureSession.setRepeatingRequest(this.m_captureBuilder.build(), this.m_captureCallback, null);
            } else {
                this.m_captureBuilder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
                this.m_captureSession.setRepeatingRequest(this.m_captureBuilder.build(), null, null);
            }
        }
        catch (CameraAccessException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("CameraAccessException: for setRepeatingRequest [" + this.m_captureSession + "], reason[" + e.getReason() + "]"));
            }
            throw new CaptureException("StartFaceDetectionRepeatingRequest failed, CameraAccessException", ErrorCode.ANDROID_CAMERA_START_REPEAT_REQUEST_FAILED);
        }
        catch (IllegalStateException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("IllegalStateException : for setRepeatingRequest [" + this.m_captureSession + "]"));
            }
            throw new CaptureException("StartFaceDetectionRepeatingRequest failed, IllegalStateException", ErrorCode.ANDROID_CAMERA_START_REPEAT_REQUEST_FAILED);
        }
        catch (IllegalArgumentException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)("IllegalArgumentException : for setRepeatingRequest [" + this.m_captureSession + "]"));
            }
            throw new CaptureException("StartFaceDetectionRepeatingRequest failed, IllegalArgumentException", ErrorCode.ANDROID_CAMERA_START_REPEAT_REQUEST_FAILED);
        }
    }

    private void initFaceMatrix() throws CaptureException {
        StaticCameraCapabilities cameraCapabilities = CameraManagerSingleton.getInstance().getStaticCameraCapabilities(this.m_cameraId);
        if (cameraCapabilities == null) {
            return;
        }
        Rect arraySize = cameraCapabilities.getCameraArraySize().toRect();
        if (arraySize == null) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Got empty camera2 array size");
            }
            return;
        }
        this.matrix = new Matrix();
        int cameraOrientation = 360 - cameraCapabilities.getOrientation();
        float arraySizeWidth = arraySize.width();
        float arraySizeHeight = arraySize.height();
        boolean isFrontCamera = cameraCapabilities.getFacing().ordinal() == CameraCapabilities.Facing.FRONT.ordinal();
        float scaleX = 1.0f / arraySizeWidth;
        float scaleY = 1.0f / arraySizeHeight;
        int surfaceOrientation = CaptureWorker.displayOrientationToSurfaceOrientation(this.m_displayOrientation);
        int cameraOrinetationMask = cameraOrientation / 90 & 1;
        if (cameraOrinetationMask == 1) {
            this.matrix.setTranslate(-arraySizeWidth / 2.0f, -arraySizeHeight / 2.0f);
        } else {
            this.matrix.setTranslate(-arraySizeHeight / 2.0f, -arraySizeWidth / 2.0f);
        }
        int finalAngle = isFrontCamera ? cameraOrientation + surfaceOrientation * 90 : cameraOrientation - surfaceOrientation * 90;
        this.matrix.postRotate((float)finalAngle);
        if ((surfaceOrientation & 1) != cameraOrinetationMask) {
            this.matrix.postTranslate(arraySizeHeight / 2.0f, arraySizeWidth / 2.0f);
            this.matrix.postScale(scaleY, scaleX);
        } else {
            this.matrix.postTranslate(arraySizeWidth / 2.0f, arraySizeHeight / 2.0f);
            this.matrix.postScale(scaleX, scaleY);
        }
        if (Log.isLoggable((String)"Video", (int)4)) {
            Log.i((String)"Video", (String)("Camera2 face matrix config { isFrontCamera: " + isFrontCamera + ", camera orientation: " + cameraOrientation + ", displayOrientation: " + this.m_displayOrientation + ", arraySizeWidth: " + arraySizeWidth + ", arraySizeHeight: " + arraySizeHeight + " }"));
        }
    }

    private int getFaceDetectMode() throws CaptureException {
        NavigableSet<Integer> faceDetectMode;
        if (this.m_capabilities == null) {
            this.m_capabilities = CameraManagerSingleton.getInstance().getCameraCapabilities(this.m_cameraId);
        }
        if (this.m_capabilities != null && (faceDetectMode = this.m_capabilities.getSupportedFaceDetectModes()) != null && faceDetectMode.size() > 0) {
            if (faceDetectMode.contains(1)) {
                return 1;
            }
            return (Integer)faceDetectMode.last();
        }
        if (Log.isLoggable((String)"Video", (int)6)) {
            Log.e((String)"Video", (String)"Face detection supported, but no visible detection mode.");
        }
        return 0;
    }

    private class Camera2Thread
    extends Thread {
        String cameraIdStr;
        CameraManager cameraManager;

        public Camera2Thread(CameraManager cameraManager, String cameraIdStr) {
            if (Log.isLoggable((String)"Video", (int)4)) {
                Log.i((String)"Video", (String)("Camera2Thread: cameraIdStr:" + cameraIdStr + " cameraManager:" + cameraManager));
            }
            this.cameraManager = cameraManager;
            this.cameraIdStr = cameraIdStr;
        }

        @Override
        public void run() {
            try {
                if (Log.isLoggable((String)"Video", (int)4)) {
                    Log.i((String)"Video", (String)"Starting Camera2Thread instance");
                }
                Looper.prepare();
                this.cameraManager.openCamera(this.cameraIdStr, RealCamera2Impl.this.mStateCallback, null);
                RealCamera2Impl.this.m_looper = Looper.myLooper();
                Looper.loop();
            }
            catch (CameraAccessException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("CameraAccessException[" + (Object)((Object)e) + "],  Could not open camera: " + this.cameraIdStr));
                }
                RealCamera2Impl.this.m_exception = new CaptureException("Could not open camera " + this.cameraIdStr, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)"Video", (int)6)) {
                    Log.e((String)"Video", (String)("Exception[" + e + "], caught (" + this.cameraIdStr + ")"));
                }
                RealCamera2Impl.this.m_exception = new CaptureException("Could not open camera " + this.cameraIdStr, e, ErrorCode.ANDROID_CAMERA_OPEN_FAILED);
            }
        }
    }
}

