/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl;

import com.microsoft.dl.video.capture.api.FpsRange;
import java.util.Comparator;

public class FpsRangeComparator
implements Comparator<FpsRange> {
    private static final int LEFT_IS_BETTER = -1;
    private static final int NO_DIFFERENCE = 0;
    private static final int RIGHT_IS_BETTER = 1;
    private final int targetFps;

    public FpsRangeComparator(int targetFps) {
        this.targetFps = targetFps;
    }

    @Override
    public int compare(FpsRange left, FpsRange right) {
        int rightDiff;
        int leftDiff;
        boolean isInRightRange;
        int leftDiffMin = this.targetFps - left.getMin();
        int leftDiffMax = left.getMax() - this.targetFps;
        int rightDiffMin = this.targetFps - right.getMin();
        int rightDiffMax = right.getMax() - this.targetFps;
        boolean isInLeftRange = leftDiffMin >= 0 && leftDiffMax >= 0;
        boolean bl = isInRightRange = rightDiffMin >= 0 && rightDiffMax >= 0;
        if (isInLeftRange && !isInRightRange) {
            return -1;
        }
        if (!isInLeftRange && isInRightRange) {
            return 1;
        }
        if (isInLeftRange && isInRightRange) {
            return leftDiffMin > rightDiffMin ? -1 : (leftDiffMin < rightDiffMin ? 1 : (leftDiffMax < rightDiffMax ? -1 : (leftDiffMax > rightDiffMax ? 1 : 0)));
        }
        int n = leftDiffMin < 0 ? leftDiffMin : (leftDiff = leftDiffMax < 0 ? -leftDiffMax : 0);
        int n2 = rightDiffMin < 0 ? rightDiffMin : (rightDiff = rightDiffMax < 0 ? -rightDiffMax : 0);
        if (leftDiff == 0 || rightDiff == 0) {
            throw new AssertionError((Object)("leftDiff=" + leftDiff + ", rightDiff=" + rightDiff + ", targetFps=" + this.targetFps + ", left=" + left + ", right=" + right));
        }
        if (leftDiff < 0 && rightDiff > 0) {
            return -1;
        }
        if (leftDiff > 0 && rightDiff < 0) {
            return 1;
        }
        if (leftDiff < 0 && rightDiff < 0) {
            return leftDiffMin > rightDiffMin ? -1 : (leftDiffMin < rightDiffMin ? 1 : (leftDiffMax < rightDiffMax ? -1 : (leftDiffMax > rightDiffMax ? 1 : 0)));
        }
        return leftDiffMax > rightDiffMax ? -1 : (leftDiffMax < rightDiffMax ? 1 : (leftDiffMin > rightDiffMin ? -1 : (leftDiffMin < rightDiffMin ? 1 : 0)));
    }
}

