/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.impl;

import android.graphics.SurfaceTexture;
import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.api.CameraCallback;
import com.microsoft.dl.video.graphics.GraphicsException;
import com.microsoft.dl.video.graphics.egl.EGLException;
import com.microsoft.dl.video.graphics.egl.TargetSurfaceContext;
import com.microsoft.dl.video.graphics.gles.GLTexture;

public abstract class AbstractPreviewSurface {
    private final CameraCallback callback;
    private final TargetSurfaceContext surface;
    private GLTexture texture;
    private SurfaceTexture surfaceTexture;

    public AbstractPreviewSurface(CameraCallback callback, TargetSurfaceContext surface) throws EGLException {
        this.callback = callback;
        this.surface = surface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws EGLException {
        TargetSurfaceContext targetSurfaceContext = this.surface;
        synchronized (targetSurfaceContext) {
            this.release();
            this.surface.close();
        }
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    protected TargetSurfaceContext getSurface() {
        return this.surface;
    }

    protected void alloc() throws GraphicsException {
        try {
            try {
                this.surface.makeCurrent(true);
                this.texture = new GLTexture(GLTexture.Target.TEXTURE_EXTERNAL_OES);
                this.surfaceTexture = new DummyPreviewSurfaceTexture(this.texture.getName());
                this.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)new OnFrameAvailableListener(this, this.callback, this.surface, this.texture));
            }
            finally {
                this.surface.makeCurrent(false);
            }
        }
        catch (GraphicsException e) {
            this.release();
            throw e;
        }
    }

    protected void release() {
        if (this.surfaceTexture != null) {
            this.surfaceTexture.release();
            this.surfaceTexture = null;
        }
        if (this.texture != null) {
            this.texture.close();
            this.texture = null;
        }
    }

    private static final class DummyPreviewSurfaceTexture
    extends SurfaceTexture {
        public DummyPreviewSurfaceTexture(int texName) {
            super(texName);
        }
    }

    private static class OnFrameAvailableListener
    implements SurfaceTexture.OnFrameAvailableListener {
        private final AbstractPreviewSurface previewSurface;
        private final CameraCallback callback;
        private final TargetSurfaceContext surface;
        private final GLTexture texture;

        public OnFrameAvailableListener(AbstractPreviewSurface previewSurface, CameraCallback callback, TargetSurfaceContext surface, GLTexture texture) {
            this.previewSurface = previewSurface;
            this.callback = callback;
            this.surface = surface;
            this.texture = texture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            try {
                if (Log.isLoggable((String)"Video", (int)3)) {
                    Log.d((String)"Video", (String)("Got a frame at " + surfaceTexture));
                }
                TargetSurfaceContext targetSurfaceContext = this.surface;
                synchronized (targetSurfaceContext) {
                    if (this.previewSurface.surfaceTexture == null) {
                        this.callback.onGpuFrameDropped();
                        return;
                    }
                    this.surface.makeCurrent(true);
                    surfaceTexture.updateTexImage();
                    this.callback.onGpuFrameCaptured(this.texture.getTarget().getCode(), this.texture.getName());
                    try {
                        this.surface.swapBuffers();
                    }
                    finally {
                        this.surface.makeCurrent(false);
                    }
                }
            }
            catch (GraphicsException e) {
                this.callback.onError(e);
            }
            catch (RuntimeException e) {
                this.callback.onError(new EGLException(e, ErrorCode.ANDROID_EGL_RUNTIME_FAILURE));
            }
        }
    }
}

