/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture.api;

import com.microsoft.dl.video.ErrorCode;
import com.microsoft.dl.video.capture.DeviceManager;
import com.microsoft.dl.video.capture.api.CameraManager;
import com.microsoft.dl.video.capture.api.CameraManagerFactory;
import com.microsoft.dl.video.capture.api.CaptureException;
import java.io.IOException;

public final class CameraManagerSingleton {
    private static CameraManager instance;
    private static CameraManagerFactory factory;

    private CameraManagerSingleton() {
    }

    public static synchronized void setFactory(CameraManagerFactory fctry) {
        if (instance != null) {
            try {
                instance.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            instance = null;
        }
        DeviceManager.reset();
        factory = fctry;
    }

    public static synchronized CameraManager getInstance() throws CaptureException {
        if (instance == null) {
            if (factory == null) {
                throw new CaptureException("CameraManagerFactory is not set", ErrorCode.ANDROID_CAMERA_MANAGER_NOT_SET);
            }
            instance = factory.createCameraManager();
        }
        return instance;
    }
}

