/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture;

import android.util.Log;
import com.microsoft.dl.video.capture.api.FpsRange;
import com.microsoft.dl.video.capture.api.ImageFormat;
import com.microsoft.dl.video.capture.impl.ResolutionMatcher;
import java.util.Collection;
import java.util.EnumSet;

public class CapturerMode {
    private final ResolutionMatcher.ResolutionTransformation resolutionTransformation;
    private final ImageFormat format;
    private final EnumSet<Orientation> orientation;
    private final Collection<FpsRange> frameRateRanges;
    private final FpsRange absFrameRateRange;

    public CapturerMode(ResolutionMatcher.ResolutionTransformation resolutionTransformation, ImageFormat format, EnumSet<Orientation> orientation, Collection<FpsRange> frameRateRanges, FpsRange absFrameRateRange) {
        this.resolutionTransformation = resolutionTransformation;
        this.format = format;
        this.orientation = orientation;
        this.frameRateRanges = frameRateRanges;
        this.absFrameRateRange = absFrameRateRange;
    }

    public final int getInnerWidth() {
        try {
            return this.resolutionTransformation.getFrom().getWidth();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public final int getInnerHeight() {
        try {
            return this.resolutionTransformation.getFrom().getHeight();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public final int getOuterWidth() {
        try {
            return this.resolutionTransformation.getTo().getWidth();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public final int getOuterHeight() {
        try {
            return this.resolutionTransformation.getTo().getHeight();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public final int getTransformation() {
        try {
            return this.resolutionTransformation.getTransformation().ordinal();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return -1;
        }
    }

    public final int getFourCC() {
        try {
            return this.format.getFourCC();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public final boolean isFlippedHorizontally() {
        try {
            return this.orientation.contains((Object)Orientation.FlippedHorizontally);
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return false;
        }
    }

    public final boolean isFlippedVertically() {
        try {
            return this.orientation.contains((Object)Orientation.FlippedVertically);
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return false;
        }
    }

    public final boolean isTransposed() {
        try {
            return this.orientation.contains((Object)Orientation.Transposed);
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return false;
        }
    }

    public final int getMinFrameRate() {
        try {
            return this.absFrameRateRange.getMin();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public final int getMaxFrameRate() {
        try {
            return this.absFrameRateRange.getMax();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public final int getBufferSize() {
        try {
            return this.format.getSampleSize(this.resolutionTransformation.getFrom());
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return 0;
        }
    }

    public final ResolutionMatcher.ResolutionTransformation getResolutionTransformation() {
        return this.resolutionTransformation;
    }

    public final ImageFormat getFormat() {
        return this.format;
    }

    public final EnumSet<Orientation> getOrientation() {
        return this.orientation;
    }

    public final Collection<FpsRange> getFrameRateRanges() {
        return this.frameRateRanges;
    }

    public final String toString() {
        return this.resolutionTransformation + ", " + (Object)((Object)this.format) + ", " + this.orientation + ", " + this.absFrameRateRange + " fps " + (this.absFrameRateRange.equals(this.frameRateRanges) ? "" : this.frameRateRanges);
    }

    public static enum Orientation {
        FlippedHorizontally,
        FlippedVertically,
        Transposed;

    }
}

