/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.dl.video.capture;

import com.microsoft.dl.utils.Log;
import com.microsoft.dl.video.capture.api.FpsRange;
import com.microsoft.dl.video.utils.Resolution;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class CapturerConfiguration {
    private FpsRange absFpsRange;
    private int maxTransformationZoom;
    private int maxTransformationCrop;
    private int numBuffers;
    private boolean useDummyPreviewSurface;
    private boolean isCamera2;
    private int faceDataKeepThresholdInMs;
    private final Set<Resolution> bannedCameraResolution = new HashSet<Resolution>();
    private final NavigableMap<Resolution, ResolutionParameters> outputRresolutions = new TreeMap<Resolution, ResolutionParameters>();
    private final Set<TransformationOptions> transformationOptions = new HashSet<TransformationOptions>();
    private final String simpleClassName = this.getClass().getSimpleName();

    public final void setAbsFpsRange(int min, int max) {
        block2: {
            try {
                this.absFpsRange = new FpsRange(min, max);
            }
            catch (RuntimeException e) {
                if (!Log.isLoggable((String)"Video", (int)6)) break block2;
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
        }
    }

    public final void setMaxTransformationZoom(int maxTransformationZoom) {
        this.maxTransformationZoom = maxTransformationZoom;
    }

    public final void setMaxTransformationCrop(int maxTransformationCrop) {
        this.maxTransformationCrop = maxTransformationCrop;
    }

    public final void setNumBuffers(int numBuffers) {
        this.numBuffers = numBuffers;
    }

    public final void setUseDummyPreviewSurface(boolean useDummyPreviewSurface) {
        this.useDummyPreviewSurface = useDummyPreviewSurface;
    }

    public final void setCamera2(boolean isCamera2) {
        this.isCamera2 = isCamera2;
    }

    public final void setFaceDataKeepThresholdInMs(int faceDataKeepThresholdInMs) {
        this.faceDataKeepThresholdInMs = faceDataKeepThresholdInMs;
    }

    public final boolean addOutputResolution(int width, int height, boolean isMandatory) {
        try {
            this.outputRresolutions.put(new Resolution(width, height), new ResolutionParameters(isMandatory));
            return true;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return false;
        }
    }

    public final boolean banCameraResolution(int width, int height) {
        try {
            this.bannedCameraResolution.add(new Resolution(width, height));
            return true;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return false;
        }
    }

    public final boolean addTransformationOption(int option) {
        try {
            this.transformationOptions.add(TransformationOptions.values()[option]);
            return true;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)"Video", (int)6)) {
                Log.e((String)"Video", (String)"Exception caught", (Throwable)e);
            }
            return false;
        }
    }

    public final FpsRange getAbsFpsRange() {
        return this.absFpsRange;
    }

    public final int getMaxTransformationZoom() {
        return this.maxTransformationZoom;
    }

    public final int getMaxTransformationCrop() {
        return this.maxTransformationCrop;
    }

    public final int getNumBuffers() {
        return this.numBuffers;
    }

    public final boolean isUseDummyPreviewSurface() {
        return this.useDummyPreviewSurface;
    }

    public final boolean isCamera2() {
        return this.isCamera2;
    }

    public final Iterable<Map.Entry<Resolution, ResolutionParameters>> getOutputResolutions() {
        return this.outputRresolutions.entrySet();
    }

    public final Set<Resolution> getBannedCameraResolution() {
        return this.bannedCameraResolution;
    }

    public final Set<TransformationOptions> getTransformationOptions() {
        return this.transformationOptions;
    }

    public final int getFaceDataKeepThresholdInMs() {
        return this.faceDataKeepThresholdInMs;
    }

    public final String toString() {
        return this.simpleClassName + " [absFpsRange=" + this.absFpsRange + ", maxTransformationZoom=" + this.maxTransformationZoom + ", maxTransformationCrop=" + this.maxTransformationCrop + ", outputRresolutions=" + this.outputRresolutions + ", numBuffers=" + this.numBuffers + ", bannedCameraResolution=" + this.bannedCameraResolution + ", transformationOptions=" + this.transformationOptions + ", useDummyPreviewSurface=" + this.useDummyPreviewSurface + ", isCamera2=" + this.isCamera2 + ", faceDataKeepThresholdInMs=" + this.faceDataKeepThresholdInMs + "]";
    }

    public static class ResolutionParameters {
        private final boolean isMandatory;

        public ResolutionParameters(boolean isMandatory) {
            this.isMandatory = isMandatory;
        }

        public final boolean isMandatory() {
            return this.isMandatory;
        }

        public final String toString() {
            return this.isMandatory ? "mandatory" : "optional";
        }
    }

    static enum TransformationOptions {
        AllowCroppingMandatoryResolutions,
        AllowMultipleScalingMandatoryResolutions,
        AllowScalingMandatoryResolutions,
        AllowCroppingAnyResolution,
        AllowMultipleScalingAnyResolution,
        AllowScalingAnyResolution;

    }
}

