/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.TextureView;
import com.skype.android.util2.Log;
import com.skype.android.video.render.EGL10RenderSurface;
import com.skype.android.video.render.EGLRenderSurface;
import com.skype.android.video.render.SurfaceTextureRenderer;

public class GLTextureView
extends TextureView
implements TextureView.SurfaceTextureListener,
Handler.Callback {
    private static final int MSG_RENDER = 1;
    private static final int MSG_TEXTURE_AVAILABLE = 2;
    private static final int MSG_TEXTURE_SIZE_CHANGED = 3;
    private static final int MSG_TEXTURE_DESTROYED = 4;
    private static final int MSG_SET_RENDERER = 5;
    private static final int MSG_STOP_THREAD = 6;
    private static final int MSG_RENDERING_WILL_START = 7;
    private static final int TIMEOUT_SURFACETEXTURE_MONITOR = 20000;
    private final String TAG;
    private HandlerThread thread;
    private Handler handler;
    private boolean isHandlerThreadShared;
    private boolean doReleaseSurfaceThread;
    private volatile boolean isRunning;
    private final Object stoppedEvent = new Object();
    private final SurfaceTextureAvailableListener listener;
    private boolean isTextureDecoder = false;
    private final Object surfaceTextureMonitor = new Object();
    private SurfaceTexture _surfaceTexture;
    private EGLRenderSurface _surface;
    private SurfaceTextureRenderer _renderer;
    private int _width;
    private int _height;
    private boolean _canReceiveFrames;
    private boolean _appliedVisibility;
    private final String simpleClassName = ((Object)((Object)this)).getClass().getSimpleName();

    public GLTextureView(Context context, Looper looper, boolean isHandlerThreadShared, SurfaceTextureAvailableListener listener) {
        super(context);
        this.TAG = "" + System.identityHashCode((Object)this);
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, "ctor using internal thread " + (looper == null) + " isHandlerThreadShared " + isHandlerThreadShared);
        }
        if (looper == null) {
            this.thread = new HandlerThread("GLTextureView");
            this.thread.start();
            looper = this.thread.getLooper();
        }
        this.handler = new Handler(looper, (Handler.Callback)this);
        this.isHandlerThreadShared = isHandlerThreadShared;
        this.listener = listener;
        this.setSurfaceTextureListener(this);
        this.doReleaseSurfaceThread = true;
    }

    public GLTextureView(Context context) {
        this(context, null, false, null);
    }

    public void dispose() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, "dispose");
        }
        this.setSurfaceTextureListener(null);
        if (this.handler != null && this.thread != null) {
            this.handler.sendEmptyMessage(6);
        }
        this.handler = null;
    }

    private String stateStr() {
        return " _canReceiveFrames " + this._canReceiveFrames + " _appliedVisibility " + this._appliedVisibility + " _renderer " + System.identityHashCode(this._renderer) + " _surface " + System.identityHashCode(this._surface) + " _surfaceTexture " + System.identityHashCode(this._surfaceTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 2: {
                if (Log.isLoggable(this.TAG, 3)) {
                    Log.d(this.TAG, "handleMessage: MSG_TEXTURE_AVAILABLE enter surfaceTexture " + System.identityHashCode(msg.obj) + " width " + msg.arg1 + " height " + msg.arg2 + this.stateStr());
                }
                Object object = this.surfaceTextureMonitor;
                synchronized (object) {
                    this._surfaceTexture = (SurfaceTexture)msg.obj;
                    this.surfaceTextureMonitor.notifyAll();
                }
                this._width = msg.arg1;
                this._height = msg.arg2;
                if (this._renderer != null) {
                    this._createSurface();
                    this._attach();
                    this._tryUpdateVisibility(true);
                }
                if (!Log.isLoggable(this.TAG, 3)) break;
                Log.d(this.TAG, "handleMessage: MSG_TEXTURE_AVAILABLE exit" + this.stateStr());
                break;
            }
            case 3: {
                if (Log.isLoggable(this.TAG, 3)) {
                    Log.d(this.TAG, "handleMessage: MSG_TEXTURE_SIZE_CHANGED surfaceTexture " + System.identityHashCode(msg.obj) + " width " + msg.arg1 + " height " + msg.arg2);
                }
                this._width = msg.arg1;
                this._height = msg.arg2;
                Object object = this.surfaceTextureMonitor;
                synchronized (object) {
                    if (this._renderer != null && !this.isTextureDecoder) {
                        this._detach();
                        this._destroySurface();
                        this._createSurface();
                        this._attach();
                    }
                    if (Log.isLoggable(this.TAG, 3)) {
                        Log.d(this.TAG, "handleMessage: MSG_TEXTURE_SIZE_CHANGED exit" + this.stateStr());
                    }
                    this.surfaceTextureMonitor.notifyAll();
                    break;
                }
            }
            case 4: {
                if (Log.isLoggable(this.TAG, 3)) {
                    Log.d(this.TAG, "handleMessage: MSG_TEXTURE_DESTROYED enter surfaceTexture " + System.identityHashCode(msg.obj) + this.stateStr());
                }
                this._surfaceTexture.release();
                this._surfaceTexture = null;
                if (this._renderer != null) {
                    this._tryUpdateVisibility(false);
                    this._detach();
                }
                this._destroySurface();
                if (!Log.isLoggable(this.TAG, 3)) break;
                Log.d(this.TAG, "handleMessage: MSG_TEXTURE_DESTROYED exit" + this.stateStr());
                break;
            }
            case 5: {
                SurfaceTextureRenderer renderer;
                if (Log.isLoggable(this.TAG, 3)) {
                    Log.d(this.TAG, "handleMessage: MSG_SET_RENDERER enter renderer " + System.identityHashCode(msg.obj) + this.stateStr());
                }
                if ((renderer = (SurfaceTextureRenderer)msg.obj) != null) {
                    this.isRunning = true;
                    this._renderer = renderer;
                    if (this._surfaceTexture != null && this._surface == null) {
                        this._createSurface();
                    }
                    this._attach();
                    this._tryUpdateVisibility(true);
                } else {
                    if (this._surface != null) {
                        if (this._renderer != null) {
                            this._detach();
                        }
                        this._destroySurface();
                    }
                    this._renderer = null;
                    this._canReceiveFrames = false;
                    this._appliedVisibility = false;
                    Object object = this.stoppedEvent;
                    synchronized (object) {
                        this.isRunning = false;
                        this.stoppedEvent.notify();
                    }
                }
                if (!Log.isLoggable(this.TAG, 3)) break;
                Log.d(this.TAG, "handleMessage: MSG_SET_RENDERER exit renderer " + System.identityHashCode(msg.obj) + this.stateStr());
                break;
            }
            case 1: {
                if (!this.isRunning || this._renderer == null) break;
                this._render();
                break;
            }
            case 7: {
                if (Log.isLoggable(this.TAG, 3)) {
                    Log.d(this.TAG, "handleMessage: MSG_RENDERING_WILL_START enter" + this.stateStr());
                }
                this._canReceiveFrames = true;
                if (this._renderer != null) {
                    this._tryUpdateVisibility(true);
                }
                if (!Log.isLoggable(this.TAG, 3)) break;
                Log.d(this.TAG, "handleMessage: MSG_RENDERING_WILL_START exit" + this.stateStr());
                break;
            }
            case 6: {
                if (Log.isLoggable(this.TAG, 3)) {
                    Log.d(this.TAG, "handleMessage: MSG_STOP_THREAD" + this.stateStr());
                }
                this.thread.quit();
                this.thread = null;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void _tryUpdateVisibility(boolean value) {
        if (this._appliedVisibility != value && this._canReceiveFrames) {
            this._appliedVisibility = value;
            if (Log.isLoggable(this.TAG, 3)) {
                Log.d(this.TAG, "_tryUpdateVisibility: visible " + value + this.stateStr());
            }
            this._renderer.onVisibilityChanged(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createSurface() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "_createSurface() called. isTextureDecoder=" + this.isTextureDecoder + ", _surfaceTexture:" + this._surfaceTexture);
        }
        Object object = this.surfaceTextureMonitor;
        synchronized (object) {
            if (!this.isTextureDecoder) {
                if (Log.isLoggable(this.TAG, 3)) {
                    Log.d(this.TAG, this.simpleClassName + '#' + "Its Buffer decoder. Creating EGL10RenderSurface with _surfaceTexture");
                }
                this._surface = new EGL10RenderSurface();
                this._surface.create(this._surfaceTexture);
                if (!this.isHandlerThreadShared) {
                    this._surface.makeCurrent(true);
                }
            }
        }
    }

    private void _destroySurface() {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.i(this.TAG, this.simpleClassName + '#' + "_destroySurface() called. isTextureDecoder=" + this.isTextureDecoder + ", _surface=" + this._surface);
        }
        if (this._surface != null) {
            this._surface.destroy(this.doReleaseSurfaceThread);
            this._surface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _render() {
        Object object = this.surfaceTextureMonitor;
        synchronized (object) {
            if (!this.isTextureDecoder) {
                if (this._surface != null) {
                    if (this.isHandlerThreadShared) {
                        this._surface.makeCurrent(true);
                    }
                    if (this._renderer.render(this._width, this._height)) {
                        this._surface.swapBuffers();
                    }
                }
            } else {
                boolean bl = this._renderer.render(this._width, this._height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _attach() {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.i(this.TAG, this.simpleClassName + '#' + "_attach() called. isTextureDecoder=" + this.isTextureDecoder + ", _surface=" + this._surface + ", _renderer=" + this._renderer);
        }
        Object object = this.surfaceTextureMonitor;
        synchronized (object) {
            if (Log.isLoggable(this.TAG, 4)) {
                Log.i(this.TAG, "isTextureDecoder=" + this.isTextureDecoder + ", attaching render.");
            }
            Log.i(this.TAG, this.simpleClassName + '#' + "isTextureDecoder=" + this.isTextureDecoder + ", _surface=" + this._surface + ", _renderer=" + this._renderer);
            if (this._surface != null && !this.isTextureDecoder && this.isHandlerThreadShared) {
                this._surface.makeCurrent(true);
            }
            this._renderer.attach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _detach() {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.i(this.TAG, this.simpleClassName + '#' + "_detach() called. isTextureDecoder=" + this.isTextureDecoder + ", _surface=" + this._surface + ", _renderer=" + this._renderer);
        }
        Object object = this.surfaceTextureMonitor;
        synchronized (object) {
            if (Log.isLoggable(this.TAG, 4)) {
                Log.i(this.TAG, "isTextureDecoder=" + this.isTextureDecoder + ", dettaching render.");
            }
            if (this._surface != null && !this.isTextureDecoder && this.isHandlerThreadShared) {
                this._surface.makeCurrent(true);
            }
            this._renderer.detach();
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.i(this.TAG, this.simpleClassName + '#' + "onSurfaceTextureAvailable() called. surfaceTexture " + System.identityHashCode(surface) + " width " + width + " height " + height);
        }
        if (this.listener != null) {
            this.listener.onSurfaceTextureAvailable(this);
        }
        if (this.handler != null) {
            this.handler.sendMessage(this.handler.obtainMessage(2, width, height, (Object)surface));
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.i(this.TAG, this.simpleClassName + '#' + "onSurfaceTextureSizeChanged() called. surfaceTexture " + System.identityHashCode(surface) + " width " + width + " height " + height);
        }
        if (this.handler != null) {
            this.handler.sendMessage(this.handler.obtainMessage(3, width, height, (Object)surface));
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.i(this.TAG, this.simpleClassName + '#' + "onSurfaceTextureDestroyed() called: surfaceTexture " + System.identityHashCode(surface));
        }
        if (this.handler != null) {
            this.handler.sendMessage(this.handler.obtainMessage(4, (Object)surface));
        }
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void requestRender() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "requestRender() called.");
        }
        if (this.handler != null) {
            this.handler.removeMessages(1);
            this.handler.sendEmptyMessage(1);
        }
    }

    public void setRenderer(SurfaceTextureRenderer renderer) {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, "setRenderer " + System.identityHashCode(renderer));
        }
        if (this.handler != null) {
            this.handler.sendMessage(this.handler.obtainMessage(5, (Object)renderer));
        }
    }

    public void start() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "start() called.");
        }
        if (this.handler != null) {
            this.handler.sendEmptyMessage(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "stop() called.");
        }
        Object object = this.stoppedEvent;
        synchronized (object) {
            if (this.isRunning) {
                try {
                    this.stoppedEvent.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void queueEvent(Runnable runnable) {
        if (this.handler != null) {
            this.handler.post(runnable);
        }
    }

    public boolean getReleaseSurfaceThread() {
        return this.doReleaseSurfaceThread;
    }

    public void setReleaseSurfaceThread(boolean doReleaseSurfaceThread) {
        this.doReleaseSurfaceThread = doReleaseSurfaceThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceTexture getSurfaceTexture() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "getSurfaceTexture() called.");
        }
        if (this._surfaceTexture == null) {
            try {
                if (!this.waitForSurfaceTexture(20000L)) {
                    return null;
                }
            }
            catch (InterruptedException e) {
                Log.e(this.TAG, this.simpleClassName + '#' + "getSurfaceTexture wait timed out with InterruptedException: " + e);
                return null;
            }
        }
        Object object = this.surfaceTextureMonitor;
        synchronized (object) {
            this._destroySurface();
            this.isTextureDecoder = true;
        }
        return this._surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForSurfaceTexture(long timeoutMs) throws InterruptedException {
        Object object = this.surfaceTextureMonitor;
        synchronized (object) {
            long expireTimeMs = System.currentTimeMillis() + timeoutMs;
            while (this._surfaceTexture == null) {
                long waitMs = expireTimeMs - System.currentTimeMillis();
                if (waitMs <= 0L) {
                    if (Log.isLoggable(this.TAG, 5)) {
                        Log.w(this.TAG, this.simpleClassName + '#' + "surfaceTextureMonitor wait timed out.");
                    }
                    return false;
                }
                this.surfaceTextureMonitor.wait(waitMs);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableTextureDecoder() {
        if (Log.isLoggable(this.TAG, 4)) {
            Log.d(this.TAG, "disableTextureDecoder");
        }
        Object object = this.surfaceTextureMonitor;
        synchronized (object) {
            this.isTextureDecoder = false;
            if (this._renderer != null) {
                this._detach();
                this._destroySurface();
                this._createSurface();
                this._attach();
            }
            this.surfaceTextureMonitor.notifyAll();
        }
    }

    public static interface SurfaceTextureAvailableListener {
        public void onSurfaceTextureAvailable(TextureView var1);
    }
}

