/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.render;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import com.skype.android.util2.Log;
import com.skype.android.video.render.BindingRenderer;
import com.skype.android.video.render.CapturedFrame;
import com.skype.android.video.render.GLTextureView;
import com.skype.android.video.render.SurfaceTextureRenderer;
import java.util.concurrent.atomic.AtomicInteger;

public final class GLESBindingRenderer
implements BindingRenderer {
    private final String simpleClassName = this.getClass().getSimpleName();
    private long nativePtr;
    private final BindingRenderer.Callback _cb;
    private final String TAG;
    private final AtomicInteger cntPendingRegisterViewCalls = new AtomicInteger(0);
    private final AtomicInteger cntPendingUnregisterViewCalls = new AtomicInteger(0);
    private final Renderer renderer = new Renderer();
    private int lastFrameWidth = 0;
    private int lastFrameHeight = 0;
    private float lastRoiXOffset = 0.0f;
    private float lastRoiYOffset = 0.0f;
    private float lastRoiWidth = 0.0f;
    private float lastRoiHeight = 0.0f;

    public GLESBindingRenderer(BindingRenderer.Callback cb) {
        this.TAG = "" + System.identityHashCode(this);
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "GLESBindingRenderer() called.");
        }
        this._cb = cb;
        this.nativeInit();
    }

    public void checkView(Object view) {
        if (view == null) {
            throw new NullPointerException("view is null");
        }
        if (!(view instanceof GLTextureView)) {
            throw new ClassCastException("view is not of correct type");
        }
    }

    private void checkInvariant(int a, int b) {
        int diff = b - a;
        if (a < -1 || diff < 0 || diff > 1) {
            throw new IllegalStateException("contract violation");
        }
    }

    public void registerView(Object view) {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "registerView() called. view=" + view);
        }
        this.checkView(view);
        this.checkInvariant(this.cntPendingRegisterViewCalls.get(), this.cntPendingUnregisterViewCalls.get());
        this.renderer.setTextureView(view);
        this.cntPendingRegisterViewCalls.incrementAndGet();
    }

    public void unregisterView(Object view) {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "unregisterView() called. view=" + view);
        }
        this.checkView(view);
        this.checkInvariant(this.cntPendingUnregisterViewCalls.get(), this.cntPendingRegisterViewCalls.get());
        this.renderer.setTextureView(null);
        this.cntPendingUnregisterViewCalls.incrementAndGet();
    }

    public Bitmap captureFrame() {
        CapturedFrame result = this.captureFrame2();
        if (result == null) {
            return null;
        }
        return result.bitmap;
    }

    public CapturedFrame captureFrame2() {
        if (!this.renderer.hasView()) {
            return null;
        }
        return this.nativeCaptureFrame();
    }

    public void dispose() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "dispose() called.");
        }
        this.nativeUninit();
    }

    public native int getNativeBindingType();

    public native long getNativeBindingEvent();

    public int getFramesRendered() {
        return this.renderer.getFramesRendered();
    }

    private native void nativeInit();

    private native void nativeUninit();

    private native void attach();

    private native void detach();

    private native boolean queryNextFrame(int var1, int var2);

    private native CapturedFrame nativeCaptureFrame();

    private native void onVisibilityChanged(boolean var1);

    private void onBindingCreated(long bindingRef) {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "onBindingCreated() called. bindingRef=" + bindingRef);
        }
        this.checkInvariant(this.cntPendingRegisterViewCalls.decrementAndGet(), this.cntPendingUnregisterViewCalls.get());
        this.renderer.start();
        this._cb.onBindingCreated(bindingRef);
    }

    private void onBindingReleased() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "onBindingReleased() called.");
        }
        this.checkInvariant(this.cntPendingUnregisterViewCalls.decrementAndGet(), this.cntPendingRegisterViewCalls.get());
        this.renderer.stop();
        this.lastFrameWidth = 0;
        this.lastFrameHeight = 0;
        this.lastRoiXOffset = 0.0f;
        this.lastRoiYOffset = 0.0f;
        this.lastRoiWidth = 0.0f;
        this.lastRoiHeight = 0.0f;
        this._cb.onBindingReleased();
    }

    private void onBindingFailed() {
        if (Log.isLoggable(this.TAG, 6)) {
            Log.e(this.TAG, this.simpleClassName + '#' + "onBindingFailed() called.");
        }
        this.checkInvariant(this.cntPendingRegisterViewCalls.decrementAndGet(), this.cntPendingUnregisterViewCalls.get());
        this._cb.onBindingFailed();
    }

    private boolean onFrameArrived(int width, int height, float roiXOffset, float roiYOffset, float roiWidth, float roiHeight) {
        if (this.lastFrameWidth != width || this.lastFrameHeight != height) {
            this._cb.onSizeChanged(width, height);
            this.lastFrameWidth = width;
            this.lastFrameHeight = height;
        }
        if (this.lastRoiXOffset != roiXOffset || this.lastRoiYOffset != roiYOffset || this.lastRoiWidth != roiWidth || this.lastRoiHeight != roiHeight) {
            this._cb.onRoiChanged(roiXOffset, roiYOffset, roiWidth, roiHeight);
            this.lastRoiXOffset = roiXOffset;
            this.lastRoiYOffset = roiYOffset;
            this.lastRoiWidth = roiWidth;
            this.lastRoiHeight = roiHeight;
        }
        return this.renderer.onFrameArrived(width, height);
    }

    private void onNewFrameReady() {
        this.renderer.onNewFrameReady();
    }

    private void onFirstFrameRendered() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "onFirstFrameRendered() called.");
        }
        this._cb.onFirstFrameRendered();
    }

    public Object onGetRendererSurfaceTexture() {
        if (Log.isLoggable(this.TAG, 3)) {
            Log.d(this.TAG, this.simpleClassName + '#' + "onGetRendererSurfaceTexture() called.");
        }
        SurfaceTexture st = this.renderer.getRendererSurfaceTexture();
        if (Log.isLoggable(this.TAG, 5)) {
            Log.w(this.TAG, this.simpleClassName + '#' + "onGetRendererSurfaceTexture() returned= " + st);
        }
        return st;
    }

    private void onTextureDecoderDisabled() {
        this.renderer.disableTextureDecoder();
    }

    private class Renderer
    implements SurfaceTextureRenderer {
        private GLTextureView view;
        private boolean started = false;
        private int viewWidth;
        private int viewHeight;
        private volatile int numFramesRendered = 0;
        private final String simpleClassName = this.getClass().getSimpleName();

        private Renderer() {
        }

        int getFramesRendered() {
            return this.numFramesRendered;
        }

        boolean hasView() {
            return this.view != null;
        }

        void setTextureView(Object glTextureView) {
            if (Log.isLoggable(GLESBindingRenderer.this.TAG, 3)) {
                Log.d(GLESBindingRenderer.this.TAG, this.simpleClassName + '#' + "setTextureView() called. glTextureView=" + glTextureView + ", view=" + (Object)((Object)this.view));
            }
            if (glTextureView != null && this.view == null && !this.started) {
                this.view = (GLTextureView)((Object)glTextureView);
                this.view.setRenderer(this);
            } else if (glTextureView == null && this.view != null) {
                this.view.setRenderer(null);
                if (!this.started) {
                    this.view = null;
                }
            }
        }

        void start() {
            if (Log.isLoggable(GLESBindingRenderer.this.TAG, 3)) {
                Log.d(GLESBindingRenderer.this.TAG, this.simpleClassName + '#' + "start() called. view=" + (Object)((Object)this.view));
            }
            this.started = true;
            this.view.start();
        }

        void stop() {
            if (Log.isLoggable(GLESBindingRenderer.this.TAG, 3)) {
                Log.d(GLESBindingRenderer.this.TAG, this.simpleClassName + '#' + "stop() called. view=" + (Object)((Object)this.view));
            }
            this.started = false;
            this.view.stop();
            this.view = null;
        }

        SurfaceTexture getRendererSurfaceTexture() {
            if (Log.isLoggable(GLESBindingRenderer.this.TAG, 3)) {
                Log.d(GLESBindingRenderer.this.TAG, this.simpleClassName + '#' + "getRendererSurfaceTexture() called. view=" + (Object)((Object)this.view));
            }
            return this.view.getSurfaceTexture();
        }

        void disableTextureDecoder() {
            if (Log.isLoggable(GLESBindingRenderer.this.TAG, 3)) {
                Log.d(GLESBindingRenderer.this.TAG, this.getClass().getSimpleName() + '#' + "disableTextureDecoder() called. view=" + (Object)((Object)this.view));
            }
            this.view.disableTextureDecoder();
        }

        boolean onFrameArrived(int width, int height) {
            return true;
        }

        void onNewFrameReady() {
            this.view.requestRender();
        }

        public boolean render(int viewWidth, int viewHeight) {
            this.viewWidth = viewWidth;
            this.viewHeight = viewHeight;
            boolean retval = GLESBindingRenderer.this.queryNextFrame(viewWidth, viewHeight);
            if (retval) {
                ++this.numFramesRendered;
            }
            return retval;
        }

        public void attach() {
            if (Log.isLoggable(GLESBindingRenderer.this.TAG, 3)) {
                Log.d(GLESBindingRenderer.this.TAG, this.simpleClassName + '#' + "attach() called.");
            }
            GLESBindingRenderer.this.attach();
        }

        public void detach() {
            if (Log.isLoggable(GLESBindingRenderer.this.TAG, 3)) {
                Log.d(GLESBindingRenderer.this.TAG, this.simpleClassName + '#' + "detach() called.");
            }
            GLESBindingRenderer.this.detach();
        }

        public void onVisibilityChanged(boolean isVisible) {
            if (Log.isLoggable(GLESBindingRenderer.this.TAG, 3)) {
                Log.d(GLESBindingRenderer.this.TAG, this.simpleClassName + '#' + "onVisibilityChanged() called.");
            }
            GLESBindingRenderer.this.onVisibilityChanged(isVisible);
        }
    }
}

