/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import com.azure.android.communication.calling.CameraFacing;
import com.azure.android.communication.calling.CreateViewOptions;
import com.azure.android.communication.calling.DeviceProfile;
import com.azure.android.communication.calling.IInternalPreviewRenderer;
import com.azure.android.communication.calling.Log;
import com.azure.android.communication.calling.ScalingMode;
import com.azure.android.communication.calling.VideoOrientationManager;
import com.azure.android.communication.calling.VideoStreamRenderer;
import com.azure.android.communication.calling.ViewScaleHelper;
import com.skype.android.video.render.GLTextureView;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressLint(value={"ViewConstructor"})
public final class VideoStreamRendererView
extends FrameLayout
implements TextureView.SurfaceTextureListener,
IInternalPreviewRenderer.Callback,
VideoOrientationManager.OrientationChangedCallback {
    private static final String TAG = "VideoStreamRendererView";
    private static final Random random = new Random();
    private static Point videoDimensions;
    private static boolean receivedFrameSizeChangedEvent;
    private TextureView view;
    private boolean isDetachingVideo = false;
    private boolean isSurfaceDestroyedButNotCleanedUp = false;
    private CameraFacing cameraFacing = CameraFacing.UNKNOWN;
    private boolean scaleToFit = false;
    private SurfaceTexture surfaceTexture;
    private final Object surfaceTextureLock = new Object();
    private Path clipPath = new Path();
    private Point panOffset = new Point(0, 0);
    private VideoOrientationManager videoOrientationManager;
    private VideoStreamRenderer renderer;
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private GLTextureView remoteView;
    private int videoWidth;
    private int videoHeight;

    VideoStreamRendererView(VideoStreamRenderer renderer, VideoOrientationManager videoOrientationManager, CreateViewOptions options, Context context) {
        super(context);
        this.initCommon(renderer, videoOrientationManager, options);
    }

    VideoStreamRendererView(VideoStreamRenderer renderer, CreateViewOptions options, Context context) {
        super(context);
        this.initCommon(renderer, null, options);
        renderer.addListener(new RemoteVideoEventListener());
        this.remoteView = renderer.createView(new GLTextureAvailableListener());
        this.remoteView.setVisibility(0);
        this.remoteView.layout(0, 0, this.getWidth(), this.getHeight());
        this.addView((View)this.remoteView);
    }

    private void initCommon(VideoStreamRenderer renderer, VideoOrientationManager videoOrientationManager, CreateViewOptions options) {
        this.setClipChildren(true);
        this.setClipToOutlineCompat(true);
        if (videoDimensions == null) {
            DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
            videoDimensions = new Point(metrics.widthPixels, metrics.heightPixels);
            Log.debug1(TAG, "Initialized videoDimensions are %d x %d", VideoStreamRendererView.videoDimensions.x, VideoStreamRendererView.videoDimensions.y);
        }
        this.scaleToFit = options.getScalingMode() == ScalingMode.FIT;
        this.videoOrientationManager = videoOrientationManager;
        this.renderer = renderer;
    }

    void attachVideo(CameraFacing cameraFacing, int causeId) {
        this.cameraFacing = cameraFacing;
        Log.debug1(TAG, "attachVideo, camera: %s causeId: 0x%08x", new Object[]{this.cameraFacing, causeId});
        this.videoOrientationManager.addCallback(this);
        this.videoOrientationManager.start();
        TextureView textureView = new TextureView(this.getContext());
        textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        this.view = textureView;
        textureView.setVisibility(0);
        textureView.layout(0, 0, this.getRight(), this.getBottom());
        this.addView((View)textureView);
        this.scaleView(causeId);
        Log.debug1(TAG, "attachVideo default videoDimensions %d x %d causeId: 0x%08x", VideoStreamRendererView.videoDimensions.x, VideoStreamRendererView.videoDimensions.y, causeId);
    }

    public void updateScalingMode(ScalingMode scalingMode) {
        boolean fit = scalingMode == ScalingMode.FIT;
        int causeId = random.nextInt();
        Log.debug1(TAG, "setScalingMode, fit: %b w: %d h: %d causeId: 0x%08x", fit, this.getWidth(), this.getHeight(), causeId);
        this.updateAspectRatio(fit, causeId);
    }

    private void updateAspectRatio(boolean fit, int causeId) {
        Log.debug1(TAG, "updateAspectRatio, fit: %b w: %d h: %d causeId: 0x%08x", fit, this.getWidth(), this.getHeight(), causeId);
        this.scaleToFit = fit;
        this.scaleView(causeId);
    }

    public void dispose() {
        this.dispose(random.nextInt());
    }

    public boolean isRendering() {
        return this.renderer.isRendering();
    }

    void dispose(int causeId) {
        if (this.disposed.compareAndSet(false, true)) {
            Log.debug1(TAG, "dispose causeId: 0x%08x", causeId);
            this.detachVideo(causeId);
        } else {
            Log.debug1(TAG, "Already disposed causeId: 0x%08x", causeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachVideo(int causeId) {
        Log.debug1(TAG, "detachVideo causeId: 0x%08x", causeId);
        this.isDetachingVideo = true;
        if (this.videoOrientationManager != null) {
            this.videoOrientationManager.removeCallback(this);
            this.videoOrientationManager.stop();
        }
        if (this.view != null) {
            Handler uiHandler = new Handler(Looper.getMainLooper());
            uiHandler.post(() -> this.removeView((View)this.view));
        }
        Object object = this.surfaceTextureLock;
        synchronized (object) {
            if (this.isSurfaceDestroyedButNotCleanedUp) {
                Log.debug1(TAG, "detachVideo called when surface was already destroyed; cleaning up causeId: 0x%08x", causeId);
                this.cleanupSurfaceTexture(causeId);
            }
        }
    }

    private Point adjustedVideoDimensionsForDisplay(int causeId) {
        if (this.view == null) {
            return videoDimensions;
        }
        int rotation = this.videoOrientationManager.getDisplayOrientation();
        if (!receivedFrameSizeChangedEvent) {
            if (rotation == 90 || rotation == 270) {
                Log.debug1(TAG, "adjustedVideoDimensionsForDisplay landscape -> %d x %d causeId: 0x%08x", VideoStreamRendererView.videoDimensions.x, VideoStreamRendererView.videoDimensions.y, causeId);
                return new Point(VideoStreamRendererView.videoDimensions.y, VideoStreamRendererView.videoDimensions.x);
            }
            Log.debug1(TAG, "adjustedVideoDimensionsForDisplay default -> %d x %d causeId: 0x%08x", VideoStreamRendererView.videoDimensions.x, VideoStreamRendererView.videoDimensions.y, causeId);
            return videoDimensions;
        }
        if (DeviceProfile.changePreviewDimensions(this.cameraFacing, rotation)) {
            Log.debug1(TAG, "adjustedVideoDimensionsForDisplay rotating for camera -> %d x %d causeId: 0x%08x", VideoStreamRendererView.videoDimensions.y, VideoStreamRendererView.videoDimensions.x, causeId);
            return new Point(VideoStreamRendererView.videoDimensions.y, VideoStreamRendererView.videoDimensions.x);
        }
        Log.debug1(TAG, "adjustedVideoDimensionsForDisplay no change -> %d x %d causeId: 0x%08x", VideoStreamRendererView.videoDimensions.x, VideoStreamRendererView.videoDimensions.y, causeId);
        return videoDimensions;
    }

    protected void scaleView(int causeId) {
        if (this.view != null) {
            Point adjustedVideoDimensions = this.adjustedVideoDimensionsForDisplay(causeId);
            Log.debug1(TAG, "scaleView width: %d height: %d displayWidth: %d displayHeight: %d scaleToFit: %b panOffset: %s causeId: 0x%08x ", this.getWidth(), this.getHeight(), adjustedVideoDimensions.x, adjustedVideoDimensions.y, this.scaleToFit, this.panOffset, causeId);
            ViewScaleHelper.scaleView(this.view, this.getWidth(), this.getHeight(), adjustedVideoDimensions.x, adjustedVideoDimensions.y, this.scaleToFit, this.panOffset);
        } else {
            Log.debug1(TAG, "scaleView getWidth(): %d getHeight(): %d videoWidth: %d videoHeight: %d scaleToFit: %b panOffset: %s causeId: 0x%08x ", this.getWidth(), this.getHeight(), this.videoWidth, this.videoHeight, this.scaleToFit, this.panOffset, causeId);
            if (this.videoWidth != 0 && this.videoHeight != 0) {
                ViewScaleHelper.scaleView((TextureView)this.remoteView, this.getWidth(), this.getHeight(), this.videoWidth, this.videoHeight, this.scaleToFit, this.panOffset);
            }
        }
    }

    private void handleVideoSizeChanged(int width, int height, int causeId) {
        Log.debug1(TAG, "handleVideoSizeChanged, w: %d h: %d causeId: 0x%08x", width, height, causeId);
        if (this.view == null) {
            return;
        }
        videoDimensions.set(width, height);
        receivedFrameSizeChangedEvent = true;
        this.updateAspectRatio(this.scaleToFit, causeId);
    }

    protected void onAttachedToWindow() {
        Log.debug1(TAG, "onAttachedToWindow", new Object[0]);
        if (this.view != null && this.surfaceTexture != null && this.view.getSurfaceTexture() != this.surfaceTexture) {
            this.view.setSurfaceTexture(this.surfaceTexture);
        }
        super.onAttachedToWindow();
    }

    @Override
    public void onOrientationChanged(int causeId) {
        if (this.view != null) {
            this.scaleView(causeId);
        } else {
            Log.debug1(TAG, "onOrientationChanged view is null causeId: 0x%08x", causeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Object object = this.surfaceTextureLock;
        synchronized (object) {
            int causeId = random.nextInt();
            Log.debug1(TAG, "onSurfaceTextureAvailable, w: %d h: %d causeId: 0x%08x", width, height, causeId);
            this.surfaceTexture = surface;
            this.renderer.onSurfaceTextureAvailable(surface);
            this.scaleView(causeId);
            this.isSurfaceDestroyedButNotCleanedUp = false;
            if (videoDimensions != null) {
                this.handleVideoSizeChanged(VideoStreamRendererView.videoDimensions.x, VideoStreamRendererView.videoDimensions.y, causeId);
            }
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        int causeId = random.nextInt();
        Log.debug1(TAG, "onSurfaceTextureSizeChanged w: %d h: %d causeId: 0x%08x", width, height, causeId);
        this.scaleView(causeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        Object object = this.surfaceTextureLock;
        synchronized (object) {
            int causeId = random.nextInt();
            Log.debug1(TAG, "onSurfaceTextureDestroyed causeId: 0x%08x", causeId);
            if (this.isDetachingVideo) {
                this.renderer.onSurfaceTextureDestroyed(surface);
                this.cleanupSurfaceTexture(causeId);
            } else {
                Log.debug1(TAG, "Received onSurfaceDestroyed while isDetachingVideo was false; setting isSurfaceDestroyedButNotCleanedUp to true causeId: 0x%08x", causeId);
                this.isSurfaceDestroyedButNotCleanedUp = true;
            }
            return this.surfaceTexture == null;
        }
    }

    private void cleanupSurfaceTexture(int causeId) {
        Log.debug1(TAG, "cleanupSurfaceTexture causeId: 0x%08x", causeId);
        this.view.setSurfaceTextureListener(null);
        this.isDetachingVideo = false;
        this.isSurfaceDestroyedButNotCleanedUp = false;
        if (this.surfaceTexture != null) {
            Log.debug1(TAG, "cleanupSurfaceTexture release causeId: 0x%08x", causeId);
            this.surfaceTexture.release();
            this.surfaceTexture = null;
        } else {
            Log.warn(TAG, "cleanupSurfaceTexture could not release - was already null causeId: 0x%08x", causeId);
        }
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    private static CameraFacing VideoCameraPositionToFacing(int index) {
        if (index == 1) {
            return CameraFacing.FRONT;
        }
        if (index == 2) {
            return CameraFacing.BACK;
        }
        return CameraFacing.UNKNOWN;
    }

    private void setClipToOutlineCompat(boolean clip) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(clip);
        }
    }

    @Override
    public void onFrameSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        this.post(() -> {
            int causeId = random.nextInt();
            Log.debug1(TAG, "onFrameSizeChanged width: %d, height: %d causeId: 0x%08x", width, height, causeId);
            this.handleVideoSizeChanged(width, height, causeId);
            if (this.view != null) {
                this.scaleView(causeId);
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int causeId = random.nextInt();
        Log.debug1(TAG, "onSizeChanged w: %d, h: %d, oldw: %d, oldh: %d, causeId: 0x%08x", w, h, oldw, oldh, causeId);
        this.scaleView(causeId);
    }

    @Override
    public void onPreviewSurfaceUnset(SurfaceTexture surfaceTexture) {
    }

    static {
        receivedFrameSizeChangedEvent = false;
    }

    class RemoteVideoEventListener
    implements VideoStreamRenderer.RemoteVideoEventListener {
        RemoteVideoEventListener() {
        }

        @Override
        public void onSizeChanged(int w, int h, int causeId) {
            Log.debug1(VideoStreamRendererView.TAG, "onSizeChanged(), causeId: 0x%08x", causeId);
            VideoStreamRendererView.this.videoWidth = w;
            VideoStreamRendererView.this.videoHeight = h;
            VideoStreamRendererView.this.updateAspectRatio(VideoStreamRendererView.this.scaleToFit, causeId);
        }
    }

    class GLTextureAvailableListener
    implements GLTextureView.SurfaceTextureAvailableListener {
        GLTextureAvailableListener() {
        }

        public void onSurfaceTextureAvailable(TextureView textureView) {
            int causeId = random.nextInt();
            Log.debug1(VideoStreamRendererView.TAG, "onSurfaceTextureAvailable(), causeId: 0x%08x", causeId);
            VideoStreamRendererView.this.scaleView(causeId);
        }
    }
}

