/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.VideoDeviceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class VideoDevicesUpdatedEvent {
    long handle;

    VideoDevicesUpdatedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_video_devices_updated_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_devices_updated_event_args_release(this.handle));
        this.handle = 0L;
    }

    public List<VideoDeviceInfo> getAddedVideoDevices() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_devices_updated_event_args_get_added_video_devices(this.handle, result, result_length));
        ArrayList<VideoDeviceInfo> resultList = new ArrayList<VideoDeviceInfo>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(ProjectedObjectCache.getOrCreate(resultArray[i], ModelClass.VideoDeviceInfo, VideoDeviceInfo.class, true));
        }
        List<VideoDeviceInfo> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public List<VideoDeviceInfo> getRemovedVideoDevices() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_devices_updated_event_args_get_removed_video_devices(this.handle, result, result_length));
        ArrayList<VideoDeviceInfo> resultList = new ArrayList<VideoDeviceInfo>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(ProjectedObjectCache.getOrCreate(resultArray[i], ModelClass.VideoDeviceInfo, VideoDeviceInfo.class, true));
        }
        List<VideoDeviceInfo> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }
}

