/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.RemoteParticipant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ParticipantsUpdatedEvent {
    long handle;

    ParticipantsUpdatedEvent(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_participants_updated_event_args_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_participants_updated_event_args_release(this.handle));
        this.handle = 0L;
    }

    public List<RemoteParticipant> getAddedParticipants() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_participants_updated_event_args_get_added_participants(this.handle, result, result_length));
        ArrayList<RemoteParticipant> resultList = new ArrayList<RemoteParticipant>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(ProjectedObjectCache.getOrCreate(resultArray[i], ModelClass.RemoteParticipant, RemoteParticipant.class, true));
        }
        List<RemoteParticipant> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }

    public List<RemoteParticipant> getRemovedParticipants() {
        Out<long[]> result = new Out<long[]>();
        Out<Integer> result_length = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_participants_updated_event_args_get_removed_participants(this.handle, result, result_length));
        ArrayList<RemoteParticipant> resultList = new ArrayList<RemoteParticipant>();
        long[] resultArray = (long[])result.value;
        for (int i = 0; i < resultArray.length; ++i) {
            resultList.add(ProjectedObjectCache.getOrCreate(resultArray[i], ModelClass.RemoteParticipant, RemoteParticipant.class, true));
        }
        List<RemoteParticipant> resultImmutable = Collections.unmodifiableList(resultList);
        return resultImmutable;
    }
}

