/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallingCommunicationErrors;
import com.azure.android.communication.calling.CallingCommunicationException;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.status;
import java.util.NoSuchElementException;

class NativeLibraryHelpers {
    NativeLibraryHelpers() {
    }

    static void checkStatus(status value) {
        if (value == status.OK) {
            return;
        }
        String fullMessage = "";
        switch (value) {
            case OK: {
                return;
            }
            case FAILED: {
                throw new IllegalStateException(fullMessage);
            }
            case OBJECT_DISPOSED: {
                throw new IllegalStateException(fullMessage);
            }
            case OUT_OF_MEMORY: {
                throw new OutOfMemoryError(fullMessage);
            }
            case INVALID_ARGUMENT: {
                throw new IllegalArgumentException(fullMessage);
            }
            case OUT_OF_RANGE: {
                throw new IndexOutOfBoundsException(fullMessage);
            }
            case NOT_IMPLEMENTED: {
                throw new UnsupportedOperationException(fullMessage);
            }
            case KEY_NOT_FOUND: {
                throw new NoSuchElementException(fullMessage);
            }
            case NONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NONE, "", "", "");
            }
            case NO_AUDIO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_PERMISSION, "", "", "");
            }
            case NO_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_VIDEO_PERMISSION, "", "", "");
            }
            case NO_AUDIO_AND_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_AND_VIDEO_PERMISSION, "", "", "");
            }
            case RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD, "", "", "");
            }
            case FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD, "", "", "");
            }
            case INVALID_GUID_GROUP_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_GUID_GROUP_ID, "", "", "");
            }
            case INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN, "", "", "");
            }
            case MULTIPLE_RENDERERS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED, "", "", "");
            }
            case MULTIPLE_VIEWS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED, "", "", "");
            }
            case INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS, "", "", "");
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY, "", "", "");
            }
            case INVALID_SERVER_CALL_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_SERVER_CALL_ID, "", "", "");
            }
            case LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE, "", "", "");
            }
            case INCOMING_CALL_ALREADY_UNPLACED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INCOMING_CALL_ALREADY_UNPLACED, "", "", "");
            }
            case INVALID_MEETING_LINK: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_MEETING_LINK, "", "", "");
            }
            case PARTICIPANT_ADDED_TO_UNCONNECTED_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ADDED_TO_UNCONNECTED_CALL, "", "", "");
            }
            case PARTICIPANT_ALREADY_ADDED_TO_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ALREADY_ADDED_TO_CALL, "", "", "");
            }
            case CALL_FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CALL_FEATURE_EXTENSION_NOT_FOUND, "", "", "");
            }
        }
    }

    static void checkStatus(long handle, status value) {
        String fullMessage;
        if (value == status.OK) {
            return;
        }
        Out<String> outParam_message = new Out<String>();
        Out<String> outParam_requestCorrelationVector = new Out<String>();
        Out<String> outParam_responseCorrelationVector = new Out<String>();
        status code = NativeLibrary.sam_get_error_details(handle, outParam_message, outParam_requestCorrelationVector, outParam_responseCorrelationVector);
        if (code == status.FAILED) {
            throw new IllegalStateException("Unexpected error in exception handling.");
        }
        if (code != status.OK) {
            fullMessage = "Exception thrown and an unexpected error in exception handling.";
        } else {
            fullMessage = (String)outParam_message.value + ".";
            if (outParam_requestCorrelationVector.value != null && !((String)outParam_requestCorrelationVector.value).isEmpty()) {
                fullMessage = fullMessage + " Request CV: " + (String)outParam_requestCorrelationVector.value + ".";
            }
            if (outParam_responseCorrelationVector.value != null && !((String)outParam_responseCorrelationVector.value).isEmpty()) {
                fullMessage = fullMessage + " Response CV: " + (String)outParam_responseCorrelationVector.value + ".";
            }
        }
        switch (value) {
            case OK: {
                return;
            }
            case FAILED: {
                throw new IllegalStateException(fullMessage);
            }
            case OBJECT_DISPOSED: {
                throw new IllegalStateException(fullMessage);
            }
            case OUT_OF_MEMORY: {
                throw new OutOfMemoryError(fullMessage);
            }
            case INVALID_ARGUMENT: {
                throw new IllegalArgumentException(fullMessage);
            }
            case OUT_OF_RANGE: {
                throw new IndexOutOfBoundsException(fullMessage);
            }
            case NOT_IMPLEMENTED: {
                throw new UnsupportedOperationException(fullMessage);
            }
            case KEY_NOT_FOUND: {
                throw new NoSuchElementException(fullMessage);
            }
            case NONE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NONE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_AUDIO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_PERMISSION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_VIDEO_PERMISSION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_AUDIO_AND_VIDEO_PERMISSION: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_AUDIO_AND_VIDEO_PERMISSION, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.RECEIVED_INVALID_PUSH_NOTIFICATION_PAYLOAD, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD: {
                throw new CallingCommunicationException(CallingCommunicationErrors.FAILED_TO_PROCESS_PUSH_NOTIFICATION_PAYLOAD, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_GUID_GROUP_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_GUID_GROUP_ID, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_PUSH_NOTIFICATION_DEVICE_REGISTRATION_TOKEN, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MULTIPLE_RENDERERS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_RENDERERS_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case MULTIPLE_VIEWS_NOT_SUPPORTED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.MULTIPLE_VIEWS_NOT_SUPPORTED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_LOCAL_VIDEO_STREAM_FOR_VIDEO_OPTIONS, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY: {
                throw new CallingCommunicationException(CallingCommunicationErrors.NO_MULTIPLE_CONNECTIONS_WITH_SAME_IDENTITY, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_SERVER_CALL_ID: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_SERVER_CALL_ID, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE: {
                throw new CallingCommunicationException(CallingCommunicationErrors.LOCAL_VIDEO_STREAM_SWITCH_SOURCE_FAILURE, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INCOMING_CALL_ALREADY_UNPLACED: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INCOMING_CALL_ALREADY_UNPLACED, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case INVALID_MEETING_LINK: {
                throw new CallingCommunicationException(CallingCommunicationErrors.INVALID_MEETING_LINK, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case PARTICIPANT_ADDED_TO_UNCONNECTED_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ADDED_TO_UNCONNECTED_CALL, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case PARTICIPANT_ALREADY_ADDED_TO_CALL: {
                throw new CallingCommunicationException(CallingCommunicationErrors.PARTICIPANT_ALREADY_ADDED_TO_CALL, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
            case CALL_FEATURE_EXTENSION_NOT_FOUND: {
                throw new CallingCommunicationException(CallingCommunicationErrors.CALL_FEATURE_EXTENSION_NOT_FOUND, (String)outParam_message.value, (String)outParam_requestCorrelationVector.value, (String)outParam_responseCorrelationVector.value);
            }
        }
    }
}

