/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import android.content.Context;
import com.azure.android.communication.calling.AcceptCallOptions;
import com.azure.android.communication.calling.AudioOptions;
import com.azure.android.communication.calling.Call;
import com.azure.android.communication.calling.CallEndReason;
import com.azure.android.communication.calling.CallerInfo;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.PermissionUtility;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectEventHandlerCache;
import com.azure.android.communication.calling.PropertyChangedEvent;
import com.azure.android.communication.calling.PropertyChangedListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Supplier;

public final class IncomingCall {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    long handle;
    private List<PropertyChangedListener> OnCallEndedListeners = new ArrayList<PropertyChangedListener>();

    IncomingCall(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_incoming_call_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    IncomingCall(long ahandle, boolean transfer, boolean restoreEventHandlers) {
        this(ahandle, transfer);
        if (restoreEventHandlers) {
            this.restoreEventHandlers();
        }
    }

    long getHandle() {
        return this.handle;
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_call_release(this.handle));
        this.handle = 0L;
    }

    public CallEndReason getCallEndReason() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_call_get_call_end_reason(this.handle, result_handle));
        CallEndReason result_object = (Long)result_handle.value != 0L ? ProjectedObjectCache.getOrCreate((Long)result_handle.value, ModelClass.CallEndReason, CallEndReason.class, true) : null;
        return result_object;
    }

    public CallerInfo getCallerInfo() {
        Out<Long> result_handle = new Out<Long>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_call_get_caller_info(this.handle, result_handle));
        CallerInfo result_object = (Long)result_handle.value != 0L ? ProjectedObjectCache.getOrCreate((Long)result_handle.value, ModelClass.CallerInfo, CallerInfo.class, true) : null;
        return result_object;
    }

    public String getId() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_call_get_id(this.handle, result));
        return (String)result.value;
    }

    public boolean isVideoEnabled() {
        Out<Boolean> result = new Out<Boolean>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_call_get_is_video_enabled(this.handle, result));
        return (Boolean)result.value;
    }

    private static void OnCallEndedStaticHandler(long cookie, long args) {
        IncomingCall instance = IncomingCall.getInstance(cookie);
        if (instance != null) {
            PropertyChangedEvent args_converted = args != 0L ? ProjectedObjectCache.getOrCreate(args, ModelClass.PropertyChangedEvent, PropertyChangedEvent.class, false) : null;
            for (PropertyChangedListener listener : instance.OnCallEndedListeners) {
                listener.onPropertyChanged(args_converted);
            }
        }
    }

    public void addOnCallEndedListener(PropertyChangedListener listener) {
        this.OnCallEndedListeners.add(listener);
        ProjectedObjectEventHandlerCache.addEventHandler(this, this.getHandle(), "OnCallEnded", listener);
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_incoming_call_set_on_call_ended(this.handle, this.getHandle(), this));
    }

    public void removeOnCallEndedListener(PropertyChangedListener listener) {
        this.OnCallEndedListeners.remove(listener);
        ProjectedObjectEventHandlerCache.removeEventHandler(this, this.getHandle(), "OnCallEnded", listener);
    }

    private CompletableFuture<Call> acceptWithContext(final Context context, final AcceptCallOptions options) {
        final long handle = this.handle;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<Call>(){

            public Call get() {
                long options_converted = options != null ? options.getHandle() : 0L;
                Out<Long> result_handle = new Out<Long>();
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_incoming_call_accept_with_context(handle, context, options_converted, result_handle));
                Call result_object = ProjectedObjectCache.getOrCreate((Long)result_handle.value, ModelClass.Call, Call.class, true);
                return result_object;
            }
        }, (Executor)executor);
    }

    public CompletableFuture<Void> reject() {
        final long handle = this.handle;
        return CompletableFuture.runAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                NativeLibraryHelpers.checkStatus(handle, NativeLibrary.sam_incoming_call_reject(handle));
            }
        }, (Executor)executor);
    }

    private static IncomingCall getInstance(long cookie) {
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.IncomingCall, IncomingCall.class, false);
    }

    void restoreEventHandlers() {
        for (Object eventListener : ProjectedObjectEventHandlerCache.getEventHandlers(this, this.getHandle(), "OnCallEnded")) {
            this.addOnCallEndedListener((PropertyChangedListener)eventListener);
        }
    }

    public CompletableFuture<Call> accept(Context context, AcceptCallOptions acceptCallOptions) {
        PermissionUtility.throwIfNotAppropriatePermissions(context, acceptCallOptions != null ? acceptCallOptions.getVideoOptions() : null, new AudioOptions().setMuted(false));
        return this.acceptWithContext(context, acceptCallOptions);
    }

    public CompletableFuture<Call> accept(Context context) {
        return this.accept(context, new AcceptCallOptions());
    }
}

